/*
 * Decompiled with CFR 0.152.
 */
package act.db.morphia.util;

import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.mongodb.morphia.converters.SimpleValueConverter;
import org.mongodb.morphia.converters.TypeConverter;
import org.mongodb.morphia.mapping.MappedField;

public class JodaDateTimeConverter
extends TypeConverter
implements SimpleValueConverter {
    public JodaDateTimeConverter() {
        this.setSupportedTypes(new Class[]{DateTime.class, LocalDate.class, LocalDateTime.class, LocalTime.class});
    }

    public Object decode(Class<?> targetClass, Object fromDBObject, MappedField optionalExtraInfo) {
        if (null == fromDBObject) {
            return null;
        }
        Long instant = (Long)fromDBObject;
        if (targetClass == DateTime.class) {
            return new DateTime((Object)instant);
        }
        if (targetClass == LocalDateTime.class) {
            return new LocalDateTime((Object)instant);
        }
        if (targetClass == LocalDate.class) {
            return new LocalDate((Object)instant);
        }
        if (targetClass == LocalTime.class) {
            return new LocalTime((Object)instant);
        }
        assert (false);
        return null;
    }

    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (null == value) {
            return null;
        }
        if (value instanceof DateTime) {
            DateTime dateTime = (DateTime)value;
            return dateTime.getMillis();
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            return localDateTime.toDateTime().getMillis();
        }
        if (value instanceof LocalDate) {
            LocalDate localDate = (LocalDate)value;
            return localDate.toDateTimeAtStartOfDay().getMillis();
        }
        if (value instanceof LocalTime) {
            LocalTime localTime = (LocalTime)value;
            return localTime.toDateTime((ReadableInstant)new DateTime(0L)).getMillis();
        }
        assert (false);
        return null;
    }
}

