/*
 * Decompiled with CFR 0.152.
 */
package act.db.morphia.util;

import act.db.morphia.MorphiaService;
import com.mongodb.BasicDBObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.util.S;

public class AggregationResult {
    private List<BasicDBObject> result = null;
    private Class<?> modelType = null;
    private String field = null;

    public AggregationResult(List<BasicDBObject> r, String aggregationField, Class<?> modelClass) {
        if (null == r || null == aggregationField) {
            throw new NullPointerException();
        }
        this.result = r;
        this.modelType = modelClass;
        this.field = aggregationField;
    }

    public Long getDefault() {
        return this.result.size() > 0 ? Long.valueOf(this.result.get(0).getLong(this.field)) : null;
    }

    public Long get(Object ... groupValues) {
        if (groupValues.length == 0) {
            return this.getDefault();
        }
        int len = groupValues.length;
        for (BasicDBObject r : this.result) {
            int i = 0;
            boolean found = true;
            for (Map.Entry entry : r.entrySet()) {
                if (i >= len || !$.ne(entry.getValue(), (Object)groupValues[i++])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return r.getLong(this.field);
        }
        return null;
    }

    public Long getByGroupKeys(String groupKeys, Object ... groupValues) {
        if (S.empty((String)groupKeys)) {
            if (groupValues.length == 0) {
                return this.getDefault();
            }
            throw new IllegalArgumentException("the number of group keys does not match the number of group values");
        }
        String[] sa = groupKeys.split("[\\s,;:]+");
        if (sa.length != groupValues.length) {
            throw new IllegalArgumentException("the number of group keys does not match the number of group values");
        }
        HashSet<String> mappedKeys = new HashSet<String>();
        for (String key : sa) {
            mappedKeys.add(this.mappedName(key));
        }
        for (BasicDBObject r : this.result) {
            boolean found = true;
            for (int i = 0; i < sa.length; ++i) {
                String groupKey = sa[i];
                String mappedGroupKey = this.mappedName(groupKey);
                Object groupValue = groupValues[i];
                if (!$.ne((Object)r.get(groupKey), (Object)groupValue) || !$.ne((Object)r.get(mappedGroupKey), (Object)groupValue)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return r.getLong(this.field);
        }
        return null;
    }

    public Map<String, Long> asNumberMap() {
        HashMap<String, Long> m = new HashMap<String, Long>(this.result.size());
        for (BasicDBObject r : this.result) {
            Collection c = r.values();
            Iterator itr = c.iterator();
            String k = itr.next().toString();
            String s = itr.next().toString();
            float f = Float.parseFloat(s);
            long l = (long)f;
            m.put(k, l);
        }
        return m;
    }

    public List<BasicDBObject> raw() {
        return this.result;
    }

    private String mappedName(String field) {
        return MorphiaService.mappedName(field, this.modelType);
    }
}

