/*
 * Decompiled with CFR 0.152.
 */
package act.db.morphia;

import act.Act;
import act.app.App;
import act.app.DbServiceManager;
import act.db.DB;
import act.db.Dao;
import act.db.DbService;
import act.db.morphia.ClientManager;
import act.db.morphia.ExternalModelAdaptor;
import act.db.morphia.MorphiaDao;
import act.db.morphia.MorphiaDaoBase;
import act.db.morphia.MorphiaDaoWithLongId;
import act.db.morphia.MorphiaModel;
import act.db.morphia.MorphiaModelBase;
import act.db.morphia.MorphiaModelWithLongId;
import act.db.morphia.MorphiaPlugin;
import act.db.morphia.util.FastJsonObjectIdCodec;
import act.util.FastJsonIterableSerializer;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoInterruptedException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.ObjectFactory;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.mapping.DefaultCreator;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.MapperOptions;
import org.mongodb.morphia.query.MorphiaIterator;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.bootstrap.Version;
import org.osgl.util.E;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

public class MorphiaService
extends DbService {
    public static final Version VERSION = MorphiaPlugin.VERSION;
    public static final String QUERY_SEP = "[,;:]+";
    public static final String GROUP_SEP = "[,;:\\s]+";
    private Morphia morphia = new Morphia();
    private Datastore ds;
    private boolean initialized;
    private Map<Class, Map<String, String>> fieldNameLookup;

    public MorphiaService(String id, final App app, Map<String, String> conf) {
        super(id, app);
        MapperOptions options = this.morphia.getMapper().getOptions();
        options.setObjectFactory((ObjectFactory)new DefaultCreator(){

            protected ClassLoader getClassLoaderForClass() {
                return app.classLoader();
            }
        });
        this.fieldNameLookup = new HashMap<Class, Map<String, String>>();
        Osgl.T2<MongoClientURI, MongoClient> t2 = ClientManager.register(this, conf);
        this.initDataStore(t2, conf);
        this.delayedEnsureIndexesAndCaps(app);
        this.delayedMapExternalModels(app);
        this.registerFastJsonConfig();
        app.resolverManager().register(ObjectId.class, (StringValueResolver)new StringValueResolver<ObjectId>(){

            public ObjectId resolve(String s) {
                return S.blank((String)s) ? null : new ObjectId(s);
            }
        });
        this.initialized = true;
    }

    public boolean initialized() {
        return this.initialized;
    }

    protected void releaseResources() {
        ClientManager.release(this);
        this.fieldNameLookup.clear();
        this.morphia = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Morphia shutdown: %s", new Object[]{this.id()});
        }
    }

    public <DAO extends Dao> DAO defaultDao(Class<?> modelType) {
        Type type;
        if (MorphiaModel.class.isAssignableFrom(modelType)) {
            return (DAO)((Dao)$.cast(new MorphiaDao(modelType, this.ds)));
        }
        if (MorphiaModelWithLongId.class.isAssignableFrom(modelType)) {
            return (DAO)((Dao)$.cast(new MorphiaDaoWithLongId(modelType, this.ds())));
        }
        if (MorphiaModelBase.class.isAssignableFrom(modelType) && (type = modelType.getGenericSuperclass()) instanceof ParameterizedType) {
            return (DAO)((Dao)$.cast(new MorphiaDaoBase((Class)((ParameterizedType)type).getActualTypeArguments()[0], modelType, this.ds)));
        }
        Class idType = MorphiaService.findModelIdTypeByAnnotation(modelType, Id.class);
        E.illegalArgumentIf((null == idType ? 1 : 0) != 0, (String)"Cannot find out Dao for model type[%s]: unable to identify the ID type", (Object[])new Object[]{modelType});
        return (DAO)((Dao)$.cast(new MorphiaDaoBase(idType, modelType, this.ds)));
    }

    public <DAO extends Dao> DAO newDaoInstance(Class<DAO> daoType) {
        E.illegalArgumentIf((!MorphiaDaoBase.class.isAssignableFrom(daoType) ? 1 : 0) != 0, (String)"expected MorphiaDaoBase, found: %s", (Object[])new Object[]{daoType});
        MorphiaDaoBase dao = (MorphiaDaoBase)((Object)$.cast((Object)this.app().getInstance(daoType)));
        dao.ds(this.ds);
        return (DAO)((Object)dao);
    }

    public Class<? extends Annotation> entityAnnotationType() {
        return Entity.class;
    }

    public Datastore ds() {
        return this.ds;
    }

    public void registerFieldNameMapping(Class<?> entityClass, Map<String, String> nameMapping) {
        this.fieldNameLookup.put(entityClass, nameMapping);
    }

    private void initDataStore(Osgl.T2<MongoClientURI, MongoClient> t2, Map<String, String> conf) {
        MongoClientURI uri = (MongoClientURI)t2._1;
        MongoClient client = (MongoClient)t2._2;
        String db = uri.getDatabase();
        if (S.blank((String)db) && S.empty((String)(db = S.string((Object)conf.get("db"))))) {
            db = this.id();
            if ("default".equals(db)) {
                db = "test";
                this.warn("No \"db\" (database name) configured. Will use \"test\" as database name for the default service", new Object[0]);
            } else {
                this.warn("No \"db\" (database name) configured. Will use service id \"%s\" as database name", new Object[]{db});
            }
        }
        this.ds = this.morphia.createDatastore(client, db);
    }

    private void delayedEnsureIndexesAndCaps(App app) {
        app.jobManager().beforeAppStart(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        MorphiaService.this.ensureIndexesAndCaps();
                    }
                    catch (MongoInterruptedException e) {
                        if (Act.isDev()) break block2;
                        MorphiaService.this.warn(e, "Error calling ensure indexes and caps operation", new Object[0]);
                    }
                }
            }
        });
    }

    private void delayedMapExternalModels(App app) {
        app.jobManager().beforeAppStart(new Runnable(){

            @Override
            public void run() {
                MorphiaService.this.mapExternalModels();
            }
        });
    }

    private void ensureIndexesAndCaps() {
        this.ds.ensureIndexes();
        this.ds.ensureCaps();
    }

    private void mapExternalModels() {
        ExternalModelAdaptor.applyAdaptorFor(this);
    }

    private void registerFastJsonConfig() {
        FastJsonObjectIdCodec objectIdCodec = new FastJsonObjectIdCodec();
        SerializeConfig serializeConfig = SerializeConfig.getGlobalInstance();
        serializeConfig.put(ObjectId.class, (ObjectSerializer)objectIdCodec);
        serializeConfig.put(MorphiaIterator.class, (ObjectSerializer)FastJsonIterableSerializer.instance);
        ParserConfig parserConfig = ParserConfig.getGlobalInstance();
        parserConfig.putDeserializer(ObjectId.class, (ObjectDeserializer)objectIdCodec);
    }

    public Morphia morphia() {
        return this.morphia;
    }

    public Mapper mapper() {
        return this.morphia.getMapper();
    }

    public static MorphiaService findByModelClass(Class<?> modelClass) {
        DB db = modelClass.getAnnotation(DB.class);
        String serviceId = null == db ? "default" : db.value();
        DbService service = Act.app().dbServiceManager().dbService(serviceId);
        return service instanceof MorphiaService ? (MorphiaService)service : null;
    }

    public static List<MorphiaService> allMorphiaServices() {
        return Act.app().dbServiceManager().dbServicesByClass(MorphiaService.class);
    }

    public static String[] splitQueryKeys(String keys) {
        return keys.split(QUERY_SEP);
    }

    public static String[] splitGroupKeys(String keys) {
        return keys.split(GROUP_SEP);
    }

    public static MorphiaService getService(Class<?> modelType) {
        DB db = modelType.getAnnotation(DB.class);
        String dbId = null == db ? "default" : db.value();
        return MorphiaService.getService(dbId, App.instance().dbServiceManager());
    }

    public static String mappedName(String fieldName, Class<?> modelType) {
        MorphiaService service = MorphiaService.getService(modelType);
        Map<String, String> mapping = service.fieldNameLookup.get(modelType);
        String mappedName = null == mapping ? fieldName : mapping.get(fieldName);
        return mappedName == null ? fieldName : mappedName;
    }

    private static MorphiaService getService(String dbId, DbServiceManager mgr) {
        DbService svc = mgr.dbService(dbId);
        E.invalidConfigurationIf((null == svc ? 1 : 0) != 0, (String)"Cannot find db service by id: %s", (Object[])new Object[]{dbId});
        E.invalidConfigurationIf((!(svc instanceof MorphiaService) ? 1 : 0) != 0, (String)"The db service[%s|%s] is not morphia service", (Object[])new Object[]{dbId, svc.getClass()});
        return (MorphiaService)((Object)$.cast((Object)svc));
    }
}

