/*
 * Decompiled with CFR 0.152.
 */
package act.db.morphia;

import act.db.Dao;
import act.db.morphia.MorphiaDaoBase;
import act.db.morphia.MorphiaService;
import act.db.morphia.annotation.NoQueryValidation;
import act.db.morphia.util.AggregationResult;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.types.CodeWScope;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.query.ArraySlice;
import org.mongodb.morphia.query.CountOptions;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.CriteriaContainer;
import org.mongodb.morphia.query.CriteriaContainerImpl;
import org.mongodb.morphia.query.FieldEnd;
import org.mongodb.morphia.query.FindOptions;
import org.mongodb.morphia.query.Meta;
import org.mongodb.morphia.query.MorphiaIterator;
import org.mongodb.morphia.query.MorphiaKeyIterator;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.Sort;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class MorphiaQuery<MODEL_TYPE>
implements Dao.Query<MODEL_TYPE, MorphiaQuery<MODEL_TYPE>>,
Query<MODEL_TYPE> {
    private Query<MODEL_TYPE> mq;
    private Class<MODEL_TYPE> modelType;
    private Datastore ds;
    private MorphiaDaoBase<?, MODEL_TYPE> dao;

    public MorphiaQuery(MorphiaDaoBase<?, MODEL_TYPE> dao) {
        this.ds = dao.ds();
        this.modelType = dao.modelType();
        this.dao = dao;
        this.mq = this.ds.createQuery(this.modelType);
        if (dao.isAdaptive() || this.modelType.isAnnotationPresent(NoQueryValidation.class)) {
            this.mq = this.mq.disableValidation();
        }
    }

    public MorphiaQuery<MODEL_TYPE> filter(String key, Object val) {
        this.mq.filter(key, val);
        return this;
    }

    public MorphiaQuery<MODEL_TYPE> offset(int pos) {
        this.mq.offset(pos);
        return this;
    }

    public MorphiaQuery<MODEL_TYPE> limit(int limit) {
        this.mq.limit(limit);
        return this;
    }

    public MorphiaQuery batchSize(int value) {
        this.mq.batchSize(value);
        return this;
    }

    public MorphiaQuery<MODEL_TYPE> orderBy(String ... fieldList) {
        C.List spec = C.listOf((Object[])fieldList).flatMap((Osgl.Function)S.F.SPLIT);
        S.Buffer sb = S.newBuffer();
        for (String s : spec) {
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
            sb.append(s).append(",");
        }
        sb.delete(sb.length() - 1, sb.length());
        this.mq.order(sb.toString());
        return this;
    }

    public MorphiaQuery enableValidation() {
        this.mq.enableValidation();
        return this;
    }

    public MorphiaQuery disableValidation() {
        this.mq.disableValidation();
        return this;
    }

    public MorphiaQuery hintIndex(String idxName) {
        this.mq.hintIndex(idxName);
        return this;
    }

    public MorphiaQuery retrievedFields(boolean include, String ... fields) {
        this.mq.retrievedFields(include, fields);
        return this;
    }

    public Map<String, Object> explain(FindOptions findOptions) {
        return this.mq.explain(findOptions);
    }

    public Query<MODEL_TYPE> order(Meta meta) {
        return this.mq.order(meta);
    }

    public Query<MODEL_TYPE> order(Sort ... sorts) {
        return this.mq.order(sorts);
    }

    public Query<MODEL_TYPE> project(String s, boolean b) {
        return this.mq.project(s, b);
    }

    public Query<MODEL_TYPE> project(String s, ArraySlice arraySlice) {
        return this.mq.project(s, arraySlice);
    }

    public Query<MODEL_TYPE> project(Meta meta) {
        return this.mq.project(meta);
    }

    public List<Key<MODEL_TYPE>> asKeyList(FindOptions findOptions) {
        return this.mq.asKeyList(findOptions);
    }

    public List<MODEL_TYPE> asList(FindOptions findOptions) {
        return this.mq.asList(findOptions);
    }

    public long count(CountOptions countOptions) {
        return this.mq.count(countOptions);
    }

    public MorphiaIterator<MODEL_TYPE, MODEL_TYPE> fetch(FindOptions findOptions) {
        return this.mq.fetch(findOptions);
    }

    public MorphiaIterator<MODEL_TYPE, MODEL_TYPE> fetchEmptyEntities(FindOptions findOptions) {
        return this.mq.fetchEmptyEntities(findOptions);
    }

    public MorphiaKeyIterator<MODEL_TYPE> fetchKeys(FindOptions findOptions) {
        return this.mq.fetchKeys(findOptions);
    }

    public MODEL_TYPE get(FindOptions findOptions) {
        return (MODEL_TYPE)this.mq.get(findOptions);
    }

    public Key<MODEL_TYPE> getKey(FindOptions findOptions) {
        return this.mq.getKey(findOptions);
    }

    public MorphiaQuery enableSnapshotMode() {
        this.mq.enableSnapshotMode();
        return this;
    }

    public MorphiaQuery disableSnapshotMode() {
        this.mq.disableSnapshotMode();
        return this;
    }

    public MorphiaQuery disableCursorTimeout() {
        this.mq.disableCursorTimeout();
        return this;
    }

    public MorphiaQuery enableCursorTimeout() {
        this.mq.enableCursorTimeout();
        return this;
    }

    public Class<MODEL_TYPE> getEntityClass() {
        return this.mq.getEntityClass();
    }

    public int getBatchSize() {
        return this.mq.getBatchSize();
    }

    public Query<MODEL_TYPE> cloneQuery() {
        MorphiaQuery<MODEL_TYPE> newQuery = new MorphiaQuery<MODEL_TYPE>(this.dao);
        newQuery.mq = this.mq.cloneQuery();
        return newQuery;
    }

    public Query<MODEL_TYPE> comment(String comment) {
        this.mq.comment(comment);
        return this;
    }

    public Map<String, Object> explain() {
        return this.mq.explain();
    }

    public DBCollection getCollection() {
        return this.mq.getCollection();
    }

    public DBObject getFieldsObject() {
        return this.mq.getFieldsObject();
    }

    public int getLimit() {
        return this.mq.getLimit();
    }

    public int getOffset() {
        return this.mq.getOffset();
    }

    public DBObject getQueryObject() {
        return this.mq.getQueryObject();
    }

    public DBObject getSortObject() {
        return this.mq.getSortObject();
    }

    public Query<MODEL_TYPE> lowerIndexBound(DBObject lowerBound) {
        this.mq.lowerIndexBound(lowerBound);
        return this;
    }

    public Query<MODEL_TYPE> maxScan(int value) {
        this.mq.maxScan(value);
        return this;
    }

    public Query<MODEL_TYPE> maxTime(long maxTime, TimeUnit maxTimeUnit) {
        this.mq.maxTime(maxTime, maxTimeUnit);
        return this;
    }

    public Query<MODEL_TYPE> order(String sort) {
        this.mq.order(sort);
        return this;
    }

    public Query<MODEL_TYPE> queryNonPrimary() {
        this.mq.queryNonPrimary();
        return this;
    }

    public Query<MODEL_TYPE> queryPrimaryOnly() {
        this.mq.queryPrimaryOnly();
        return this;
    }

    public Query<MODEL_TYPE> retrieveKnownFields() {
        this.mq.retrieveKnownFields();
        return this;
    }

    public Query<MODEL_TYPE> returnKey() {
        this.mq.returnKey();
        return this;
    }

    public Query<MODEL_TYPE> search(String text) {
        this.mq.search(text);
        return this;
    }

    public Query<MODEL_TYPE> search(String text, String language) {
        this.mq.search(text, language);
        return this;
    }

    public Query<MODEL_TYPE> upperIndexBound(DBObject upperBound) {
        this.mq.upperIndexBound(upperBound);
        return this;
    }

    public Query<MODEL_TYPE> useReadPreference(ReadPreference readPref) {
        this.mq.useReadPreference(readPref);
        return this;
    }

    public List<Key<MODEL_TYPE>> asKeyList() {
        return this.mq.asKeyList();
    }

    public List<MODEL_TYPE> asList() {
        return this.mq.asList();
    }

    public long countAll() {
        return this.mq.countAll();
    }

    public MorphiaKeyIterator<MODEL_TYPE> fetchKeys() {
        return this.mq.fetchKeys();
    }

    public MODEL_TYPE get() {
        return (MODEL_TYPE)this.mq.get();
    }

    public Key<MODEL_TYPE> getKey() {
        return this.mq.getKey();
    }

    public MorphiaIterator<MODEL_TYPE, MODEL_TYPE> tail() {
        return this.mq.tail();
    }

    public MorphiaIterator<MODEL_TYPE, MODEL_TYPE> tail(boolean awaitData) {
        return this.mq.tail(awaitData);
    }

    public Iterator<MODEL_TYPE> iterator() {
        return this.mq.iterator();
    }

    public MODEL_TYPE first() {
        return (MODEL_TYPE)this.mq.get();
    }

    public long count() {
        return this.mq.countAll();
    }

    public MorphiaIterator<MODEL_TYPE, MODEL_TYPE> fetch() {
        return this.mq.fetch();
    }

    public MorphiaIterator<MODEL_TYPE, MODEL_TYPE> fetchEmptyEntities() {
        return this.mq.fetchEmptyEntities();
    }

    public List<MODEL_TYPE> fetchAsList() {
        return this.mq.asList();
    }

    public Query<MODEL_TYPE> morphiaQuery() {
        return this.mq;
    }

    public FieldEnd<? extends Query<MODEL_TYPE>> field(String field) {
        return (FieldEnd)$.cast((Object)this.mq.field(field));
    }

    public FieldEnd<? extends CriteriaContainerImpl> criteria(String field) {
        return this.mq.criteria(field);
    }

    public CriteriaContainer and(Criteria ... criteria) {
        return this.mq.and(criteria);
    }

    public CriteriaContainer or(Criteria ... criteria) {
        return this.mq.or(criteria);
    }

    public MorphiaQuery where(String js) {
        this.mq.where(js);
        return this;
    }

    public MorphiaQuery where(CodeWScope js) {
        this.mq.where(js);
        return this;
    }

    public AggregationResult groupMax(String field, String ... groupKeys) {
        return this.groupBy(groupKeys).on(field).max();
    }

    public Long max(String maxField) {
        return this.groupMax(maxField, new String[0]).getDefault();
    }

    public AggregationResult groupMin(String field, String ... groupKeys) {
        return this.groupBy(groupKeys).on(field).min();
    }

    public Long min(String minField) {
        return this.groupMin(minField, new String[0]).getDefault();
    }

    public AggregationResult groupAverage(String field, String ... groupKeys) {
        return this.groupBy(groupKeys).on(field).average();
    }

    public long average(String field) {
        Long L2 = this.groupAverage(field, new String[0]).getDefault();
        return null == L2 ? 0L : L2;
    }

    public AggregationResult groupSum(String field, String ... groupKeys) {
        return this.groupBy(groupKeys).on(field).sum();
    }

    public long sum(String field) {
        Long L2 = this.groupSum(field, new String[0]).getDefault();
        return null == L2 ? 0L : L2;
    }

    public AggregationResult groupCount(String ... groupKeys) {
        return this.groupBy(groupKeys).count();
    }

    private AggregationResult aggregate_(String mappedField, DBObject initial, Long initVal, String reduce, String finalize, String ... groupKeys) {
        if (null == initial) {
            initial = new BasicDBObject();
        }
        initial.put(mappedField, (Object)initVal);
        return new AggregationResult(this.group(S.join((String)",", (String[])groupKeys), initial, reduce, finalize), mappedField, this.modelType);
    }

    private List<BasicDBObject> group(String groupKeys, DBObject initial, String reduce, String finalize) {
        BasicDBObject key = new BasicDBObject();
        if (!S.empty((String)groupKeys)) {
            String[] sa;
            for (String s : sa = MorphiaService.splitGroupKeys(groupKeys)) {
                key.put(s, (Object)true);
            }
        }
        return (List)this.ds.getCollection(this.modelType).group((DBObject)key, this.mq.getQueryObject(), initial, reduce, finalize);
    }

    public GroupBy groupBy(String ... groupByKeys) {
        return new GroupBy(groupByKeys);
    }

    private String mappedName(String fieldName) {
        return MorphiaService.mappedName(fieldName, this.modelType);
    }

    public class GroupBy {
        private String[] groupKeys;
        private String field;

        private GroupBy(String ... groupKeys) {
            this.groupKeys = this.canonicalGroupKeys(groupKeys);
        }

        public GroupBy on(String aggregationField) {
            this.field = MorphiaQuery.this.mappedName(aggregationField);
            return this;
        }

        public AggregationResult count() {
            this.field = "_id";
            return this.aggregate(Aggregation.COUNT);
        }

        public AggregationResult sum() {
            return this.aggregate(Aggregation.SUM);
        }

        public AggregationResult average() {
            return this.aggregate(Aggregation.AVERAGE);
        }

        public AggregationResult max() {
            return this.aggregate(Aggregation.MAX);
        }

        public AggregationResult min() {
            return this.aggregate(Aggregation.MIN);
        }

        private AggregationResult aggregate(Aggregation type) {
            E.illegalArgumentIf((null == this.field ? 1 : 0) != 0, (String)"It must specify the field on which aggregation will be calculated");
            return MorphiaQuery.this.aggregate_(this.field, type._initial(), type._initVal(), type._reduce(this.field), type._finalize(this.field), this.groupKeys);
        }

        private String[] canonicalGroupKeys(String ... keys) {
            ArrayList<String> list = new ArrayList<String>();
            for (String key : keys) {
                String[] sa;
                for (String s : sa = MorphiaService.splitGroupKeys(key)) {
                    list.add(MorphiaQuery.this.mappedName(s));
                }
            }
            return list.toArray(new String[list.size()]);
        }
    }

    private static enum Aggregation {
        COUNT{

            @Override
            String _reduce(String mappedField) {
                return String.format("function(obj, prev){prev.%s++;}", mappedField);
            }
        }
        ,
        SUM{

            @Override
            String _reduce(String mappedField) {
                return String.format("function(obj, prev){prev.%s+=obj.%s;}", mappedField, mappedField);
            }
        }
        ,
        MAX{

            @Override
            String _reduce(String mappedField) {
                return String.format("function(obj, prev){if (obj.%s > prev.%s) prev.%s = obj.%s}", mappedField, mappedField, mappedField, mappedField);
            }

            @Override
            Long _initVal() {
                return -9223372036854775807L;
            }
        }
        ,
        MIN{

            @Override
            String _reduce(String mappedField) {
                return String.format("function(obj, prev){if (obj.%s < prev.%s) prev.%s = obj.%s}", mappedField, mappedField, mappedField, mappedField);
            }

            @Override
            Long _initVal() {
                return 0x7FFFFFFFFFFFFFFEL;
            }
        }
        ,
        AVERAGE{

            @Override
            DBObject _initial() {
                BasicDBObject initial = new BasicDBObject();
                initial.put("__count", (Object)0);
                initial.put("__sum", (Object)0);
                return initial;
            }

            @Override
            String _reduce(String mappedField) {
                return String.format("function(obj, prev){prev.__count++; prev.__sum+=obj.%s;}", mappedField);
            }

            @Override
            String _finalize(String mappedField) {
                return String.format("function(prev) {prev.%s = prev.__sum / prev.__count;}", mappedField);
            }
        };


        DBObject _initial() {
            return null;
        }

        abstract String _reduce(String var1);

        String _finalize(String mappedField) {
            return null;
        }

        Long _initVal() {
            return 0L;
        }
    }
}

