/*
 * Decompiled with CFR 0.152.
 */
package act.db.morphia;

import act.Act;
import act.app.event.AppEventId;
import act.db.DB;
import act.db.morphia.MorphiaService;
import act.db.morphia.event.EntityMapped;
import act.event.ActEvent;
import act.job.OnAppEvent;
import act.util.AnnotatedClassFinder;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.mongodb.morphia.EntityInterceptor;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Property;
import org.mongodb.morphia.mapping.Mapper;
import org.osgl.$;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.S;

public class MorphiaModule {
    private static final Logger LOGGER = LogManager.get(MorphiaModule.class);
    @Inject
    private List<EntityInterceptor> interceptors;

    @AnnotatedClassFinder(value=Entity.class)
    public void autoMapEntity(Class<?> clz) {
        MorphiaService service = MorphiaService.findByModelClass(clz);
        if (null == service) {
            LOGGER.warn("Cannot find MorphiaService for entity class: %s", new Object[]{clz});
            return;
        }
        Mapper mapper = service.mapper();
        mapper.addMappedClass(clz);
        this.registerFieldNameMapping(clz);
    }

    @OnAppEvent(value=AppEventId.PRE_START)
    public void raiseMappedEvent() {
        for (MorphiaService service : MorphiaService.allMorphiaServices()) {
            Act.app().eventBus().emit((ActEvent)new EntityMapped(service.mapper()));
            for (EntityInterceptor interceptor : this.interceptors) {
                DB db = interceptor.getClass().getAnnotation(DB.class);
                if (null != db && !S.eq((String)db.value(), (String)service.id())) continue;
                service.mapper().addInterceptor(interceptor);
            }
        }
    }

    private void registerFieldNameMapping(Class<?> clz) {
        Map<String, String> mapping = this.findFieldNameMapping(clz);
        if (!mapping.isEmpty()) {
            MorphiaService dbService = MorphiaService.getService(clz);
            dbService.registerFieldNameMapping(clz, mapping);
        }
    }

    private Map<String, String> findFieldNameMapping(Class<?> clz) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        List fields = $.fieldsOf(clz, (boolean)true);
        for (Field f : fields) {
            Property property = f.getAnnotation(Property.class);
            if (null == property) continue;
            mapping.put(f.getName(), property.value());
        }
        return mapping;
    }
}

