/*
 * Decompiled with CFR 0.152.
 */
package act.db.morphia;

import act.Act;
import act.app.App;
import act.db.AdaptiveRecord;
import act.db.Dao;
import act.db.DaoBase;
import act.db.DeleteEvent;
import act.db.Model;
import act.db.TimeTrackingModel;
import act.db.TimestampGenerator;
import act.db.morphia.MorphiaModel;
import act.db.morphia.MorphiaQuery;
import act.db.morphia.MorphiaService;
import act.db.morphia.util.AggregationResult;
import act.event.ActEvent;
import act.event.EventBus;
import act.inject.param.NoBind;
import act.util.General;
import com.mongodb.DBCollection;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.aggregation.AggregationPipeline;
import org.mongodb.morphia.aggregation.Group;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.KVStore;

@General
@NoBind
public class MorphiaDaoBase<ID_TYPE, MODEL_TYPE>
extends DaoBase<ID_TYPE, MODEL_TYPE, MorphiaQuery<MODEL_TYPE>> {
    private volatile Datastore ds;
    private App app;
    private MorphiaQuery<MODEL_TYPE> defQuery;
    private boolean isAdaptive;

    protected MorphiaDaoBase() {
        this.app = App.instance();
        this.probeAdaptive();
    }

    MorphiaDaoBase(Datastore ds) {
        this.app = App.instance();
        this.ds(ds);
        this.probeAdaptive();
    }

    MorphiaDaoBase(Class<ID_TYPE> idType, Class<MODEL_TYPE> modelType, Datastore ds) {
        super(idType, modelType);
        E.NPE(modelType, (Object)ds);
        this.ds(ds);
        this.app = App.instance();
        this.probeAdaptive();
    }

    protected MorphiaDaoBase(Class<ID_TYPE> idType, Class<MODEL_TYPE> modelType) {
        super(idType, modelType);
        this.app = App.instance();
        this.probeAdaptive();
    }

    private void probeAdaptive() {
        this.isAdaptive = AdaptiveRecord.class.isAssignableFrom(this.modelType());
    }

    protected App app() {
        return this.app;
    }

    public void setDatastore(Datastore ds) {
        this.ds(ds);
    }

    void ds(Datastore ds) {
        this.ds = (Datastore)$.notNull((Object)ds);
        this.defQuery = new MorphiaQuery(this);
    }

    public void modelType(Class<MODEL_TYPE> modelType) {
        this.modelType = (Type)$.notNull(modelType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datastore ds() {
        if (null != this.ds) {
            return this.ds;
        }
        MorphiaDaoBase morphiaDaoBase = this;
        synchronized (morphiaDaoBase) {
            if (null == this.ds) {
                this.ds(MorphiaService.getService(this.modelType()).ds());
            }
        }
        return this.ds;
    }

    public boolean isAdaptive() {
        return this.isAdaptive;
    }

    public AggregationPipeline aggregationPipeline() {
        return this.ds().createAggregation(this.modelType());
    }

    public MODEL_TYPE findById(ID_TYPE id) {
        return (MODEL_TYPE)this.ds().get(this.modelType(), id);
    }

    public Iterable<MODEL_TYPE> findBy(String fields, Object ... values) throws IllegalArgumentException {
        Dao.Query q = this.q(fields, values);
        return q.fetch();
    }

    public Iterable<MODEL_TYPE> findByIdList(Collection<ID_TYPE> idList) {
        Dao.Query q = this.q("_id in", new Object[]{idList});
        return q.fetch();
    }

    public MODEL_TYPE findOneBy(String fields, Object ... values) throws IllegalArgumentException {
        Dao.Query q = this.q(fields, values);
        return q.first();
    }

    public MODEL_TYPE findLatest() {
        return this.q().orderBy(new String[]{"-_created"}).get();
    }

    public MODEL_TYPE findLastModified() {
        return this.q().orderBy(new String[]{"-_modified"}).get();
    }

    public Iterable<MODEL_TYPE> findAll() {
        return this.q().fetch();
    }

    public List<MODEL_TYPE> findAllAsList() {
        return this.q().fetchAsList();
    }

    public <T> List<T> distinct(MorphiaQuery q, String field) {
        return this.collection().distinct(field, q.morphiaQuery().getQueryObject());
    }

    public <T> List<T> distinct(String field) {
        return this.collection().distinct(field);
    }

    public List<KVStore> distinct(MorphiaQuery q, String field, String ... fields) {
        C.List id = C.listOf((Object[])fields).prepend((Object)field).map((Osgl.Function)new Osgl.Transformer<String, Group>(){

            public Group transform(String s) {
                return Group.grouping((String)s);
            }
        });
        AggregationPipeline pipeline = this.ds().createAggregation(this.modelType());
        if (null != q) {
            pipeline.match(q.morphiaQuery());
        }
        Iterator result = pipeline.group((List)id, new Group[0]).out(DistinctResult.class);
        C.List retList = C.newList();
        while (result.hasNext()) {
            DistinctResult dr = (DistinctResult)result.next();
            retList.add(new KVStore(dr._id));
        }
        return retList;
    }

    public List<KVStore> distinct(String field, String ... fields) {
        return this.distinct((MorphiaQuery)null, field, fields);
    }

    public ID_TYPE getId(MODEL_TYPE entity) {
        if (entity instanceof MorphiaModel) {
            return (ID_TYPE)((MorphiaModel)((Object)entity)).getId();
        }
        if (entity instanceof Model) {
            return (ID_TYPE)((Model)entity)._id();
        }
        MorphiaService service = MorphiaService.findByModelClass(entity.getClass());
        return (ID_TYPE)(null == service ? null : service.mapper().getId(entity));
    }

    public MODEL_TYPE reload(MODEL_TYPE entity) {
        return (MODEL_TYPE)this.ds().get(entity);
    }

    public long count() {
        return this.ds().getCount((Object)this.modelType);
    }

    public long countBy(String fields, Object ... values) throws IllegalArgumentException {
        Dao.Query q = this.q(fields, values);
        return q.count();
    }

    public MODEL_TYPE save(MODEL_TYPE entity) {
        if (entity instanceof TimeTrackingModel && entity instanceof Model) {
            TimeTrackingModel ttm = (TimeTrackingModel)$.cast(entity);
            TimestampGenerator tsg = Act.dbManager().timestampGenerator(ttm._timestampType());
            if (null != tsg) {
                Object now = tsg.now();
                if (((Model)entity)._isNew()) {
                    ttm._created(now);
                }
                ttm._lastModified(now);
            }
        }
        this.ds().save(entity);
        return entity;
    }

    public void save(MODEL_TYPE entity, String fields, Object ... values) throws IllegalArgumentException {
        ID_TYPE id = this.getId(entity);
        E.illegalArgumentIf((null == id ? 1 : 0) != 0, (String)"Cannot get ID of the entity specified: %s", (Object[])new Object[]{entity});
        Map<String, Object> kvList = this.kvList(fields, values);
        Query q = this.ds().createQuery(this.modelType());
        q.filter("_id", id);
        UpdateOperations upOps = this.ds().createUpdateOperations(this.modelType());
        for (String key : kvList.keySet()) {
            upOps.set(key, kvList.get(key));
        }
        if (entity instanceof TimeTrackingModel && entity instanceof Model) {
            TimeTrackingModel ttm = (TimeTrackingModel)$.cast(entity);
            TimestampGenerator tsg = Act.dbManager().timestampGenerator(ttm._timestampType());
            if (null != tsg) {
                Object now = tsg.now();
                upOps.set("_modified", now);
            }
        }
        this.ds().update(q, upOps);
    }

    public List<MODEL_TYPE> save(Iterable<MODEL_TYPE> entities) {
        C.List list = C.list(entities);
        if (list.isEmpty()) {
            return list;
        }
        Object e0 = list.get(0);
        if (e0 instanceof TimeTrackingModel && e0 instanceof Model) {
            TimeTrackingModel ttm = (TimeTrackingModel)$.cast((Object)e0);
            TimestampGenerator tsg = Act.dbManager().timestampGenerator(ttm._timestampType());
            if (null != tsg) {
                Object now = tsg.now();
                for (MODEL_TYPE entity : entities) {
                    if (((Model)entity)._isNew()) {
                        ttm._created(now);
                    }
                    ttm._lastModified(now);
                }
            }
        }
        this.ds().save(entities);
        return list;
    }

    public void delete(MODEL_TYPE entity) {
        this.ds().delete(entity);
        EventBus eventBus = this.app.eventBus();
        eventBus.trigger((ActEvent)new DeleteEvent(entity));
    }

    public void delete(MorphiaQuery<MODEL_TYPE> query) {
        this.ds().delete(query.morphiaQuery());
    }

    public void deleteById(ID_TYPE id) {
        this.ds().delete(this.modelType(), id);
    }

    public void deleteBy(String fields, Object ... values) throws IllegalArgumentException {
        this.ds().delete(this.q(fields, values).morphiaQuery());
    }

    public void deleteAll() {
        this.ds().delete((Query)this.q());
    }

    public void drop() {
        this.ds().delete(this.ds().createQuery(this.modelType()));
    }

    public MorphiaQuery<MODEL_TYPE> q() {
        return new MorphiaQuery(this);
    }

    public MorphiaQuery<MODEL_TYPE> createQuery() {
        return this.q();
    }

    public DBCollection collection() {
        return this.ds().getCollection(this.modelType());
    }

    public MorphiaQuery<MODEL_TYPE> q(String keys, Object ... values) {
        int len = values.length;
        String[] sa = MorphiaService.splitQueryKeys(keys);
        if (0 == len) {
            boolean xInArray = 1 == sa.length && keys.trim().endsWith(" in");
            E.illegalArgumentIf((!xInArray ? 1 : 0) != 0, (String)"no values supplied");
            return this.q().filter(keys, values);
        }
        E.illegalArgumentIf((sa.length != len ? 1 : 0) != 0, (String)"The number of values does not match the number of fields");
        Dao.Query q = this.q();
        for (int i = 0; i < len; ++i) {
            q.filter(sa[i], values[i]);
        }
        return q;
    }

    public MorphiaQuery<MODEL_TYPE> createQuery(String s, Object ... objects) {
        return this.q(s, objects);
    }

    public UpdateOperations<MODEL_TYPE> updates() {
        return this.ds().createUpdateOperations(this.modelType());
    }

    public UpdateOperations<MODEL_TYPE> createUpdateOperations() {
        return this.updates();
    }

    public MorphiaQuery.GroupBy groupBy(String ... groupKeys) {
        return this.defQuery.groupBy(groupKeys);
    }

    public AggregationResult groupMax(String field, String ... groupKeys) {
        return this.defQuery.groupMax(field, groupKeys);
    }

    public Long max(String maxField) {
        return this.groupMax(maxField, new String[0]).getDefault();
    }

    public AggregationResult groupMin(String field, String ... groupKeys) {
        return this.defQuery.groupMin(field, groupKeys);
    }

    public Long min(String minField) {
        return this.groupMin(minField, new String[0]).getDefault();
    }

    public AggregationResult groupAverage(String field, String ... groupKeys) {
        return this.defQuery.groupAverage(field, groupKeys);
    }

    public Long average(String field) {
        return this.groupAverage(field, new String[0]).getDefault();
    }

    public AggregationResult groupSum(String field, String ... groupKeys) {
        return this.defQuery.groupSum(field, groupKeys);
    }

    public Long sum(String field) {
        return this.groupSum(field, new String[0]).getDefault();
    }

    public AggregationResult groupCount(String ... groupKeys) {
        return this.defQuery.groupCount(groupKeys);
    }

    private Map<String, Object> kvList(String keys, Object ... values) {
        int len = values.length;
        E.illegalArgumentIf((len == 0 ? 1 : 0) != 0, (String)"no values supplied");
        String[] sa = keys.split("[,;:]+");
        E.illegalArgumentIf((sa.length != len ? 1 : 0) != 0, (String)"The number of values does not match the number of fields");
        C.Map kvList = C.newMap((Object[])new Object[0]);
        for (int i = 0; i < len; ++i) {
            kvList.put(sa[i], values[i]);
        }
        return kvList;
    }

    private static class DistinctResult {
        private Map<String, Object> _id;

        private DistinctResult() {
        }
    }
}

