/*
 * Decompiled with CFR 0.152.
 */
package act.db.morphia;

import act.app.DbServiceManager;
import act.app.event.AppEventId;
import act.db.DB;
import act.db.DbService;
import act.db.morphia.MorphiaService;
import act.job.OnAppEvent;
import act.util.SimpleBean;
import act.util.SubClassFinder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.Generics;

public abstract class ExternalModelAdaptor<MODEL_TYPE>
implements SimpleBean {
    private static final Logger logger = LogManager.get(ExternalModelAdaptor.class);
    private static Map<String, List<Osgl.T2<Class<ExternalModelAdaptor>, Class>>> adaptorRegistry = new HashMap<String, List<Osgl.T2<Class<ExternalModelAdaptor>, Class>>>();

    @SubClassFinder
    public static void processExternalModel(Class<ExternalModelAdaptor> adaptorClass) {
        List paramTypes = Generics.typeParamImplementations(adaptorClass, ExternalModelAdaptor.class);
        if (paramTypes.isEmpty()) {
            logger.warn("Found untyped ExternalModelAdaptor class: %s", new Object[]{adaptorClass});
            return;
        }
        Type type = (Type)paramTypes.get(0);
        if (type instanceof Class) {
            Class modelClass = (Class)$.cast((Object)type);
            ExternalModelAdaptor.registerAdaptor(adaptorClass, modelClass);
        } else {
            logger.warn("Unknown external model class type parameter: %s", new Object[]{type});
        }
    }

    private static void registerAdaptor(Class<ExternalModelAdaptor> adaptorClass, Class modelClass) {
        DB dbAnno = adaptorClass.getAnnotation(DB.class);
        String serviceId = null == dbAnno ? "default" : dbAnno.value();
        List<Osgl.T2<Class<ExternalModelAdaptor>, Class>> list = adaptorRegistry.get(serviceId);
        if (null == list) {
            list = new ArrayList<Osgl.T2<Class<ExternalModelAdaptor>, Class>>();
            adaptorRegistry.put(serviceId, list);
        }
        list.add((Osgl.T2<Class<ExternalModelAdaptor>, Class>)$.T2(adaptorClass, (Object)modelClass));
    }

    static void applyAdaptorFor(MorphiaService service) {
        ExternalModelAdaptor.applyAdaptorFor(service.id(), service);
    }

    private static void applyAdaptorFor(String serviceId, MorphiaService service) {
        List<Osgl.T2<Class<ExternalModelAdaptor>, Class>> list = adaptorRegistry.remove(serviceId);
        if (null == list) {
            return;
        }
        for (Osgl.T2<Class<ExternalModelAdaptor>, Class> pair : list) {
            Mapper mapper = service.mapper();
            ExternalModelAdaptor.map((Class)pair._1, (Class)pair._2, mapper);
        }
    }

    @OnAppEvent(value=AppEventId.POST_START)
    static void applyAdaptorForDefaultService(DbServiceManager dbServiceManager) {
        if (adaptorRegistry.isEmpty()) {
            return;
        }
        DbService db = dbServiceManager.dbService("default");
        if (!(db instanceof MorphiaService)) {
            return;
        }
        ExternalModelAdaptor.applyAdaptorFor("default", (MorphiaService)db);
    }

    private static void map(Class<ExternalModelAdaptor> adaptorClass, Class modelClass, Mapper mapper) {
        MappedClass mappedModel = mapper.getMappedClass((Object)modelClass);
        MappedClass mappedAdaptor = mapper.getMappedClass(adaptorClass);
        for (Map.Entry e : mappedAdaptor.getRelevantAnnotations().entrySet()) {
            if (e.getValue() == null || ((List)e.getValue()).isEmpty()) continue;
            for (Annotation ann : (List)e.getValue()) {
                mappedModel.addAnnotation((Class)e.getKey(), ann);
            }
        }
        Entity entity = mappedAdaptor.getEntityAnnotation();
        if (null != entity) {
            mappedModel.update();
        }
        for (MappedField mf : mappedAdaptor.getPersistenceFields()) {
            Map annMap = mf.getAnnotations();
            MappedField destMF = mappedModel.getMappedFieldByJavaField(mf.getJavaFieldName());
            if (destMF == null || annMap == null || annMap.isEmpty()) continue;
            for (Map.Entry e : annMap.entrySet()) {
                destMF.addAnnotation((Class)e.getKey(), (Annotation)e.getValue());
            }
        }
    }
}

