/*
 * Decompiled with CFR 0.152.
 */
package act.db.morphia;

import act.db.morphia.MorphiaService;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.util.Map;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

class ClientManager {
    public static final String DEF_HOST = "localhost";
    public static final int DEF_PORT = 27017;
    public static final String CONF_URI = "uri";
    public static final String CONF_URL = "url";
    public static final String CONF_HOST = "host";
    public static final String CONF_PORT = "port";
    public static final String CONF_USERNAME = "username";
    public static final String CONF_PASSWORD = "password";
    public static final String SCHEME = "mongodb://";
    private static final Map<MorphiaService, MongoClient> clients = C.newMap((Object[])new Object[0]);

    ClientManager() {
    }

    public static Osgl.T2<MongoClientURI, MongoClient> register(MorphiaService service, Map<String, String> conf) {
        if (clients.containsKey((Object)service)) {
            throw E.invalidConfiguration((String)"Mongo client has already been registered for service[%]", (Object[])new Object[]{service.id()});
        }
        MongoClientURI clientURI = ClientManager.create(conf);
        MongoClient client = new MongoClient(clientURI);
        clients.put(service, client);
        return $.T2((Object)clientURI, (Object)client);
    }

    public static MongoClient get(MorphiaService service) {
        return clients.get((Object)service);
    }

    public static void release(MorphiaService service) {
        MongoClient client = clients.remove((Object)service);
        if (null != client) {
            client.close();
        }
    }

    private static MongoClientURI create(Map<String, String> conf) {
        String uri = ClientManager.getStr(CONF_URL, conf, null);
        if (null == uri) {
            uri = ClientManager.getStr(CONF_URI, conf, null);
        }
        if (null == uri) {
            int port;
            String host = ClientManager.getStr(CONF_HOST, conf, DEF_HOST);
            if (!host.contains(":")) {
                port = ClientManager.getInt(CONF_PORT, conf, 27017);
            } else {
                port = Integer.parseInt(S.after((String)host, (String)":"));
                host = S.before((String)host, (String)":");
            }
            String username = ClientManager.getStr(CONF_USERNAME, conf, null);
            String password = null != username ? ClientManager.getStr(CONF_PASSWORD, conf, null) : null;
            S.Buffer sb = S.newBuffer((String)SCHEME);
            if (null != username && null != password) {
                sb.append(username).append(":").append(S.urlEncode((String)password)).append("@");
            }
            sb.append(host).append(":").append(port);
            uri = sb.toString();
        } else if (!uri.startsWith(SCHEME)) {
            uri = SCHEME + uri;
        }
        return new MongoClientURI(uri);
    }

    private static String getStr(String key, Map<String, String> conf, String def) {
        String val = conf.get(key);
        return null == val ? def : val;
    }

    private static int getInt(String key, Map<String, String> conf, int def) {
        String val = conf.get(key);
        return null == val ? def : Integer.parseInt(val);
    }
}

