/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.maven.plugin;

import java.io.File;
import java.io.IOException;
import org.acplt.oncrpc.apps.jrpcgen.jrpcgen;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class JRpcGeneratorBase
extends AbstractMojo {
    @Parameter(required=true)
    protected File xFile;
    @Parameter(required=true)
    protected File destDir;
    @Parameter(required=true)
    protected String packageName;
    @Parameter(defaultValue="false")
    protected boolean debug = false;
    @Parameter(defaultValue="false")
    protected boolean verbose = false;
    @Parameter(defaultValue="false")
    protected boolean backup = false;
    @Parameter(defaultValue="false")
    protected boolean createDir = false;
    @Parameter(defaultValue="false")
    protected boolean serverTcpOnly = false;
    @Parameter(defaultValue="false")
    protected boolean serverUdpOnly = false;

    protected JRpcGeneratorBase() {
        jrpcgen.reset();
    }

    protected void generateSources() throws MojoExecutionException {
        this.checkAttributes();
        try {
            this.logInfo("Compiling %s", this.xFile.getCanonicalPath());
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (this.packageName != null) {
            jrpcgen.packageName = this.packageName;
            try {
                this.destDir = new File(this.destDir.getCanonicalPath() + File.separator + this.packageName.replace('.', File.separatorChar));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("", (Exception)ex);
            }
        }
        if (this.createDir) {
            try {
                boolean dirsCreated;
                if (!this.destDir.exists() && !(dirsCreated = this.destDir.mkdirs())) {
                    throw new MojoExecutionException("Could not create destination dir");
                }
            }
            catch (SecurityException ex) {
                throw new MojoExecutionException("", (Exception)ex);
            }
        }
        if (this.debug) {
            this.dumpState();
        }
        jrpcgen.debug = this.debug;
        jrpcgen.verbose = this.verbose;
        jrpcgen.noBackups = !this.backup;
        jrpcgen.destinationDir = this.destDir;
        jrpcgen.xFile = this.xFile;
        jrpcgen.serverTcpOnly = this.serverTcpOnly;
        jrpcgen.serverUdpOnly = this.serverUdpOnly;
        try {
            jrpcgen.doParse();
        }
        catch (Throwable t) {
            throw new MojoExecutionException("", t);
        }
    }

    protected void checkAttributes() throws MojoExecutionException {
        if (this.xFile == null) {
            throw new MojoExecutionException("srcfile has not been set");
        }
        if (this.destDir == null) {
            throw new MojoExecutionException("destdir has not been set");
        }
        try {
            if (!this.xFile.isFile()) {
                throw new MojoExecutionException(String.format("%s : problem reading srcdir", this.xFile.getCanonicalPath()));
            }
            if (!this.destDir.isDirectory()) {
                if (!this.createDir) {
                    this.logError("Zielverzeichnis '%s' existiert nicht.", this.destDir.getCanonicalPath());
                    throw new MojoExecutionException("problem accessing srcdir");
                }
                this.logInfo("Zielverzeichnis '%s' muss angelegt werden.", this.destDir.getCanonicalPath());
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("", (Exception)ex);
        }
        catch (SecurityException ex) {
            throw new MojoExecutionException("", (Exception)ex);
        }
    }

    protected void dumpState() throws MojoExecutionException {
        try {
            this.logDebug("Quelldatei: %s", this.xFile.getCanonicalPath());
            this.logDebug("Zielverzeichnis: %s", this.destDir.getCanonicalPath());
            this.logDebug("Paketname: %s", this.packageName);
            this.logDebug("Backup: %s", this.backup ? "Ja" : "Nein");
            this.logDebug("Verbosse: %s", this.verbose ? "Ja" : "Nein");
            this.logDebug("Zielverzeichnis wird erzeugt: %s", this.createDir ? "Ja" : "Nein");
        }
        catch (IOException ioException) {
            this.logError("Der Status kann nicht ausgegeben werden (%s).", ioException.getMessage());
            throw new MojoExecutionException("Fehler beim Ausgeben des Status", (Exception)ioException);
        }
    }

    protected void logDebug(String format, Object ... arguments) {
        if (this.getLog().isDebugEnabled()) {
            String message = String.format(format, arguments);
            this.getLog().debug(message.subSequence(0, message.length()));
        }
    }

    protected void logInfo(String format, Object ... arguments) {
        if (this.getLog().isInfoEnabled()) {
            String message = String.format(format, arguments);
            this.getLog().info(message.subSequence(0, message.length()));
        }
    }

    protected void logWarn(String format, Object ... arguments) {
        if (this.getLog().isWarnEnabled()) {
            String message = String.format(format, arguments);
            this.getLog().warn(message.subSequence(0, message.length()));
        }
    }

    protected void logError(String format, Object ... arguments) {
        if (this.getLog().isErrorEnabled()) {
            String message = String.format(format, arguments);
            this.getLog().error(message.subSequence(0, message.length()));
        }
    }
}

