/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TeeOutputStream
extends FilterOutputStream {
    private File f;
    private OutputStream out;
    private OutputStream fos;

    public TeeOutputStream(OutputStream os, OutputStream tos) throws IOException {
        super(os);
        this.out = os;
        this.fos = tos;
    }

    public TeeOutputStream(OutputStream os, File f, boolean append) throws IOException {
        super(os);
        this.out = os;
        this.fos = new FileOutputStream(f, append);
    }

    public TeeOutputStream(OutputStream os, File f) throws IOException {
        super(os);
        this.out = os;
        this.fos = new FileOutputStream(f);
    }

    public TeeOutputStream(OutputStream os, String f, boolean append) throws IOException {
        this(os, new File(f), append);
    }

    public TeeOutputStream(OutputStream os, String f) throws IOException {
        this(os, new File(f));
    }

    public void close() throws IOException {
        this.out.close();
        this.fos.close();
    }

    public void flush() throws IOException {
        this.fos.flush();
        this.out.flush();
    }

    public void write(int b) throws IOException {
        this.fos.write(b);
        this.out.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.fos.write(b);
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.fos.write(b, off, len);
        this.out.write(b, off, len);
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

