(ns sentry-fingerprinter.core
  (:require [sentry-fingerprinter.exception-fingerprint :as ef]
            [taoensso.timbre.appenders.3rd-party.sentry :as sa]))

(defn add-fingerprint [{:keys [?err ?msg-fmt]} event]
  (let [fingerprint (remove nil? [?msg-fmt
                                  (when ?err (ef/hash-exception ?err))])]
    (if-not (empty? fingerprint)
      (merge event {:fingerprint fingerprint})
      event)))

(defn sentry-fingerprinter [dsn environment]
  (assoc (sa/sentry-appender
           dsn
           {:environment   environment
            :data-event-fn add-fingerprint})
    :min-level :error))
