/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.util.FileManager;
import com.opensymphony.xwork2.conversion.annotations.Conversion;
import com.opensymphony.xwork2.conversion.annotations.ConversionRule;
import com.opensymphony.xwork2.conversion.annotations.ConversionType;
import com.opensymphony.xwork2.conversion.annotations.TypeConversion;
import com.opensymphony.xwork2.util.AnnotationUtils;
import com.opensymphony.xwork2.util.XWorkConverter;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import ognl.TypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AnnotationXWorkConverter
extends XWorkConverter {
    private static final Log _log = LogFactory.getLog(AnnotationXWorkConverter.class);

    protected AnnotationXWorkConverter() {
        try {
            this.loadConversionProperties("xwork-default-conversion.properties");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.loadConversionProperties("xwork-conversion.properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void addConverterMapping(Map mapping, Class clazz) {
        Method[] methods;
        Annotation[] annotations;
        try {
            InputStream is = FileManager.loadFile((String)AnnotationXWorkConverter.buildConverterFilename((Class)clazz), (Class)clazz);
            if (is != null) {
                Map.Entry<Object, Object> entry;
                String key;
                Properties prop = new Properties();
                prop.load(is);
                Iterator<Map.Entry<Object, Object>> it = prop.entrySet().iterator();
                while (it.hasNext() && !mapping.containsKey(key = (String)(entry = it.next()).getKey())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(key + ":" + entry.getValue()));
                    }
                    if (key.startsWith("KeyProperty_") || key.startsWith("CreateIfNull_")) {
                        mapping.put(key, entry.getValue());
                        continue;
                    }
                    if (!(key.startsWith("Element_") || key.startsWith("Key_") || key.startsWith("Collection_"))) {
                        mapping.put(key, this.createTypeConverter((String)entry.getValue()));
                        continue;
                    }
                    if (key.startsWith("Key_")) {
                        Class<TypeConverter> converterClass = Thread.currentThread().getContextClassLoader().loadClass((String)entry.getValue());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Converter class: " + converterClass));
                        }
                        if (converterClass.isAssignableFrom(TypeConverter.class)) {
                            mapping.put(key, this.createTypeConverter((String)entry.getValue()));
                            continue;
                        }
                        mapping.put(key, converterClass);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Object placed in mapping for key " + key + " is " + mapping.get(key)));
                        continue;
                    }
                    mapping.put(key, Thread.currentThread().getContextClassLoader().loadClass((String)entry.getValue()));
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Problem loading properties for " + clazz.getName()), (Throwable)ex);
        }
        for (Annotation annotation : annotations = clazz.getAnnotations()) {
            TypeConversion tc;
            String key;
            if (!(annotation instanceof Conversion)) continue;
            Conversion conversion = (Conversion)annotation;
            Annotation[] arr$ = conversion.conversions();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !mapping.containsKey(key = (tc = arr$[i$]).key()); ++i$) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(key + ":" + key));
                }
                if (key == null) continue;
                try {
                    if (tc.rule().equals((Object)ConversionType.APPLICATION)) {
                        this.defaultMappings.put(key, this.createTypeConverter(tc.converter()));
                        continue;
                    }
                    if (tc.rule().toString().equals((Object)ConversionRule.KEY_PROPERTY) || tc.rule().toString().equals((Object)ConversionRule.CREATE_IF_NULL)) {
                        mapping.put(key, tc.value());
                        continue;
                    }
                    if (!tc.rule().toString().equals(ConversionRule.ELEMENT.toString()) || tc.rule().toString().equals(ConversionRule.KEY.toString()) || tc.rule().toString().equals(ConversionRule.COLLECTION.toString())) {
                        mapping.put(key, this.createTypeConverter(tc.converter()));
                        continue;
                    }
                    if (tc.rule().toString().equals(ConversionRule.KEY.toString())) {
                        Class<TypeConverter> converterClass = Thread.currentThread().getContextClassLoader().loadClass(tc.converter());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Converter class: " + converterClass));
                        }
                        if (converterClass.isAssignableFrom(TypeConverter.class)) {
                            mapping.put(key, this.createTypeConverter(tc.converter()));
                            continue;
                        }
                        mapping.put(key, converterClass);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Object placed in mapping for key " + key + " is " + mapping.get(key)));
                        continue;
                    }
                    mapping.put(key, Thread.currentThread().getContextClassLoader().loadClass(tc.converter()));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        block9: for (Method method : methods = clazz.getMethods()) {
            annotations = method.getAnnotations();
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof TypeConversion)) continue;
                TypeConversion tc = (TypeConversion)annotation;
                String key = tc.key();
                if (mapping.containsKey(key)) continue block9;
                if (key != null && key.length() == 0) {
                    key = AnnotationUtils.resolvePropertyName(method);
                    _log.debug((Object)("key from method name... " + key + " - " + method.getName()));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(key + ":" + key));
                }
                if (key == null) continue;
                try {
                    if (tc.rule().equals((Object)ConversionType.APPLICATION)) {
                        this.defaultMappings.put(key, this.createTypeConverter(tc.converter()));
                        continue;
                    }
                    if (tc.rule().toString().equals((Object)ConversionRule.KEY_PROPERTY)) {
                        mapping.put(key, tc.value());
                        continue;
                    }
                    if (!tc.rule().toString().equals(ConversionRule.ELEMENT.toString()) || tc.rule().toString().equals(ConversionRule.KEY.toString()) || tc.rule().toString().equals(ConversionRule.COLLECTION.toString())) {
                        mapping.put(key, this.createTypeConverter(tc.converter()));
                        continue;
                    }
                    if (tc.rule().toString().equals(ConversionRule.KEY.toString())) {
                        Class<TypeConverter> converterClass = Thread.currentThread().getContextClassLoader().loadClass(tc.converter());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Converter class: " + converterClass));
                        }
                        if (converterClass.isAssignableFrom(TypeConverter.class)) {
                            mapping.put(key, this.createTypeConverter(tc.converter()));
                            continue;
                        }
                        mapping.put(key, converterClass);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Object placed in mapping for key " + key + " is " + mapping.get(key)));
                        continue;
                    }
                    mapping.put(key, Thread.currentThread().getContextClassLoader().loadClass(tc.converter()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }
}

