/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.apt;

import com.opensymphony.xwork2.apt.AbstractProcessor;
import com.opensymphony.xwork2.apt.ConversionGenerator;
import com.opensymphony.xwork2.conversion.annotations.Conversion;
import com.opensymphony.xwork2.conversion.annotations.ConversionType;
import com.opensymphony.xwork2.conversion.annotations.TypeConversion;
import com.opensymphony.xwork2.conversion.metadata.ConversionDescription;
import com.opensymphony.xwork2.util.AnnotationUtils;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionProcessor
extends AbstractProcessor {
    private AnnotationTypeDeclaration conversionAnnotation;
    private AnnotationTypeDeclaration typeConversionAnnotation;

    @Override
    public void init() {
        super.init();
        this.conversionAnnotation = (AnnotationTypeDeclaration)this.env.getTypeDeclaration(Conversion.class.getName());
        this.typeConversionAnnotation = (AnnotationTypeDeclaration)this.env.getTypeDeclaration(TypeConversion.class.getName());
    }

    @Override
    public void process() {
        Hashtable<String, List<ConversionDescription>> conversionsByType = new Hashtable<String, List<ConversionDescription>>();
        for (Declaration compDecl : this.env.getDeclarationsAnnotatedWith(this.conversionAnnotation)) {
            InterfaceDeclaration component;
            ArrayList<ConversionDescription> applicationFields = new ArrayList<ConversionDescription>();
            ArrayList<ConversionDescription> classFields = new ArrayList<ConversionDescription>();
            if (compDecl instanceof InterfaceDeclaration) {
                component = (InterfaceDeclaration)compDecl;
                this.addConversionFields(component, applicationFields, classFields);
                conversionsByType.put("", applicationFields);
                conversionsByType.put(component.getQualifiedName(), classFields);
                continue;
            }
            if (!(compDecl instanceof ClassDeclaration)) continue;
            component = (ClassDeclaration)compDecl;
            this.addConversionFields((ClassDeclaration)component, applicationFields, classFields);
            conversionsByType.put("", applicationFields);
            conversionsByType.put(component.getQualifiedName(), classFields);
        }
        List defaultDescriptions = (List)conversionsByType.get("");
        new ConversionGenerator(conversionsByType).generate(this.env.getFiler());
    }

    private void addDefaultConversions(List<ConversionDescription> defaultComponents, List<ConversionDescription> specialComponents) {
        for (ConversionDescription description : defaultComponents) {
            if (specialComponents.contains(description)) continue;
            specialComponents.add(description);
        }
    }

    private ConversionDescription createConversionDescription(MethodDeclaration method, AnnotationMirror annotation) {
        Map values = annotation.getElementValues();
        String property = AnnotationUtils.resolvePropertyName(method);
        if (this.typeConversionAnnotation.equals(annotation.getAnnotationType().getDeclaration())) {
            ConversionDescription result = new ConversionDescription(property);
            for (AnnotationTypeElementDeclaration element : this.typeConversionAnnotation.getMethods()) {
                String name;
                AnnotationValue value = (AnnotationValue)values.get(element);
                if (value == null) {
                    value = element.getDefaultValue();
                }
                if ("rule".equals(name = element.getSimpleName())) {
                    result.setRule(value.getValue().toString());
                    continue;
                }
                if ("converter".equals(name)) {
                    result.setTypeConverter(value.getValue().toString());
                    continue;
                }
                if ("message".equals(name)) {
                    result.setValue(value.getValue().toString());
                    continue;
                }
                if ("key".equals(name)) {
                    String s = value.getValue().toString();
                    if (s == null || s.length() <= 0) continue;
                    result.setProperty(s);
                    continue;
                }
                if (!"type".equals(name)) continue;
                result.setType(value.getValue().toString());
            }
            return result;
        }
        return null;
    }

    private void addConversionFields(ClassDeclaration clazz, List<ConversionDescription> allApplicationFields, List<ConversionDescription> allClassFields) {
        if (clazz == null) {
            return;
        }
        this.processConversionFields((TypeDeclaration)clazz, allApplicationFields, allClassFields);
        ClassType superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            this.addConversionFields(superClazz.getDeclaration(), allApplicationFields, allClassFields);
        }
    }

    private void addConversionFields(InterfaceDeclaration clazz, List<ConversionDescription> allApplicationFields, List<ConversionDescription> allClassFields) {
        if (clazz == null) {
            return;
        }
        this.processConversionFields((TypeDeclaration)clazz, allApplicationFields, allClassFields);
        Collection ifaces = clazz.getSuperinterfaces();
        if (ifaces != null) {
            for (InterfaceType it : ifaces) {
                this.addConversionFields(it.getDeclaration(), allApplicationFields, allClassFields);
            }
        }
    }

    private void processConversionFields(TypeDeclaration clazz, List<ConversionDescription> allApplicationFields, List<ConversionDescription> allClassFields) {
        Collection methods = clazz.getMethods();
        for (MethodDeclaration method : methods) {
            Collection annos = method.getAnnotationMirrors();
            block1: for (AnnotationMirror am : annos) {
                Map values = am.getElementValues();
                for (AnnotationTypeElementDeclaration element : this.typeConversionAnnotation.getMethods()) {
                    ConversionDescription desc;
                    AnnotationValue value = (AnnotationValue)values.get(element);
                    if (value == null) {
                        value = element.getDefaultValue();
                    }
                    if (!"type".equals(element.getSimpleName()) || (desc = this.createConversionDescription(method, am)) == null) continue;
                    if (value.getValue().toString().equals(ConversionType.APPLICATION.toString())) {
                        allApplicationFields.add(desc);
                        continue block1;
                    }
                    allClassFields.add(desc);
                    continue block1;
                }
            }
        }
    }
}

