/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp.asn1;

import java.math.BigInteger;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class BerEncoder
implements AsnEncoder {
    private static final byte LONG_LENGTH = -128;
    private static final byte HIGH_BIT = -128;
    private static final byte EXTENSION_ID = 31;
    private static final byte CONSTRUCTOR = 32;

    protected static int byteToInt(byte n) {
        return n < 0 ? 256 + n : n;
    }

    protected static long byteToLong(byte by) {
        return by < 0 ? 256L + (long)by : (long)by;
    }

    protected static boolean isConstructor(byte by) {
        return (by & 0x20) == 32;
    }

    protected static boolean isExtensionId(byte by) {
        return (by & 0x1F) == 31;
    }

    protected static void copy(byte[] byArray, int n, byte[] byArray2, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (byArray2.length - n2 < n3 || byArray.length - n < n3) {
            throw new ArrayIndexOutOfBoundsException("Destination or source buffer is insufficent");
        }
        for (int i = n3 - 1; i >= 0; --i) {
            byArray2[n2 + i] = byArray[n + i];
        }
    }

    protected static void copy(int[] nArray, int n, int[] nArray2, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (nArray2.length - n2 < n3 || nArray.length - n < n3) {
            throw new ArrayIndexOutOfBoundsException("Destination or source buffer is insufficent");
        }
        for (int i = n3 - 1; i >= 0; --i) {
            nArray2[n2 + i] = nArray[n + i];
        }
    }

    protected static void rotate(byte[] byArray, int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        int n4 = n3 - n2;
        byte[] byArray2 = new byte[n4];
        BerEncoder.copy(byArray, n2, byArray2, 0, n4);
        for (int i = n2 - n - 1; i >= 0; --i) {
            byArray[n + n4 + i] = byArray[n + i];
        }
        BerEncoder.copy(byArray2, 0, byArray, n, n4);
    }

    public int buildLength(byte[] byArray, int n, int n2) throws AsnEncodingException {
        if (n2 <= 127) {
            if (byArray.length - n < 1) {
                throw new AsnEncodingException("Buffer overflow error");
            }
            byArray[n++] = (byte)(n2 & 0x7F);
        } else if (n2 <= 255) {
            if (byArray.length - n < 2) {
                throw new AsnEncodingException("Buffer overflow error");
            }
            byArray[n++] = -127;
            byArray[n++] = (byte)(n2 & 0xFF);
        } else {
            if (byArray.length - n < 3) {
                throw new AsnEncodingException("Buffer overflow error");
            }
            byArray[n++] = -126;
            byArray[n++] = (byte)(n2 >>> 8 & 0xFF);
            byArray[n++] = (byte)(n2 & 0xFF);
        }
        return n;
    }

    public Object[] parseLength(byte[] byArray, int n) throws AsnDecodingException {
        byte by;
        if (byArray.length - n < 1) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        Object[] objectArray = new Object[2];
        if (((by = byArray[n++]) & 0xFFFFFF80) == 0) {
            by = (byte)(by & 0x7F);
            objectArray[1] = new Integer(BerEncoder.byteToInt(by));
        } else if ((by = (byte)(by & 0x7F)) == 1) {
            if (byArray.length - n < 1) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            objectArray[1] = new Integer(BerEncoder.byteToInt(byArray[n++]));
        } else if (by == 2) {
            if (byArray.length - n < 2) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            int n2 = BerEncoder.byteToInt(byArray[n++]) << 8 | BerEncoder.byteToInt(byArray[n++]);
            objectArray[1] = new Integer(n2);
        } else {
            throw new AsnDecodingException("Invalid ASN.1 length");
        }
        objectArray[0] = new Integer(n);
        return objectArray;
    }

    public int buildHeader(byte[] byArray, int n, byte by, int n2) throws AsnEncodingException {
        if (byArray.length - n < 1) {
            throw new AsnEncodingException("Buffer overflow error");
        }
        byArray[n++] = by;
        return this.buildLength(byArray, n, n2);
    }

    public Object[] parseHeader(byte[] byArray, int n) throws AsnDecodingException {
        byte by;
        if (byArray.length - n < 1) {
            throw new AsnDecodingException("Insufficent buffer length");
        }
        if (BerEncoder.isExtensionId(by = byArray[n++])) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        Object[] objectArray = this.parseLength(byArray, n);
        Object[] objectArray2 = new Object[]{objectArray[0], new Byte(by), objectArray[1]};
        return objectArray2;
    }

    public int buildInteger32(byte[] byArray, int n, byte by, int n2) throws AsnEncodingException {
        int n3 = -8388608;
        int n4 = 4;
        while (((n2 & n3) == 0 || (n2 & n3) == n3) && n4 > 1) {
            --n4;
            n2 <<= 8;
        }
        if (byArray.length - (n = this.buildHeader(byArray, n, by, n4)) < n4) {
            throw new AsnEncodingException("Insufficent buffer size");
        }
        n3 = -16777216;
        while (n4-- > 0) {
            byte by2 = (byte)((n2 & n3) >>> 24);
            byArray[n++] = by2;
            n2 <<= 8;
        }
        return n;
    }

    public Object[] parseInteger32(byte[] byArray, int n) throws AsnDecodingException {
        Object[] objectArray = this.parseHeader(byArray, n);
        n = (Integer)objectArray[0];
        Byte by = (Byte)objectArray[1];
        int n2 = (Integer)objectArray[2];
        if (byArray.length - n < n2) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        if (n2 > 4) {
            throw new AsnDecodingException("Integer too large: cannot decode");
        }
        int n3 = 0;
        if ((byArray[n] & 0xFFFFFF80) == -128) {
            n3 = -1;
        }
        while (n2-- > 0) {
            n3 = n3 << 8 | BerEncoder.byteToInt(byArray[n++]);
        }
        Object[] objectArray2 = new Object[]{new Integer(n), by, new Integer(n3)};
        return objectArray2;
    }

    public int buildUInteger32(byte[] byArray, int n, byte by, long l) throws AsnEncodingException {
        long l2 = 0xFF800000L;
        int n2 = 4;
        boolean bl = false;
        if (l > Integer.MAX_VALUE) {
            bl = true;
            ++n2;
        }
        while ((l & l2) == 0L && n2 > 1) {
            --n2;
            l <<= 8;
        }
        if (byArray.length - (n = this.buildHeader(byArray, n, by, n2)) < n2) {
            throw new AsnEncodingException("Buffer overflow error");
        }
        if (bl) {
            byArray[n++] = 0;
            --n2;
        }
        l2 = 0xFF000000L;
        while (n2-- > 0) {
            byte by2 = (byte)((l & l2) >>> 24);
            byArray[n++] = by2;
            l <<= 8;
        }
        return n;
    }

    public Object[] parseUInteger32(byte[] byArray, int n) throws AsnDecodingException {
        Object[] objectArray = this.parseHeader(byArray, n);
        n = (Integer)objectArray[0];
        Byte by = (Byte)objectArray[1];
        int n2 = (Integer)objectArray[2];
        if (byArray.length - n < n2) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        if (n2 > 5) {
            throw new AsnDecodingException("Integer too large: cannot decode");
        }
        long l = 0L;
        if ((byArray[n] & 0xFFFFFF80) == -128) {
            l = -1L;
        }
        while (n2-- > 0) {
            l = l << 8 | BerEncoder.byteToLong(byArray[n++]);
        }
        Object[] objectArray2 = new Object[]{new Integer(n), by, new Long(l &= 0xFFFFFFFFL)};
        return objectArray2;
    }

    public int buildUInteger64(byte[] byArray, int n, byte by, BigInteger bigInteger) throws AsnEncodingException {
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray.length - (n = this.buildHeader(byArray, n, by, byArray2.length)) < byArray2.length) {
            throw new AsnEncodingException("Buffer overflow error");
        }
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[n++] = byArray2[i];
        }
        return n;
    }

    public Object[] parseUInteger64(byte[] byArray, int n) throws AsnDecodingException {
        Object[] objectArray = this.parseHeader(byArray, n);
        n = (Integer)objectArray[0];
        Byte by = (Byte)objectArray[1];
        int n2 = (Integer)objectArray[2];
        if (byArray.length - n < n2) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        if (n2 > 9) {
            throw new AsnDecodingException("Integer too large: cannot decode");
        }
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = byArray[n++];
        }
        BigInteger bigInteger = new BigInteger(byArray2);
        Object[] objectArray2 = new Object[]{new Integer(n), by, bigInteger};
        return objectArray2;
    }

    public int buildNull(byte[] byArray, int n, byte by) throws AsnEncodingException {
        return this.buildHeader(byArray, n, by, 0);
    }

    public Object[] parseNull(byte[] byArray, int n) throws AsnDecodingException {
        Object[] objectArray = this.parseHeader(byArray, n);
        if ((Integer)objectArray[2] != 0) {
            throw new AsnDecodingException("Malformed ASN.1 Type");
        }
        Object[] objectArray2 = new Object[]{objectArray[0], objectArray[1]};
        return objectArray2;
    }

    public int buildString(byte[] byArray, int n, byte by, byte[] byArray2) throws AsnEncodingException {
        int n2 = byArray2.length;
        if (byArray.length - (n = this.buildHeader(byArray, n, by, n2)) < byArray2.length) {
            throw new AsnEncodingException("Insufficent buffer length");
        }
        try {
            BerEncoder.copy(byArray2, 0, byArray, n, byArray2.length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new AsnEncodingException("Buffer overflow error");
        }
        return n + byArray2.length;
    }

    public Object[] parseString(byte[] byArray, int n) throws AsnDecodingException {
        Object[] objectArray = this.parseHeader(byArray, n);
        n = (Integer)objectArray[0];
        Byte by = (Byte)objectArray[1];
        int n2 = (Integer)objectArray[2];
        if (byArray.length - n < n2) {
            throw new AsnDecodingException("Insufficent buffer length");
        }
        byte[] byArray2 = new byte[n2];
        try {
            BerEncoder.copy(byArray, n, byArray2, 0, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new AsnDecodingException("Buffer underflow exception");
        }
        Object[] objectArray2 = new Object[]{new Integer(n + n2), by, byArray2};
        return objectArray2;
    }

    public int buildObjectId(byte[] byArray, int n, byte by, int[] nArray) throws AsnEncodingException {
        int n2;
        int n3;
        int n4;
        if (byArray.length - n < 1) {
            throw new AsnEncodingException("Buffer overflow error");
        }
        int[] nArray2 = nArray;
        int n5 = n;
        if (nArray.length < 2) {
            nArray2 = new int[]{0, 0};
        }
        if (nArray2[0] < 0 || nArray2[0] > 2) {
            throw new AsnEncodingException("Invalid Object Identifier");
        }
        if (nArray2[1] < 0 || nArray2[1] > 40) {
            throw new AsnEncodingException("Invalid Object Identifier");
        }
        byArray[n++] = (byte)(nArray2[0] * 40 + nArray2[1]);
        int n6 = 2;
        while (n6 < nArray2.length) {
            if ((n4 = nArray2[n6++]) >= 0 && n4 < 127) {
                if (byArray.length - n < 1) {
                    throw new AsnEncodingException("Buffer overflow error");
                }
                byArray[n++] = (byte)n4;
                continue;
            }
            n3 = 0;
            n2 = 0;
            int n7 = 0;
            int n8 = 0;
            n7 = 127;
            n8 = 0;
            while (n7 != 0) {
                if ((n4 & n7) != 0) {
                    n3 = n7;
                    n2 = n8;
                }
                n7 <<= 7;
                n8 += 7;
            }
            while (n3 != 127) {
                if (byArray.length - n < 1) {
                    throw new AsnEncodingException("Buffer overflow error");
                }
                byArray[n++] = (byte)((n4 & n3) >>> n2 | 0xFFFFFF80);
                n2 -= 7;
                if ((n3 >>>= 7) != 0x1E00000) continue;
                n3 = 0xFE00000;
            }
            if (byArray.length - n < 1) {
                throw new AsnEncodingException("Insufficent buffer space");
            }
            byArray[n++] = (byte)(n4 & n3);
        }
        n4 = n;
        n3 = n4 - n5;
        n2 = this.buildHeader(byArray, n4, by, n3);
        try {
            BerEncoder.rotate(byArray, n5, n4, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new AsnEncodingException("Insufficent buffer space");
        }
        return n2;
    }

    public Object[] parseObjectId(byte[] byArray, int n) throws AsnDecodingException {
        int[] nArray;
        Object[] objectArray = this.parseHeader(byArray, n);
        n = (Integer)objectArray[0];
        Byte by = (Byte)objectArray[1];
        int n2 = (Integer)objectArray[2];
        if (byArray.length - n < n2) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        if (n2 == 0) {
            int[] nArray2 = new int[2];
            nArray2[1] = 0;
            nArray2[0] = 0;
            Object[] objectArray2 = new Object[]{new Integer(n), by, nArray2};
            return objectArray2;
        }
        int n3 = 0;
        int[] nArray3 = new int[n2 + 1];
        --n2;
        int n4 = BerEncoder.byteToInt(byArray[n++]);
        nArray3[n3++] = n4 / 40;
        nArray3[n3++] = n4 % 40;
        while (n2 > 0) {
            n4 = 0;
            boolean bl = false;
            do {
                --n2;
                byte by2 = byArray[n++];
                n4 = n4 << 7 | by2 & 0x7F;
                if ((by2 & 0xFFFFFF80) != 0) continue;
                bl = true;
            } while (!bl);
            nArray3[n3++] = n4;
        }
        if (n3 == nArray3.length) {
            nArray = nArray3;
        } else {
            nArray = new int[n3];
            BerEncoder.copy(nArray3, 0, nArray, 0, n3);
        }
        Object[] objectArray3 = new Object[]{new Integer(n), by, nArray};
        return objectArray3;
    }
}

