/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.PrintStream;
import java.util.ArrayList;
import org.opennms.protocols.snmp.SnmpCounter32;
import org.opennms.protocols.snmp.SnmpCounter64;
import org.opennms.protocols.snmp.SnmpEndOfMibView;
import org.opennms.protocols.snmp.SnmpGauge32;
import org.opennms.protocols.snmp.SnmpIPAddress;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpNoSuchInstance;
import org.opennms.protocols.snmp.SnmpNoSuchObject;
import org.opennms.protocols.snmp.SnmpNull;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpOpaque;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimeTicks;
import org.opennms.protocols.snmp.SnmpV2PartyClock;

class SnmpUtil {
    static ArrayList m_syntaxArray = null;

    SnmpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean registerSyntax(SnmpSyntax snmpSyntax) {
        boolean bl = false;
        ArrayList arrayList = m_syntaxArray;
        synchronized (arrayList) {
            boolean bl2 = true;
            for (int i = 0; i < m_syntaxArray.size(); ++i) {
                SnmpSyntax snmpSyntax2 = (SnmpSyntax)m_syntaxArray.get(i);
                if (snmpSyntax.typeId() != snmpSyntax2.typeId()) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                bl = m_syntaxArray.add(snmpSyntax);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SnmpSyntax getSyntaxObject(byte by) {
        SnmpSyntax snmpSyntax = null;
        switch (by) {
            case 2: {
                snmpSyntax = new SnmpInt32();
                break;
            }
            case 65: {
                snmpSyntax = new SnmpCounter32();
                break;
            }
            case 66: {
                snmpSyntax = new SnmpGauge32();
                break;
            }
            case 70: {
                snmpSyntax = new SnmpCounter64();
                break;
            }
            case 67: {
                snmpSyntax = new SnmpTimeTicks();
                break;
            }
            case 4: {
                snmpSyntax = new SnmpOctetString();
                break;
            }
            case 68: {
                snmpSyntax = new SnmpOpaque();
                break;
            }
            case 64: {
                snmpSyntax = new SnmpIPAddress();
                break;
            }
            case 6: {
                snmpSyntax = new SnmpObjectId();
                break;
            }
            case 71: {
                snmpSyntax = new SnmpV2PartyClock();
                break;
            }
            case -127: {
                snmpSyntax = new SnmpNoSuchInstance();
                break;
            }
            case -128: {
                snmpSyntax = new SnmpNoSuchObject();
                break;
            }
            case -126: {
                snmpSyntax = new SnmpEndOfMibView();
                break;
            }
            case 5: {
                snmpSyntax = new SnmpNull();
            }
        }
        if (snmpSyntax == null) {
            ArrayList arrayList = m_syntaxArray;
            synchronized (arrayList) {
                for (int i = m_syntaxArray.size() - 1; i >= 0; --i) {
                    SnmpSyntax snmpSyntax2 = (SnmpSyntax)m_syntaxArray.get(i);
                    if (by != snmpSyntax2.typeId()) continue;
                    snmpSyntax = snmpSyntax2.duplicate();
                    break;
                }
            }
        }
        return snmpSyntax;
    }

    static void rotate(byte[] byArray, int n, int n2, int n3) {
        int n4 = n3 - n2;
        int n5 = n2 - n;
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n2, byArray2, 0, n4);
        System.arraycopy(byArray, n, byArray, n + n4, n5);
        System.arraycopy(byArray2, 0, byArray, n, n4);
    }

    static void dumpHex(PrintStream printStream, byte[] byArray, int n, int n2) {
        if (n + n2 > byArray.length) {
            return;
        }
        int n3 = 0;
        while (n2 > 0) {
            byte by = byArray[n];
            printStream.print("0x");
            printStream.print(Integer.toHexString(by >> 4 & 0xF));
            printStream.print(Integer.toHexString(by & 0xF));
            printStream.print(" ");
            --n2;
            ++n;
            if (n3++ % 16 != 0 || n3 == 1) continue;
            printStream.println("");
        }
    }

    static {
        m_syntaxArray = new ArrayList();
    }
}

