/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class SnmpTimer {
    private LinkedList m_list;
    private Thread m_thread;
    private boolean m_exit = false;
    private Object m_sync = new Object();

    SnmpTimer() {
        this.m_list = new LinkedList();
        this.m_thread = new Thread((Runnable)new Scheduler(), "SnmpTimer");
        this.m_thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(Runnable runnable, long l) {
        if (runnable != null) {
            Object object = this.m_sync;
            synchronized (object) {
                this.m_list.add(new TimeoutElement(l, runnable));
                this.m_sync.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        Object object = this.m_sync;
        synchronized (object) {
            this.m_exit = true;
            this.m_sync.notify();
        }
        try {
            if (!this.m_thread.equals(Thread.currentThread())) {
                this.m_thread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private class Scheduler
    implements Runnable {
        private Scheduler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LinkedList<Runnable> linkedList = new LinkedList<Runnable>();
            while (true) {
                Object object;
                ListIterator listIterator = SnmpTimer.this.m_sync;
                synchronized (listIterator) {
                    if (SnmpTimer.this.m_exit) {
                        return;
                    }
                    if (SnmpTimer.this.m_list.size() == 0) {
                        try {
                            SnmpTimer.this.m_sync.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    object = new Date();
                    boolean bl = false;
                    long l = Long.MAX_VALUE;
                    ListIterator listIterator2 = SnmpTimer.this.m_list.listIterator(0);
                    while (!bl && listIterator2.hasNext()) {
                        try {
                            TimeoutElement timeoutElement = (TimeoutElement)listIterator2.next();
                            if (((Date)object).after(timeoutElement.m_when)) {
                                linkedList.add(timeoutElement.m_toRun);
                                listIterator2.remove();
                                continue;
                            }
                            if (timeoutElement.m_when.getTime() >= l) continue;
                            l = timeoutElement.m_when.getTime();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            bl = true;
                        }
                        catch (ConcurrentModificationException concurrentModificationException) {
                            bl = true;
                        }
                    }
                    if (linkedList.size() == 0) {
                        l -= ((Date)object).getTime();
                        try {
                            if (l > 0L) {
                                SnmpTimer.this.m_sync.wait(l);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                }
                if (linkedList.size() == 0) continue;
                listIterator = linkedList.listIterator(0);
                try {
                    while (true) {
                        object = (Runnable)listIterator.next();
                        listIterator.remove();
                        object.run();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {}
                finally {
                    continue;
                }
                break;
            }
        }
    }

    private class TimeoutElement {
        public Runnable m_toRun;
        public Date m_when = new Date();

        TimeoutElement(long l, Runnable runnable) {
            this.m_when.setTime(this.m_when.getTime() + l);
            this.m_toRun = runnable;
        }
    }
}

