/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.ListIterator;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpHandlerNotDefinedException;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPacketHandler;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduEncodingException;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpPortal;
import org.opennms.protocols.snmp.SnmpRequest;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimer;
import org.opennms.protocols.snmp.SnmpUtil;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpSession {
    public static final int ERROR_TIMEOUT = -1;
    public static final int ERROR_IOEXCEPTION = -2;
    public static final int ERROR_ENCODING = -3;
    private LinkedList m_requests;
    private SnmpPeer m_peer;
    private SnmpTimer m_timer;
    private SnmpHandler m_defHandler;
    AsnEncoder m_encoder;
    private Object m_sync;
    private boolean m_stopRun;
    private SnmpPortal m_portal;
    private boolean m_threadException;
    private Throwable m_why;

    private ByteArrayInfo encode(SnmpPduPacket snmpPduPacket) throws SnmpPduEncodingException, AsnEncodingException {
        SnmpOctetString snmpOctetString;
        SnmpPeer snmpPeer = this.m_peer;
        SnmpParameters snmpParameters = snmpPeer.getParameters();
        boolean bl = false;
        int n = 0;
        byte[] byArray = new byte[16384];
        SnmpInt32 snmpInt32 = new SnmpInt32(snmpParameters.getVersion());
        n = snmpInt32.encodeASN(byArray, n, this.m_encoder);
        if (snmpPduPacket.getCommand() == 163) {
            String string = snmpParameters.getWriteCommunity();
            if (string == null) {
                throw new SnmpPduEncodingException("Requested SET but there is no write community");
            }
            snmpOctetString = new SnmpOctetString(string.getBytes());
        } else {
            snmpOctetString = new SnmpOctetString(snmpParameters.getReadCommunity().getBytes());
        }
        n = snmpOctetString.encodeASN(byArray, n, this.m_encoder);
        int n2 = n = snmpPduPacket.encodeASN(byArray, n, this.m_encoder);
        n = this.m_encoder.buildHeader(byArray, n, (byte)48, n2);
        SnmpUtil.rotate(byArray, 0, n2, n);
        return new ByteArrayInfo(byArray, n);
    }

    private ByteArrayInfo encode(SnmpPduTrap snmpPduTrap) throws SnmpPduEncodingException, AsnEncodingException {
        SnmpPeer snmpPeer = this.m_peer;
        SnmpParameters snmpParameters = snmpPeer.getParameters();
        boolean bl = false;
        int n = 0;
        byte[] byArray = new byte[16384];
        SnmpInt32 snmpInt32 = new SnmpInt32(snmpParameters.getVersion());
        n = snmpInt32.encodeASN(byArray, n, this.m_encoder);
        SnmpOctetString snmpOctetString = new SnmpOctetString(snmpParameters.getReadCommunity().getBytes());
        n = snmpOctetString.encodeASN(byArray, n, this.m_encoder);
        int n2 = n = snmpPduTrap.encodeASN(byArray, n, this.m_encoder);
        n = this.m_encoder.buildHeader(byArray, n, (byte)48, n2);
        SnmpUtil.rotate(byArray, 0, n2, n);
        return new ByteArrayInfo(byArray, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRequest(SnmpRequest snmpRequest) {
        LinkedList linkedList = this.m_requests;
        synchronized (linkedList) {
            this.m_requests.addLast(snmpRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRequest(SnmpRequest snmpRequest) {
        LinkedList linkedList = this.m_requests;
        synchronized (linkedList) {
            if (this.m_requests.size() > 0) {
                ListIterator listIterator = this.m_requests.listIterator(0);
                while (listIterator.hasNext()) {
                    SnmpRequest snmpRequest2 = (SnmpRequest)listIterator.next();
                    if (!snmpRequest.equals(snmpRequest2)) continue;
                    snmpRequest.m_expired = true;
                    listIterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SnmpRequest findRequest(SnmpPduPacket snmpPduPacket) {
        LinkedList linkedList = this.m_requests;
        synchronized (linkedList) {
            if (this.m_requests.size() > 0) {
                ListIterator listIterator = this.m_requests.listIterator(0);
                while (listIterator.hasNext()) {
                    SnmpRequest snmpRequest = (SnmpRequest)listIterator.next();
                    if (snmpRequest.m_expired || !(snmpRequest.m_pdu instanceof SnmpPduPacket) || ((SnmpPduPacket)snmpRequest.m_pdu).getRequestId() != snmpPduPacket.getRequestId()) continue;
                    return snmpRequest;
                }
            }
        }
        return null;
    }

    SnmpTimer getTimer() {
        return this.m_timer;
    }

    void transmit(SnmpRequest snmpRequest) throws SnmpPduEncodingException, AsnEncodingException, IOException {
        SnmpPduPacket snmpPduPacket = null;
        SnmpPduTrap snmpPduTrap = null;
        SnmpPeer snmpPeer = this.m_peer;
        SnmpParameters snmpParameters = snmpPeer.getParameters();
        if (snmpRequest.m_pdu instanceof SnmpPduPacket) {
            snmpPduPacket = (SnmpPduPacket)snmpRequest.m_pdu;
        }
        if (snmpRequest.m_pdu instanceof SnmpPduTrap) {
            snmpPduTrap = (SnmpPduTrap)snmpRequest.m_pdu;
        }
        if (snmpPduPacket != null) {
            switch (snmpPduPacket.getCommand()) {
                case 165: 
                case 166: 
                case 167: 
                case 168: {
                    if (snmpParameters.getVersion() >= 1) break;
                    throw new SnmpPduEncodingException("Cannot send pdu, invalid SNMP version");
                }
            }
            ByteArrayInfo byteArrayInfo = this.encode(snmpPduPacket);
            if (snmpPduPacket.getPeer() == null) {
                this.m_portal.send(this.m_peer, byteArrayInfo.array(), byteArrayInfo.size());
            } else {
                this.m_portal.send(snmpPduPacket.getPeer(), byteArrayInfo.array(), byteArrayInfo.size());
            }
        } else if (snmpPduTrap != null) {
            ByteArrayInfo byteArrayInfo = this.encode(snmpPduTrap);
            this.m_portal.send(this.m_peer, byteArrayInfo.array(), byteArrayInfo.size());
        } else {
            throw new SnmpPduEncodingException("Invalid PDU type passed to method");
        }
    }

    public SnmpSession(InetAddress inetAddress) throws SocketException {
        this.m_sync = new Object();
        this.m_requests = new LinkedList();
        this.m_peer = new SnmpPeer(inetAddress);
        this.m_timer = new SnmpTimer();
        this.m_defHandler = null;
        this.m_stopRun = false;
        this.m_encoder = new SnmpParameters().getEncoder();
        this.m_portal = new SnmpPortal(new SessionHandler(), this.m_encoder, 0);
        this.m_threadException = false;
        this.m_why = null;
        this.m_timer.schedule(new CleanupRequest(), 1000L);
    }

    public SnmpSession(SnmpPeer snmpPeer) throws SocketException {
        this.m_requests = new LinkedList();
        this.m_timer = new SnmpTimer();
        this.m_defHandler = null;
        this.m_sync = new Object();
        this.m_stopRun = false;
        this.m_encoder = snmpPeer.getParameters().getEncoder();
        this.m_portal = new SnmpPortal(new SessionHandler(), this.m_encoder, snmpPeer.getServerPort());
        this.m_threadException = false;
        this.m_why = null;
        this.m_peer = snmpPeer;
        this.m_timer.schedule(new CleanupRequest(), 5000L);
    }

    public SnmpSession(InetAddress inetAddress, SnmpParameters snmpParameters) throws SocketException {
        this(inetAddress);
        this.m_peer.setParameters(snmpParameters);
    }

    public SnmpHandler getDefaultHandler() {
        return this.m_defHandler;
    }

    public void setDefaultHandler(SnmpHandler snmpHandler) {
        this.m_defHandler = snmpHandler;
    }

    public SnmpPeer getPeer() {
        return this.m_peer;
    }

    public void setPeer(SnmpPeer snmpPeer) {
        this.m_peer = snmpPeer;
        this.setAsnEncoder(snmpPeer.getParameters().getEncoder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutstandingCount() {
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_stopRun) {
                throw new IllegalStateException("illegal operation, the session has been closed");
            }
        }
        object = this.m_requests;
        synchronized (object) {
            if (this.m_requests.size() > 0) {
                ListIterator listIterator = this.m_requests.listIterator();
                while (listIterator.hasNext()) {
                    SnmpRequest snmpRequest = (SnmpRequest)listIterator.next();
                    if (!snmpRequest.m_expired) continue;
                    listIterator.remove();
                }
            }
            return this.m_requests.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(int n) {
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_stopRun) {
                throw new IllegalStateException("illegal operation, the session has been closed");
            }
        }
        object = this.m_requests;
        synchronized (object) {
            if (this.m_requests.size() > 0) {
                ListIterator listIterator = this.m_requests.listIterator();
                while (listIterator.hasNext()) {
                    SnmpRequest snmpRequest = (SnmpRequest)listIterator.next();
                    if (!snmpRequest.m_expired && (!(snmpRequest.m_pdu instanceof SnmpPduPacket) || ((SnmpPduPacket)snmpRequest.m_pdu).getRequestId() != n)) continue;
                    snmpRequest.m_expired = true;
                    listIterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(SnmpPduPacket snmpPduPacket, SnmpHandler snmpHandler) {
        if (snmpHandler == null) {
            throw new SnmpHandlerNotDefinedException("No Handler Defined");
        }
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_stopRun) {
                throw new IllegalStateException("illegal operation, the session has been closed");
            }
        }
        object = new SnmpRequest(this, snmpPduPacket, snmpHandler);
        if (snmpPduPacket.getCommand() != 167 || snmpPduPacket.getPeer() == null) {
            this.addRequest((SnmpRequest)object);
        }
        ((SnmpRequest)object).run();
        if (((SnmpRequest)object).m_expired) {
            return 0;
        }
        return ((SnmpPduPacket)((SnmpRequest)object).m_pdu).getRequestId();
    }

    public int send(SnmpPduPacket snmpPduPacket) {
        if (this.m_defHandler == null) {
            throw new SnmpHandlerNotDefinedException("No Handler Defined");
        }
        return this.send(snmpPduPacket, this.m_defHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(SnmpPduTrap snmpPduTrap, SnmpHandler snmpHandler) {
        if (snmpHandler == null) {
            throw new SnmpHandlerNotDefinedException("No Handler Defined");
        }
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_stopRun) {
                throw new IllegalStateException("illegal operation, the session has been closed");
            }
        }
        object = new SnmpRequest(this, snmpPduTrap, snmpHandler);
        ((SnmpRequest)object).run();
        return 0;
    }

    public int send(SnmpPduTrap snmpPduTrap) {
        if (this.m_defHandler == null) {
            throw new SnmpHandlerNotDefinedException("No Handler Defined");
        }
        return this.send(snmpPduTrap, this.m_defHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.m_sync;
        synchronized (object) {
            return this.m_stopRun;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_stopRun) {
                throw new IllegalStateException("The session is already closed");
            }
            this.m_stopRun = true;
            this.m_timer.cancel();
            this.m_portal.close();
        }
        object = this.m_requests;
        synchronized (object) {
            this.m_requests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raise() throws Throwable {
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_threadException) {
                throw this.m_why;
            }
        }
    }

    public void setAsnEncoder(AsnEncoder asnEncoder) {
        this.m_encoder = asnEncoder;
        this.m_portal.setAsnEncoder(asnEncoder);
    }

    public AsnEncoder getAsnEncoder() {
        return this.m_encoder;
    }

    public static void registerSyntaxObject(SnmpSyntax snmpSyntax) {
        SnmpUtil.registerSyntax(snmpSyntax);
    }

    private static class ByteArrayInfo {
        private byte[] m_buf;
        private int m_length;

        public ByteArrayInfo(byte[] byArray, int n) {
            this.m_buf = byArray;
            this.m_length = n;
        }

        public byte[] array() {
            return this.m_buf;
        }

        public int size() {
            return this.m_length;
        }
    }

    private class CleanupRequest
    implements Runnable {
        private CleanupRequest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LinkedList linkedList = SnmpSession.this.m_requests;
            synchronized (linkedList) {
                if (SnmpSession.this.m_requests.size() > 0) {
                    ListIterator listIterator = SnmpSession.this.m_requests.listIterator(0);
                    while (listIterator.hasNext()) {
                        SnmpRequest snmpRequest = (SnmpRequest)listIterator.next();
                        if (!snmpRequest.m_expired) continue;
                        listIterator.remove();
                    }
                }
            }
            if (!SnmpSession.this.m_stopRun && !SnmpSession.this.m_threadException) {
                SnmpSession.this.m_timer.schedule(this, 1000L);
            }
        }
    }

    private class SessionHandler
    implements SnmpPacketHandler {
        private SessionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processSnmpMessage(InetAddress inetAddress, int n, SnmpInt32 snmpInt32, SnmpOctetString snmpOctetString, int n2, SnmpPduPacket snmpPduPacket) throws SnmpPduEncodingException {
            boolean bl = false;
            SnmpRequest snmpRequest = null;
            LinkedList linkedList = SnmpSession.this.m_requests;
            synchronized (linkedList) {
                snmpRequest = SnmpSession.this.findRequest(snmpPduPacket);
                if (snmpRequest != null) {
                    bl = snmpRequest.m_expired;
                }
            }
            if (!bl) {
                int n3 = -1;
                if (snmpRequest != null && snmpRequest.m_pdu instanceof SnmpPduPacket) {
                    n3 = ((SnmpPduPacket)snmpRequest.m_pdu).getCommand();
                } else {
                    n3 = snmpPduPacket.getCommand();
                    snmpPduPacket.setPeer(new SnmpPeer(inetAddress, n));
                }
                switch (n3) {
                    case 163: {
                        String string = new String(snmpOctetString.getString());
                        String string2 = SnmpSession.this.m_peer.getParameters().getWriteCommunity();
                        if (string.equals(string2)) break;
                        throw new SnmpPduEncodingException("Invalid community string");
                    }
                    case 160: 
                    case 161: 
                    case 162: 
                    case 165: 
                    case 166: 
                    case 168: {
                        String string = new String(snmpOctetString.getString());
                        String string3 = SnmpSession.this.m_peer.getParameters().getReadCommunity();
                        if (string.equals(string3)) break;
                        throw new SnmpPduEncodingException("Invalid community string");
                    }
                    default: {
                        throw new SnmpPduEncodingException("Invalid PDU Type for session received");
                    }
                }
                if (snmpRequest != null) {
                    snmpRequest.m_expired = true;
                    snmpRequest.m_handler.snmpReceivedPdu(snmpRequest.m_session, ((SnmpPduRequest)snmpPduPacket).getCommand(), (SnmpPduRequest)snmpPduPacket);
                } else {
                    SnmpSession.this.m_defHandler.snmpReceivedPdu(null, n3, snmpPduPacket);
                }
            }
        }

        public void processSnmpTrap(InetAddress inetAddress, int n, SnmpOctetString snmpOctetString, SnmpPduTrap snmpPduTrap) throws SnmpPduEncodingException {
            throw new SnmpPduEncodingException("Invalid PDU Type for session");
        }

        public void processBadDatagram(DatagramPacket datagramPacket) {
        }

        public void processException(Exception exception) {
        }
    }
}

