/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Date;
import java.util.LinkedList;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPacketHandler;
import org.opennms.protocols.snmp.SnmpPduBulk;
import org.opennms.protocols.snmp.SnmpPduEncodingException;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpUtil;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;

public class SnmpPortal {
    private SnmpPacketHandler m_handler;
    private DatagramSocket m_comm;
    private Thread m_recvThread;
    private AsnEncoder m_encoder;
    private volatile boolean m_isClosing;
    private boolean bSocketSoTimeoutRequired = true;
    private static final String PROP_SOCKET_TIMEOUT_REQUIRED = "org.opennms.joeSNMP.vmhacks.socketSoTimeoutRequired";
    private static final String PROP_SOCKET_TIMEOUT_PERIOD = "org.opennms.joeSNMP.vmhacks.socketSoTimeoutPeriod";
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Throwable;

    private SnmpPortal() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Illegal constructor call");
    }

    SnmpPortal(SnmpPacketHandler snmpPacketHandler, AsnEncoder asnEncoder, int n) throws SocketException {
        if (snmpPacketHandler == null || asnEncoder == null) {
            throw new IllegalArgumentException("Invalid argument");
        }
        this.m_handler = snmpPacketHandler;
        this.m_comm = n >= 0 ? new DatagramSocket(n) : new DatagramSocket();
        this.bSocketSoTimeoutRequired = true;
        String string = System.getProperty(PROP_SOCKET_TIMEOUT_REQUIRED);
        String string2 = System.getProperty("os.name");
        if (string != null && string.equals("no")) {
            this.bSocketSoTimeoutRequired = false;
        }
        if (this.bSocketSoTimeoutRequired) {
            String string3 = System.getProperty(PROP_SOCKET_TIMEOUT_PERIOD);
            int n2 = 3000;
            if (string3 != null) {
                try {
                    n2 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 3000;
                }
            }
            this.m_comm.setSoTimeout(n2);
        } else if (string2 != null && string2.equalsIgnoreCase("linux")) {
            this.m_comm.setSoTimeout(100);
        }
        this.m_isClosing = false;
        this.m_recvThread = new Thread((Runnable)new Receiver(), "SnmpPortal-" + this.m_comm.getPort());
        this.m_encoder = asnEncoder;
        this.m_recvThread.start();
    }

    void handlePkt(DatagramPacket datagramPacket) throws SnmpPduEncodingException, AsnDecodingException {
        byte[] byArray = datagramPacket.getData();
        int n = 0;
        Object[] objectArray = this.m_encoder.parseHeader(byArray, n);
        n = (Integer)objectArray[0];
        byte by = (Byte)objectArray[1];
        int n2 = (Integer)objectArray[2];
        if (by != 48) {
            throw new AsnDecodingException("Invalid SNMP ASN.1 type");
        }
        if (n2 > datagramPacket.getLength() - n) {
            throw new SnmpPduEncodingException("Insufficent data in packet");
        }
        SnmpInt32 snmpInt32 = new SnmpInt32();
        n = snmpInt32.decodeASN(byArray, n, this.m_encoder);
        if (snmpInt32.getValue() != 0 && snmpInt32.getValue() != 1) {
            throw new SnmpPduEncodingException("Invalid protocol version");
        }
        SnmpOctetString snmpOctetString = new SnmpOctetString();
        n = snmpOctetString.decodeASN(byArray, n, this.m_encoder);
        objectArray = this.m_encoder.parseHeader(byArray, n);
        int n3 = ((Byte)objectArray[1]).intValue() + 256;
        switch (n3) {
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 166: 
            case 167: 
            case 168: {
                SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
                n = snmpPduRequest.decodeASN(byArray, n, this.m_encoder);
                this.m_handler.processSnmpMessage(datagramPacket.getAddress(), datagramPacket.getPort(), snmpInt32, snmpOctetString, n3, snmpPduRequest);
                break;
            }
            case 165: {
                SnmpPduBulk snmpPduBulk = new SnmpPduBulk();
                n = snmpPduBulk.decodeASN(byArray, n, this.m_encoder);
                this.m_handler.processSnmpMessage(datagramPacket.getAddress(), datagramPacket.getPort(), snmpInt32, snmpOctetString, n3, snmpPduBulk);
                break;
            }
            case 164: {
                SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
                n = snmpPduTrap.decodeASN(byArray, n, this.m_encoder);
                this.m_handler.processSnmpTrap(datagramPacket.getAddress(), datagramPacket.getPort(), snmpOctetString, snmpPduTrap);
                break;
            }
            default: {
                throw new SnmpPduEncodingException("No matching PDU type found");
            }
        }
    }

    void send(SnmpPeer snmpPeer, byte[] byArray, int n) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n, snmpPeer.getPeer(), snmpPeer.getPort());
        this.m_comm.send(datagramPacket);
    }

    void send(SnmpPeer snmpPeer, byte[] byArray) throws IOException {
        this.send(snmpPeer, byArray, byArray.length);
    }

    void setPacketHandler(SnmpPacketHandler snmpPacketHandler) {
        if (snmpPacketHandler == null) {
            throw new IllegalArgumentException("The packet handler must not be null");
        }
        this.m_handler = snmpPacketHandler;
    }

    SnmpPacketHandler getPacketHandler() {
        return this.m_handler;
    }

    void setAsnEncoder(AsnEncoder asnEncoder) {
        if (asnEncoder == null) {
            throw new IllegalArgumentException("The ASN.1 codec must not be null");
        }
        this.m_encoder = asnEncoder;
    }

    AsnEncoder getAsnEncoder() {
        return this.m_encoder;
    }

    boolean isClosed() {
        return this.m_isClosing;
    }

    void close() {
        this.m_isClosing = true;
        this.m_comm.close();
        try {
            if (!this.m_recvThread.equals(Thread.currentThread())) {
                this.m_recvThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Receiver
    implements Runnable {
        private Receiver() {
        }

        private int setup() {
            int n = 65536;
            try {
                SnmpPortal.this.m_comm.setReceiveBufferSize(n);
            }
            catch (SocketException socketException) {
                n = 0;
            }
            if (n == 0) {
                try {
                    n = SnmpPortal.this.m_comm.getReceiveBufferSize();
                }
                catch (SocketException socketException) {
                    n = 0;
                }
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            final int n = this.setup();
            if (n == 0) {
                return;
            }
            final LinkedList linkedList = new LinkedList();
            final LinkedList<byte[]> linkedList2 = new LinkedList<byte[]>();
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (!SnmpPortal.this.m_isClosing) {
                        Thread.currentThread();
                        if (Thread.interrupted()) break;
                        byte[] byArray = null;
                        Object object = linkedList2;
                        synchronized (object) {
                            if (!linkedList2.isEmpty()) {
                                byArray = (byte[])linkedList2.removeFirst();
                            }
                        }
                        if (byArray == null || byArray.length != n) {
                            byArray = new byte[n];
                        }
                        try {
                            object = new DatagramPacket(byArray, byArray.length);
                            SnmpPortal.this.m_comm.receive((DatagramPacket)object);
                            LinkedList linkedList3 = linkedList;
                            synchronized (linkedList3) {
                                linkedList.addLast(object);
                                linkedList.notify();
                            }
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            LinkedList linkedList4 = linkedList2;
                            synchronized (linkedList4) {
                                linkedList2.addLast(byArray);
                            }
                        }
                        catch (Exception exception) {
                            if (SnmpPortal.this.m_isClosing) continue;
                            boolean bl = true;
                            try {
                                Class<?> clazz = Class.forName("org.opennms.core.utils.ThreadCategory");
                                Class[] classArray = new Class[]{class$java$lang$Class == null ? SnmpPortal.class$("java.lang.Class") : class$java$lang$Class};
                                Method method = clazz.getMethod("getInstance", classArray);
                                Object[] objectArray = new Object[]{this.getClass()};
                                Object object2 = method.invoke(null, objectArray);
                                classArray = new Class[]{class$java$lang$Object == null ? SnmpPortal.class$("java.lang.Object") : class$java$lang$Object, class$java$lang$Throwable == null ? SnmpPortal.class$("java.lang.Throwable") : class$java$lang$Throwable};
                                Method method2 = clazz.getMethod("info", classArray);
                                objectArray = new Object[]{"An unknown error occured decoding the packet", exception};
                                method2.invoke(object2, objectArray);
                            }
                            catch (Throwable throwable) {
                                bl = false;
                            }
                            if (!bl) {
                                System.out.println(new Date() + " - Exception: " + exception.getMessage());
                            }
                            SnmpPortal.this.m_handler.processException(exception);
                        }
                    }
                }
            }, Thread.currentThread().getName() + "-FastReceiver");
            thread.start();
            while (!SnmpPortal.this.m_isClosing) {
                LinkedList linkedList3;
                DatagramPacket datagramPacket;
                block26: {
                    ByteArrayOutputStream byteArrayOutputStream;
                    Method method;
                    Boolean bl;
                    Method method2;
                    Method method3;
                    Object object;
                    Object[] objectArray;
                    Method method4;
                    Class[] classArray;
                    Class<?> clazz;
                    boolean bl2;
                    datagramPacket = null;
                    try {
                        linkedList3 = linkedList;
                        synchronized (linkedList3) {
                            while (linkedList.isEmpty() && !SnmpPortal.this.m_isClosing) {
                                linkedList.wait(300L);
                            }
                            if (SnmpPortal.this.m_isClosing) {
                                continue;
                            }
                            datagramPacket = (DatagramPacket)linkedList.removeFirst();
                        }
                        SnmpPortal.this.handlePkt(datagramPacket);
                    }
                    catch (SnmpPduEncodingException snmpPduEncodingException) {
                        bl2 = true;
                        try {
                            clazz = Class.forName("org.opennms.core.utils.ThreadCategory");
                            classArray = new Class[]{class$java$lang$Class == null ? SnmpPortal.class$("java.lang.Class") : class$java$lang$Class};
                            method4 = clazz.getMethod("getInstance", classArray);
                            objectArray = new Object[]{this.getClass()};
                            object = method4.invoke(null, objectArray);
                            classArray = new Class[]{class$java$lang$Object == null ? SnmpPortal.class$("java.lang.Object") : class$java$lang$Object, class$java$lang$Throwable == null ? SnmpPortal.class$("java.lang.Throwable") : class$java$lang$Throwable};
                            method3 = clazz.getMethod("info", classArray);
                            objectArray = new Object[]{"An error occured decoding the protocol data unit", snmpPduEncodingException};
                            method3.invoke(object, objectArray);
                            classArray = new Class[]{};
                            method2 = clazz.getMethod("isDebugEnabled", classArray);
                            objectArray = new Object[]{};
                            bl = (Boolean)method2.invoke(object, objectArray);
                            if (bl.booleanValue()) {
                                classArray = new Class[]{class$java$lang$Object == null ? SnmpPortal.class$("java.lang.Object") : class$java$lang$Object};
                                method = clazz.getMethod("debug", classArray);
                                byteArrayOutputStream = new ByteArrayOutputStream();
                                SnmpUtil.dumpHex(new PrintStream(byteArrayOutputStream), datagramPacket.getData(), 0, datagramPacket.getLength());
                                objectArray = new Object[]{byteArrayOutputStream};
                                method.invoke(object, objectArray);
                            }
                        }
                        catch (Throwable throwable) {
                            bl2 = false;
                        }
                        if (!bl2) {
                            System.out.println(new Date() + " - SnmpPortal.Receiver.run: SnmpPduEncodingException: " + snmpPduEncodingException.getMessage());
                            SnmpUtil.dumpHex(System.out, datagramPacket.getData(), 0, datagramPacket.getLength());
                        }
                        SnmpPortal.this.m_handler.processBadDatagram(datagramPacket);
                    }
                    catch (AsnDecodingException asnDecodingException) {
                        bl2 = true;
                        try {
                            clazz = Class.forName("org.opennms.core.utils.ThreadCategory");
                            classArray = new Class[]{class$java$lang$Class == null ? SnmpPortal.class$("java.lang.Class") : class$java$lang$Class};
                            method4 = clazz.getMethod("getInstance", classArray);
                            objectArray = new Object[]{this.getClass()};
                            object = method4.invoke(null, objectArray);
                            classArray = new Class[]{class$java$lang$Object == null ? SnmpPortal.class$("java.lang.Object") : class$java$lang$Object, class$java$lang$Throwable == null ? SnmpPortal.class$("java.lang.Throwable") : class$java$lang$Throwable};
                            method3 = clazz.getMethod("info", classArray);
                            objectArray = new Object[]{"An ASN.1 error occured decoding the packet", asnDecodingException};
                            method3.invoke(object, objectArray);
                            classArray = new Class[]{};
                            method2 = clazz.getMethod("isDebugEnabled", classArray);
                            objectArray = new Object[]{};
                            bl = (Boolean)method2.invoke(object, objectArray);
                            if (bl.booleanValue()) {
                                classArray = new Class[]{class$java$lang$Object == null ? SnmpPortal.class$("java.lang.Object") : class$java$lang$Object};
                                method = clazz.getMethod("debug", classArray);
                                byteArrayOutputStream = new ByteArrayOutputStream();
                                SnmpUtil.dumpHex(new PrintStream(byteArrayOutputStream), datagramPacket.getData(), 0, datagramPacket.getLength());
                                objectArray = new Object[]{byteArrayOutputStream};
                                method.invoke(object, objectArray);
                            }
                        }
                        catch (Throwable throwable) {
                            bl2 = false;
                        }
                        if (!bl2) {
                            System.out.println(new Date() + " - SnmpPortal.Receiver.run: AsnEncodingException: " + asnDecodingException.getMessage());
                            SnmpUtil.dumpHex(System.out, datagramPacket.getData(), 0, datagramPacket.getLength());
                        }
                        SnmpPortal.this.m_handler.processBadDatagram(datagramPacket);
                    }
                    catch (Exception exception) {
                        if (SnmpPortal.this.m_isClosing) break block26;
                        bl2 = true;
                        try {
                            clazz = Class.forName("org.opennms.core.utils.ThreadCategory");
                            classArray = new Class[]{class$java$lang$Class == null ? SnmpPortal.class$("java.lang.Class") : class$java$lang$Class};
                            method4 = clazz.getMethod("getInstance", classArray);
                            objectArray = new Object[]{this.getClass()};
                            object = method4.invoke(null, objectArray);
                            classArray = new Class[]{class$java$lang$Object == null ? SnmpPortal.class$("java.lang.Object") : class$java$lang$Object, class$java$lang$Throwable == null ? SnmpPortal.class$("java.lang.Throwable") : class$java$lang$Throwable};
                            method3 = clazz.getMethod("info", classArray);
                            objectArray = new Object[]{"An unknown error occured decoding the packet", exception};
                            method3.invoke(object, objectArray);
                        }
                        catch (Throwable throwable) {
                            bl2 = false;
                        }
                        if (!bl2) {
                            System.out.println(new Date() + " - Exception: " + exception.getMessage());
                        }
                        SnmpPortal.this.m_handler.processException(exception);
                    }
                }
                if (datagramPacket == null) continue;
                linkedList3 = linkedList2;
                synchronized (linkedList3) {
                    if (linkedList2.size() < 20) {
                        linkedList2.addLast(datagramPacket.getData());
                    }
                }
            }
        }
    }
}

