/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.net.InetAddress;
import org.opennms.protocols.snmp.SnmpParameters;

public class SnmpPeer
implements Cloneable {
    private InetAddress m_peer;
    private int m_port;
    private int m_serverport = 0;
    private int m_retries;
    private int m_timeout;
    private SnmpParameters m_params;
    public static final int defaultRemotePort = 161;
    public static final int defaultRetries = 3;
    public static final int defaultTimeout = 8000;

    public SnmpPeer(InetAddress inetAddress) {
        this.m_peer = inetAddress;
        this.m_port = 161;
        this.m_timeout = 8000;
        this.m_retries = 3;
        this.m_params = new SnmpParameters();
    }

    public SnmpPeer(InetAddress inetAddress, int n) {
        this(inetAddress);
        this.m_port = n;
    }

    public SnmpPeer(SnmpPeer snmpPeer) {
        this.m_peer = snmpPeer.m_peer;
        this.m_port = snmpPeer.m_port;
        this.m_timeout = snmpPeer.m_timeout;
        this.m_retries = snmpPeer.m_retries;
        this.m_params = (SnmpParameters)snmpPeer.m_params.clone();
    }

    public InetAddress getPeer() {
        return this.m_peer;
    }

    public void setPeer(InetAddress inetAddress) {
        this.m_peer = inetAddress;
    }

    public void setPeer(InetAddress inetAddress, int n) {
        this.m_peer = inetAddress;
        this.m_port = n;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int n) {
        this.m_port = n;
    }

    public int getServerPort() {
        return this.m_serverport;
    }

    public void setServerPort(int n) {
        this.m_serverport = n;
    }

    public int getRetries() {
        return this.m_retries;
    }

    public void setRetries(int n) {
        this.m_retries = n;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int n) {
        this.m_timeout = n;
    }

    public SnmpParameters getParameters() {
        return this.m_params;
    }

    public void setParameters(SnmpParameters snmpParameters) {
        this.m_params = snmpParameters;
    }

    public Object clone() {
        return new SnmpPeer(this);
    }
}

