/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.Serializable;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpObjectId
implements SnmpSyntax,
Cloneable,
Serializable {
    static final long serialVersionUID = 2633631219460364065L;
    private int[] m_data;
    public static final byte ASNTYPE = 6;

    private static int[] convert(String string) {
        int n = 0;
        char[] cArray = string.toCharArray();
        if (cArray.length == 0) {
            int[] nArray = new int[2];
            nArray[1] = 0;
            nArray[0] = 0;
            return nArray;
        }
        if (cArray[0] != '.') {
            ++n;
        }
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2++] != '.') continue;
            ++n;
        }
        if (n == 0) {
            int[] nArray = new int[2];
            nArray[1] = 0;
            nArray[0] = 0;
            return nArray;
        }
        int[] nArray = new int[n];
        int n3 = 0;
        int n4 = 0;
        if (cArray[0] == '.') {
            ++n4;
        }
        int n5 = 0;
        while (n4 < cArray.length) {
            if (cArray[n4] == '.') {
                nArray[n3++] = n5;
                n5 = 0;
            } else {
                n5 *= 10;
                switch (cArray[n4]) {
                    case '1': {
                        ++n5;
                        break;
                    }
                    case '2': {
                        n5 += 2;
                        break;
                    }
                    case '3': {
                        n5 += 3;
                        break;
                    }
                    case '4': {
                        n5 += 4;
                        break;
                    }
                    case '5': {
                        n5 += 5;
                        break;
                    }
                    case '6': {
                        n5 += 6;
                        break;
                    }
                    case '7': {
                        n5 += 7;
                        break;
                    }
                    case '8': {
                        n5 += 8;
                        break;
                    }
                    case '9': {
                        n5 += 9;
                    }
                }
            }
            ++n4;
        }
        nArray[n3++] = n5;
        return nArray;
    }

    public SnmpObjectId() {
        this.m_data = new int[2];
        this.m_data[1] = 0;
        this.m_data[0] = 0;
    }

    public SnmpObjectId(int[] nArray) {
        this();
        if (nArray != null) {
            this.m_data = new int[nArray.length];
            System.arraycopy(nArray, 0, this.m_data, 0, nArray.length);
        }
    }

    public SnmpObjectId(SnmpObjectId snmpObjectId) {
        this(snmpObjectId.m_data);
    }

    public SnmpObjectId(String string) {
        this.m_data = SnmpObjectId.convert(string);
        if (this.m_data == null) {
            this.m_data = new int[2];
            this.m_data[1] = 0;
            this.m_data[0] = 0;
        }
    }

    public int getLength() {
        return this.m_data.length;
    }

    public int[] getIdentifiers() {
        return this.m_data;
    }

    public void setIdentifiers(int[] nArray) {
        if (nArray != null) {
            this.m_data = new int[nArray.length];
            System.arraycopy(nArray, 0, this.m_data, 0, nArray.length);
        } else {
            this.m_data = new int[2];
            this.m_data[1] = 0;
            this.m_data[0] = 0;
        }
    }

    public void setIdentifiers(String string) {
        this.m_data = null;
        if (string != null) {
            this.m_data = SnmpObjectId.convert(string);
        }
        if (this.m_data == null) {
            this.m_data = new int[2];
            this.m_data[1] = 0;
            this.m_data[0] = 0;
        }
    }

    public void append(int[] nArray) {
        if (nArray != null && nArray.length != 0) {
            int[] nArray2 = new int[this.m_data.length + nArray.length];
            System.arraycopy(this.m_data, 0, nArray2, 0, this.m_data.length);
            System.arraycopy(nArray, 0, nArray2, this.m_data.length, nArray.length);
            this.m_data = nArray2;
        }
    }

    public void append(String string) {
        int[] nArray = SnmpObjectId.convert(string);
        this.append(nArray);
    }

    public void append(SnmpObjectId snmpObjectId) {
        this.append(snmpObjectId.m_data);
    }

    public void prepend(int[] nArray) {
        if (nArray != null && nArray.length != 0) {
            int[] nArray2 = new int[this.m_data.length + nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            System.arraycopy(this.m_data, 0, nArray2, nArray.length, this.m_data.length);
            this.m_data = nArray2;
        }
    }

    public void prepend(String string) {
        int[] nArray = SnmpObjectId.convert(string);
        this.prepend(nArray);
    }

    public void prepend(SnmpObjectId snmpObjectId) {
        this.prepend(snmpObjectId.m_data);
    }

    public int compare(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < this.m_data.length || n2 < nArray.length) {
            int n4 = 0;
            if (n < this.m_data.length) {
                n4 = this.m_data[n++] + 1;
            }
            int n5 = 0;
            if (n2 < nArray.length) {
                n5 = nArray[n2++] + 1;
            }
            if ((n3 = n4 - n5) == 0) continue;
            break;
        }
        return n3;
    }

    public int compare(int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n2 < this.m_data.length || n3 < nArray.length) && --n >= 0) {
            int n5 = 0;
            if (n2 < this.m_data.length) {
                n5 = this.m_data[n2++] + 1;
            }
            int n6 = 0;
            if (n3 < nArray.length) {
                n6 = nArray[n3++] + 1;
            }
            if ((n4 = n5 - n6) == 0) continue;
            break;
        }
        return n4;
    }

    public int compare(SnmpObjectId snmpObjectId) {
        return this.compare(snmpObjectId.m_data);
    }

    public boolean isRootOf(SnmpObjectId snmpObjectId) {
        return this.compare(snmpObjectId.m_data, this.m_data.length) == 0;
    }

    public boolean equals(Object object) {
        if (object instanceof SnmpObjectId) {
            return this.compare(((SnmpObjectId)object).m_data) == 0;
        }
        if (object instanceof String) {
            return this.compare(SnmpObjectId.convert((String)object)) == 0;
        }
        if (object instanceof int[]) {
            return this.compare((int[])object) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(this.m_data.length * 3);
        for (int i = 0; i < this.m_data.length; ++i) {
            stringBuffer.append('.');
            if (this.m_data[i] >= 0) {
                stringBuffer.append(this.m_data[i]);
                continue;
            }
            long l = (long)this.m_data[i] & 0xFFFFFFFFL;
            stringBuffer.append(l);
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.m_data.length; ++i) {
            n = n * 31 + this.m_data[i];
        }
        return n;
    }

    public byte typeId() {
        return 6;
    }

    public int encodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnEncodingException {
        return asnEncoder.buildObjectId(byArray, n, this.typeId(), this.m_data);
    }

    public int decodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnDecodingException {
        Object[] objectArray = asnEncoder.parseObjectId(byArray, n);
        if (((Byte)objectArray[1]).byteValue() != this.typeId()) {
            throw new AsnDecodingException("Invalid ASN.1 type");
        }
        this.m_data = (int[])objectArray[2];
        return (Integer)objectArray[0];
    }

    public SnmpSyntax duplicate() {
        return new SnmpObjectId(this);
    }

    public Object clone() {
        return new SnmpObjectId(this);
    }
}

