/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.Serializable;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpInt32
implements SnmpSyntax,
Cloneable,
Serializable {
    private int m_value;
    static final long serialVersionUID = -3472172482048507843L;
    public static final byte ASNTYPE = 2;

    public SnmpInt32() {
        this.m_value = 0;
    }

    public SnmpInt32(int n) {
        this.m_value = n;
    }

    public SnmpInt32(Integer n) {
        this.m_value = n;
    }

    public SnmpInt32(SnmpInt32 snmpInt32) {
        this.m_value = snmpInt32.m_value;
    }

    public SnmpInt32(String string) {
        if (string == null) {
            throw new NullPointerException("The constructor argument may not be null");
        }
        this.m_value = Integer.parseInt(string);
    }

    public int getValue() {
        return this.m_value;
    }

    public void setValue(int n) {
        this.m_value = n;
    }

    public void setValue(Integer n) {
        this.m_value = n;
    }

    public byte typeId() {
        return 2;
    }

    public int encodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnEncodingException {
        return asnEncoder.buildInteger32(byArray, n, this.typeId(), this.m_value);
    }

    public int decodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnDecodingException {
        Object[] objectArray = asnEncoder.parseInteger32(byArray, n);
        if (((Byte)objectArray[1]).byteValue() != this.typeId()) {
            throw new AsnDecodingException("Invalid ASN.1 type");
        }
        this.m_value = (Integer)objectArray[2];
        return (Integer)objectArray[0];
    }

    public SnmpSyntax duplicate() {
        return new SnmpInt32(this);
    }

    public Object clone() {
        return new SnmpInt32(this);
    }

    public String toString() {
        return Integer.toString(this.getValue());
    }
}

