/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidParameterException;
import org.opennms.protocols.snmp.SnmpBadConversionException;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;

public class SnmpIPAddress
extends SnmpOctetString {
    static final long serialVersionUID = -4375760318106654741L;
    public static final byte ASNTYPE = 64;

    public SnmpIPAddress() {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        super.assumeString(byArray);
    }

    public SnmpIPAddress(byte[] byArray) {
        super(byArray);
        if (byArray.length < 4) {
            throw new InvalidParameterException("Buffer underflow error converting IP address");
        }
        if (byArray.length > 4) {
            throw new InvalidParameterException("Buffer overflow error converting IP address");
        }
    }

    public SnmpIPAddress(SnmpIPAddress snmpIPAddress) {
        super(snmpIPAddress);
    }

    public SnmpIPAddress(SnmpOctetString snmpOctetString) {
        super(snmpOctetString);
        if (this.getLength() < 4) {
            throw new InvalidParameterException("Buffer underflow error converting IP address");
        }
        if (this.getLength() > 4) {
            throw new InvalidParameterException("Buffer overflow error converting IP address");
        }
    }

    public SnmpIPAddress(InetAddress inetAddress) {
        this(inetAddress.getAddress());
    }

    public SnmpIPAddress(String string) throws SnmpBadConversionException {
        try {
            byte[] byArray = InetAddress.getByName(string).getAddress();
            super.assumeString(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new SnmpBadConversionException(unknownHostException);
        }
    }

    public byte typeId() {
        return 64;
    }

    public SnmpSyntax duplicate() {
        return new SnmpIPAddress(this);
    }

    public Object clone() {
        return new SnmpIPAddress(this);
    }

    public void setString(byte[] byArray) {
        if (byArray == null || byArray.length < 4) {
            throw new InvalidParameterException("Buffer underflow error converting IP address");
        }
        if (byArray.length > 4) {
            throw new InvalidParameterException("Buffer overflow error converting IP address");
        }
        super.setString(byArray);
    }

    public void setString(String string) {
        byte[] byArray;
        byte[] byArray2 = byArray = string == null ? null : string.getBytes();
        if (byArray == null || byArray.length < 4) {
            throw new InvalidParameterException("Buffer underflow error converting IP address");
        }
        if (byArray.length > 4) {
            throw new InvalidParameterException("Buffer overflow error converting IP address");
        }
        super.assumeString(byArray);
    }

    public int decodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnDecodingException {
        Object[] objectArray = asnEncoder.parseString(byArray, n);
        if (((Byte)objectArray[1]).byteValue() != this.typeId()) {
            throw new AsnDecodingException("Invalid ASN.1 type");
        }
        byte[] byArray2 = (byte[])objectArray[2];
        if (byArray2.length < 4) {
            throw new AsnDecodingException("Buffer Underflow Exception, length = " + byArray2.length);
        }
        if (byArray2.length > 4) {
            throw new AsnDecodingException("Buffer Overflow Exception, length = " + byArray2.length);
        }
        super.assumeString(byArray2);
        return (Integer)objectArray[0];
    }

    public InetAddress convertToIpAddress() throws SnmpBadConversionException {
        byte[] byArray = this.getString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(byArray[0] < 0 ? 256 + byArray[0] : byArray[0]).append('.');
        stringBuffer.append(byArray[1] < 0 ? 256 + byArray[1] : byArray[1]).append('.');
        stringBuffer.append(byArray[2] < 0 ? 256 + byArray[2] : byArray[2]).append('.');
        stringBuffer.append(byArray[3] < 0 ? 256 + byArray[3] : byArray[3]);
        try {
            return InetAddress.getByName(stringBuffer.toString());
        }
        catch (UnknownHostException unknownHostException) {
            throw new SnmpBadConversionException("Invalid IP Address?", unknownHostException);
        }
    }

    public String toString() {
        byte[] byArray = this.getString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(byArray[0] < 0 ? 256 + byArray[0] : byArray[0]).append('.');
        stringBuffer.append(byArray[1] < 0 ? 256 + byArray[1] : byArray[1]).append('.');
        stringBuffer.append(byArray[2] < 0 ? 256 + byArray[2] : byArray[2]).append('.');
        stringBuffer.append(byArray[3] < 0 ? 256 + byArray[3] : byArray[3]);
        return stringBuffer.toString();
    }
}

