/*
 * Decompiled with CFR 0.152.
 */
package online.yangcloud.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class JwtUtil {
    private static final String token_sign = "9cc09665-bdb4-4ba8-a282-a53760e44401";
    private static final long expire_time_change = 3600000L;
    private static final String token_illegal = "\u975e\u6cd5Token\u503c";
    private static final boolean yes = true;
    private static final boolean no = false;

    public static String createToken(String username, String password) {
        Algorithm al = Algorithm.HMAC256((String)token_sign);
        Instant instant = LocalDateTime.now().plusHours(3600000L).atZone(ZoneId.systemDefault()).toInstant();
        Date expire = Date.from(instant);
        return JWT.create().withSubject(username).withClaim(username, password).withExpiresAt(expire).sign(al);
    }

    public static Claims parseToken(String token) {
        return (Claims)Jwts.parser().setSigningKey(token_sign).parseClaimsJws(token).getBody();
    }

    public static Claim getClaimFromToken(String token) {
        Algorithm algorithm = Algorithm.HMAC256((String)token_sign);
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
        DecodedJWT jwt = verifier.verify(token);
        return jwt.getClaim(jwt.getSubject());
    }

    public static Boolean isVerify(String token, String password) {
        Algorithm algorithm = Algorithm.HMAC256((String)token_sign);
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
        DecodedJWT jwt = verifier.verify(token);
        Claim claim = jwt.getClaim(jwt.getSubject());
        String pwdInToken = claim.asString();
        return pwdInToken.equals(password);
    }

    public static String getUsernameFromToken(String token) {
        try {
            return JWT.require((Algorithm)Algorithm.HMAC256((String)token_sign)).build().verify(token).getSubject();
        }
        catch (NullPointerException e) {
            return token_illegal;
        }
    }

    public static boolean verifyTokenIsLegal(String token) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)token_sign);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            DecodedJWT decodedJWT = verifier.verify(token);
        }
        catch (JWTVerificationException e) {
            return false;
        }
        return true;
    }

    public static boolean isExpired(String token) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)token_sign);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            DecodedJWT jwt = verifier.verify(token);
            if (jwt.getExpiresAt().before(new Date())) {
                return false;
            }
        }
        catch (JWTVerificationException e) {
            return false;
        }
        return true;
    }
}

