/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial.impl;

import java.io.Serializable;
import terraml.commons.Doubles;
import terraml.commons.math.Angle;
import terraml.geospatial.Longitude;

public final class ImmutableLongitude
implements Longitude,
Serializable {
    public static double MIN_LONGITUDE = Double.valueOf("-180.0000");
    public static double MAX_LONGITUDE = Double.valueOf("180.0000");
    public final double lon;

    public ImmutableLongitude(double lon) {
        if (!ImmutableLongitude._isValid(lon)) {
            throw new IllegalArgumentException("Given" + lon + " angle must be in range. Hint: {@MIN_LONGITUDE, @MAX_LONGITUDE}");
        }
        this.lon = lon;
    }

    public ImmutableLongitude(Angle angle) {
        this(angle.degree);
    }

    public ImmutableLongitude(Longitude longitude) {
        this(longitude.toDegree());
    }

    private static boolean _isValid(double degree) {
        return Doubles.isSmaller((double)degree, (double)MAX_LONGITUDE) && Doubles.isGreater((double)degree, (double)MIN_LONGITUDE);
    }

    @Override
    public Longitude translate(Longitude longitude) {
        return new ImmutableLongitude(this.lon + longitude.toDegree());
    }

    @Override
    public Longitude translate(double degree) {
        return new ImmutableLongitude(this.lon + degree);
    }

    @Override
    public Longitude scale(Longitude longitude) {
        return new ImmutableLongitude(this.lon * longitude.toDegree());
    }

    @Override
    public Longitude scale(double degree) {
        return new ImmutableLongitude(this.lon * degree);
    }

    @Override
    public double sin() {
        return Math.sin(this.toRadian());
    }

    @Override
    public double cos() {
        return Math.cos(this.toRadian());
    }

    @Override
    public double tan() {
        return Math.tan(this.toRadian());
    }

    @Override
    public double acos() {
        return Math.acos(this.toRadian());
    }

    @Override
    public double asin() {
        return Math.asin(this.toRadian());
    }

    @Override
    public double atan() {
        return Math.atan(this.toRadian());
    }

    @Override
    public Angle toAngle() {
        return Angle.fromDegree((double)this.lon);
    }

    @Override
    public double toDegree() {
        return this.lon;
    }

    @Override
    public double toRadian() {
        return Math.toRadians(this.lon);
    }

    @Override
    public int compareTo(Longitude longitude) {
        return Double.compare(this.lon, longitude.toDegree());
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (int)(Double.doubleToLongBits(this.lon) ^ Double.doubleToLongBits(this.lon) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableLongitude other = (ImmutableLongitude)obj;
        return Double.doubleToLongBits(this.lon) == Double.doubleToLongBits(other.lon);
    }
}

