/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial.impl;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import terraml.commons.math.Angle;
import terraml.commons.tuple.LatlonEntry;
import terraml.commons.unit.DirectionUnit;
import terraml.commons.unit.DistanceUnit;
import terraml.geospatial.Azimuths;
import terraml.geospatial.Distance;
import terraml.geospatial.DistanceCalculator;
import terraml.geospatial.DistanceNode;
import terraml.geospatial.GeoShapeUnit;
import terraml.geospatial.GeoUtils;
import terraml.geospatial.GeoVector;
import terraml.geospatial.Latitude;
import terraml.geospatial.Latlon;
import terraml.geospatial.Longitude;
import terraml.geospatial.Offset;
import terraml.geospatial.impl.ImmutableLatitude;
import terraml.geospatial.impl.ImmutableLongitude;

public final class ImmutableLatlon
implements Latlon,
Serializable {
    public final String id;
    public final Latitude latitude;
    public final Longitude longitude;

    public ImmutableLatlon(String id, Latitude latitude, Longitude longitude) {
        this.id = id;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public ImmutableLatlon(Latitude lat, Longitude lon) {
        this.latitude = lat;
        this.longitude = lon;
        this.id = UUID.randomUUID().toString();
    }

    public ImmutableLatlon(double lat, double lon) {
        this(new ImmutableLatitude(lat), new ImmutableLongitude(lon));
    }

    public ImmutableLatlon(String id, double lat, double lon) {
        this(id, new ImmutableLatitude(lat), new ImmutableLongitude(lon));
    }

    public ImmutableLatlon(Latlon latlon) {
        this(latlon.getLatitude(), latlon.getLongitude());
    }

    public ImmutableLatlon(String id, Latlon latlon) {
        this(id, latlon.getLatitude(), latlon.getLongitude());
    }

    public ImmutableLatlon(LatlonEntry entry) {
        this(entry.lat(), entry.lon());
    }

    public ImmutableLatlon(String id, LatlonEntry entry) {
        this(entry.lat(), entry.lon());
    }

    @Override
    public DistanceNode distanceTo(Latlon latlon, DistanceCalculator calculator) {
        DistanceCalculator calc = calculator == null ? new Distance.Vincenty() : calculator;
        return calc.distanceOf(this, latlon);
    }

    @Override
    public DirectionUnit directionTo(Latlon latlon) {
        return GeoUtils.direction(this, latlon);
    }

    @Override
    public Angle bearingTo(Latlon latlon) {
        return GeoUtils.bearingCCW(this, latlon);
    }

    @Override
    public Angle azimuthTo(Latlon latlon) {
        return Azimuths.northBasedAzimuth(this, latlon);
    }

    @Override
    public Angle finalAzimuthTo(Latlon latlon) {
        return Azimuths.northBasedFinalAzimuth(this, latlon);
    }

    @Override
    public Latlon offset(DistanceNode distanceNode, Angle northBasedAzimuth) {
        double distance = distanceNode.unit.equals((Object)DistanceUnit.METER) ? distanceNode.distance : DistanceUnit.KILOMETER.toMeter(distanceNode.distance);
        return Offset.destinationOf(this, distance, northBasedAzimuth);
    }

    @Override
    public GeoVector toVector() {
        return GeoVector.fromLatlon(this);
    }

    @Override
    public Latitude getLatitude() {
        return new ImmutableLatitude(this.latitude);
    }

    @Override
    public Longitude getLongitude() {
        return new ImmutableLongitude(this.longitude);
    }

    @Override
    public double[] toArray() {
        return new double[]{this.latitude.toDegree(), this.longitude.toDegree()};
    }

    @Override
    public double[] toArrayAsRadian() {
        return new double[]{this.latitude.toRadian(), this.longitude.toRadian()};
    }

    @Override
    public Latlon[] getBounds() {
        return new Latlon[]{new ImmutableLatlon(this.latitude.toDegree(), this.latitude.toDegree()), new ImmutableLatlon(this.longitude.toDegree(), this.longitude.toDegree())};
    }

    @Override
    public double lat() {
        return this.getLatitude().toDegree();
    }

    @Override
    public double lon() {
        return this.getLongitude().toDegree();
    }

    @Override
    public GeoShapeUnit getGeoShapeUnit() {
        return GeoShapeUnit.Latlon;
    }

    @Override
    public ImmutableLatlon clone() {
        return new ImmutableLatlon(this.latitude, this.longitude);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.latitude);
        hash = 67 * hash + Objects.hashCode(this.longitude);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableLatlon other = (ImmutableLatlon)obj;
        if (!Objects.equals(this.latitude, other.latitude)) {
            return false;
        }
        return Objects.equals(this.longitude, other.longitude);
    }
}

