/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial.impl;

import java.io.Serializable;
import terraml.commons.Doubles;
import terraml.commons.math.Angle;
import terraml.geospatial.Latitude;

public final class ImmutableLatitude
implements Latitude,
Serializable {
    public final double lat;

    public ImmutableLatitude(double lat) {
        if (!ImmutableLatitude._isValid(lat)) {
            throw new IllegalArgumentException("Given" + lat + " angle must be in range. Hint: {@MIN_LATITUDE, @MAX_LATITUDE}");
        }
        this.lat = lat;
    }

    public ImmutableLatitude(Angle _angle) {
        this(_angle.degree);
    }

    public ImmutableLatitude(Latitude latitude) {
        this(latitude.toDegree());
    }

    private static boolean _isValid(double _ang) {
        return Doubles.isGreater((double)_ang, (double)MIN_LATITUDE) && Doubles.isSmaller((double)_ang, (double)MAX_LATITUDE);
    }

    @Override
    public Latitude translate(Latitude latitude) {
        return new ImmutableLatitude(this.lat + latitude.toDegree());
    }

    @Override
    public Latitude translate(double degree) {
        return new ImmutableLatitude(this.lat + degree);
    }

    @Override
    public Latitude scale(Latitude latitude) {
        return new ImmutableLatitude(this.lat * latitude.toDegree());
    }

    @Override
    public Latitude scale(double degree) {
        return new ImmutableLatitude(this.lat * degree);
    }

    @Override
    public double sin() {
        return Math.sin(this.toRadian());
    }

    @Override
    public double cos() {
        return Math.cos(this.toRadian());
    }

    @Override
    public double tan() {
        return Math.tan(this.toRadian());
    }

    @Override
    public double acos() {
        return Math.acos(this.toRadian());
    }

    @Override
    public double asin() {
        return Math.asin(this.toRadian());
    }

    @Override
    public double atan() {
        return Math.atan(this.toRadian());
    }

    @Override
    public Angle toAngle() {
        return Angle.fromDegree((double)this.lat);
    }

    @Override
    public double toDegree() {
        return this.lat;
    }

    @Override
    public double toRadian() {
        return Math.toRadians(this.lat);
    }

    @Override
    public int compareTo(Latitude latitude) {
        return Double.compare(this.lat, latitude.toDegree());
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (int)(Double.doubleToLongBits(this.lat) ^ Double.doubleToLongBits(this.lat) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableLatitude other = (ImmutableLatitude)obj;
        return Double.doubleToLongBits(this.lat) == Double.doubleToLongBits(other.lat);
    }
}

