/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial.impl;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import terraml.commons.math.Interval;
import terraml.geospatial.Crosstracks;
import terraml.geospatial.Distance;
import terraml.geospatial.DistanceCalculator;
import terraml.geospatial.DistanceNode;
import terraml.geospatial.GeoSegment;
import terraml.geospatial.GeoShapeUnit;
import terraml.geospatial.Latitude;
import terraml.geospatial.Latlon;
import terraml.geospatial.LatlonIntersection;
import terraml.geospatial.Locate;
import terraml.geospatial.Longitude;
import terraml.geospatial.Offset;
import terraml.geospatial.SegmentIntersection;
import terraml.geospatial.impl.ImmutableLatlon;

public final class ImmutableGeoSegment
implements GeoSegment,
Serializable {
    private static final long serialVersionUID = 181265321L;
    public final String id;
    public final Latlon source;
    public final Latlon target;

    public ImmutableGeoSegment(String id, Latlon source, Latlon target) {
        this.id = id;
        this.source = source;
        this.target = target;
    }

    public ImmutableGeoSegment(Latlon source, Latlon target) {
        this.source = source;
        this.target = target;
        this.id = UUID.randomUUID().toString();
    }

    public ImmutableGeoSegment(Latitude lat0, Longitude lon0, Latitude lat1, Longitude lon1) {
        this(new ImmutableLatlon(lat0, lon0), new ImmutableLatlon(lat1, lon1));
    }

    public ImmutableGeoSegment(String id, Latitude lat0, Longitude lon0, Latitude lat1, Longitude lon1) {
        this(new ImmutableLatlon(lat0, lon0), new ImmutableLatlon(lat1, lon1));
    }

    public ImmutableGeoSegment(double lat0, double lon0, double lat1, double lon1) {
        this(new ImmutableLatlon(lat0, lon0), new ImmutableLatlon(lat1, lon1));
    }

    public ImmutableGeoSegment(String id, double lat0, double lon0, double lat1, double lon1) {
        this(new ImmutableLatlon(lat0, lon0), new ImmutableLatlon(lat1, lon1));
    }

    public ImmutableGeoSegment(GeoSegment geoSegment) {
        this(geoSegment.getSource(), geoSegment.getTarget());
    }

    @Override
    public Latlon intersection(GeoSegment segment, DistanceNode tolerance) {
        ImmutableLatlon crd;
        Latlon entry = SegmentIntersection.intersectionOf(this, segment);
        if (entry != null && this.isOn(crd = new ImmutableLatlon(entry.lat(), entry.lon()), tolerance) && segment.isOn(crd, tolerance)) {
            return crd;
        }
        return null;
    }

    @Override
    public boolean intersects(GeoSegment segment) {
        return SegmentIntersection.intersects(this, segment);
    }

    @Override
    public boolean intersects(GeoSegment segment, DistanceNode tolerance) {
        return SegmentIntersection.intersects(this, segment, tolerance);
    }

    @Override
    public GeoSegment offset(DistanceNode distanceNode) {
        Latlon src = Offset.offsetSource(this.source, this.target, distanceNode.asMeter());
        return new ImmutableGeoSegment(src, this.target);
    }

    @Override
    public DistanceNode vinCrosstrack(Latlon latlon) {
        return Crosstracks.crossTrackVinDistance(latlon, this.source, this.target);
    }

    @Override
    public DistanceNode havCrosstrack(Latlon latlon) {
        return Crosstracks.crossTrackHavDistance(latlon, this.source, this.target);
    }

    @Override
    public boolean isOn(Latlon latlon, DistanceNode tolerance, DistanceCalculator calculator) {
        Latlon entry = LatlonIntersection.closest(latlon, this, calculator);
        double distance = calculator.distanceOf(latlon, entry).asMeter();
        return distance <= tolerance.asMeter();
    }

    @Override
    public boolean isOn(Latlon latlon, DistanceNode tolerance) {
        return LatlonIntersection.withinAccurate(latlon, this, tolerance.asMeter());
    }

    @Override
    public DistanceNode distance(DistanceCalculator calculator) {
        DistanceCalculator calc = calculator == null ? new Distance.Vincenty() : calculator;
        return calc.distanceOf(this.source, this.target);
    }

    @Override
    public Latlon closestOf(Latlon latlon, DistanceCalculator calculator) {
        DistanceCalculator calc = calculator == null ? new Distance.Vincenty() : calculator;
        return LatlonIntersection.closest(latlon, this, calc);
    }

    @Override
    public boolean inZone(Latlon latlon) {
        return LatlonIntersection.inSegmentBounds(latlon, this);
    }

    @Override
    public Latlon halfway() {
        return new ImmutableLatlon(Locate.halfWay(this.source, this.target));
    }

    @Override
    public Latlon at(double percentage) {
        return new ImmutableLatlon(Locate.locateWith(this.source, this.target, percentage));
    }

    @Override
    public Latlon getSource() {
        return new ImmutableLatlon(this.source);
    }

    @Override
    public Latlon getTarget() {
        return new ImmutableLatlon(this.target);
    }

    @Override
    public Latlon[] toArray() {
        return new Latlon[]{new ImmutableLatlon(this.source), new ImmutableLatlon(this.target)};
    }

    @Override
    public double[] toDoubleArray() {
        return new double[]{this.source.getLatitude().toDegree(), this.source.getLongitude().toDegree(), this.target.getLatitude().toDegree(), this.target.getLongitude().toDegree()};
    }

    @Override
    public ImmutableGeoSegment clone() {
        return new ImmutableGeoSegment(this.source, this.target);
    }

    @Override
    public GeoShapeUnit getGeoShapeUnit() {
        return GeoShapeUnit.GeoSegment;
    }

    @Override
    public Latlon[] getBounds() {
        Interval intValX = new Interval(this.source.getLatitude().toDegree(), this.target.getLatitude().toDegree());
        Interval intValY = new Interval(this.source.getLongitude().toDegree(), this.target.getLongitude().toDegree());
        return new Latlon[]{new ImmutableLatlon(intValX.left, intValY.left), new ImmutableLatlon(intValX.right, intValY.right)};
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Objects.hashCode(this.source);
        hash = 23 * hash + Objects.hashCode(this.target);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableGeoSegment other = (ImmutableGeoSegment)obj;
        if (!Objects.equals(this.source, other.source)) {
            return false;
        }
        return Objects.equals(this.target, other.target);
    }
}

