/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import terraml.commons.Doubles;
import terraml.commons.tuple.Pair;
import terraml.commons.unit.DistanceUnit;
import terraml.geospatial.Distance;
import terraml.geospatial.DistanceCalculator;
import terraml.geospatial.DistanceNode;
import terraml.geospatial.GeoBoundry;
import terraml.geospatial.GeoPolyline;
import terraml.geospatial.GeoSegment;
import terraml.geospatial.GeoShapeUnit;
import terraml.geospatial.Latlon;
import terraml.geospatial.Locate;
import terraml.geospatial.impl.ImmutableGeoSegment;
import terraml.geospatial.impl.ImmutableLatlon;

public class ImmutableGeoPolyline
implements GeoPolyline,
Serializable {
    public final String id;
    private final List<Latlon> list;

    public ImmutableGeoPolyline(String id, List<Latlon> list) {
        this.id = id;
        this.list = list;
    }

    public ImmutableGeoPolyline(List<Latlon> list) {
        this.list = list;
        this.id = UUID.randomUUID().toString();
    }

    @Override
    public double crossTrack(Latlon coordinate, boolean isMin, boolean isVincenty) {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Polyline is empty.");
        }
        Collection<GeoSegment> segments = this.toSegments();
        double currentMin = Double.MAX_VALUE;
        double currentMax = Double.MIN_VALUE;
        for (GeoSegment segment : segments) {
            DistanceNode track;
            DistanceNode distanceNode = track = isVincenty ? segment.vinCrosstrack(coordinate) : segment.havCrosstrack(coordinate);
            if (isMin) {
                if (!Doubles.isSmaller((double)track.asMeter(), (double)currentMin)) continue;
                currentMin = track.asMeter();
                continue;
            }
            if (!Doubles.isGreater((double)track.asMeter(), (double)currentMax)) continue;
            currentMax = track.asMeter();
        }
        return isMin ? currentMin : currentMax;
    }

    @Override
    public boolean intersects(GeoPolyline polyline) {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Polyline is empty.");
        }
        Collection<GeoSegment> primary = this.toSegments();
        Collection<GeoSegment> secondary = polyline.toSegments();
        if (secondary.isEmpty()) {
            return false;
        }
        return primary.stream().anyMatch(current -> secondary.stream().anyMatch(next -> current.intersects((GeoSegment)next)));
    }

    @Override
    public Collection<Latlon> intersection(GeoPolyline polyline, DistanceNode tolerance) {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Polyline is empty.");
        }
        LinkedList<Latlon> tmpList = new LinkedList<Latlon>();
        Collection<GeoSegment> primary = this.toSegments();
        Collection<GeoSegment> secondary = polyline.toSegments();
        if (secondary.isEmpty()) {
            return new ArrayList<Latlon>();
        }
        primary.forEach(current -> secondary.stream().map(next -> current.intersection((GeoSegment)next, tolerance)).filter(inter -> inter != null).forEachOrdered(inter -> tmpList.add(new ImmutableLatlon((Latlon)inter))));
        return tmpList;
    }

    @Override
    public boolean isOn(Latlon point, DistanceNode tolerance) {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Polyline is empty.");
        }
        Collection<GeoSegment> segments = this.toSegments();
        return segments.stream().anyMatch(segment -> segment.isOn(point, tolerance));
    }

    @Override
    public boolean isOn(Latlon point, DistanceCalculator calculator, DistanceNode tolerance) {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Polyline is empty.");
        }
        Collection<GeoSegment> segments = this.toSegments();
        return segments.stream().anyMatch(segment -> segment.isOn(point, tolerance, calculator));
    }

    @Override
    public Pair<Latlon, DistanceNode> closestOf(Latlon coord, DistanceCalculator calculator) {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Polyline is empty.");
        }
        Collection<GeoSegment> segments = this.toSegments();
        DistanceNode distance = new DistanceNode(DistanceUnit.METER, Double.MAX_VALUE);
        Latlon closest = null;
        for (GeoSegment segment : segments) {
            Latlon currentClosest = segment.closestOf(coord, calculator);
            if (terraml.commons.Objects.isNull(closest)) {
                closest = currentClosest;
                distance = calculator.distanceOf(coord, closest);
                continue;
            }
            DistanceNode trackDistance = calculator.distanceOf(coord, currentClosest);
            if (!Doubles.isSmaller((double)trackDistance.asMeter(), (double)distance.asMeter())) continue;
            closest = currentClosest;
            distance = trackDistance;
        }
        return new Pair(closest, (Object)distance);
    }

    @Override
    public Latlon find(DistanceNode node) {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Polyline cannot be offset. It is empty");
        }
        Collection<GeoSegment> segments = this.toSegments();
        Distance.Vincenty calculator = new Distance.Vincenty();
        DistanceNode tracker = node;
        for (GeoSegment segment : segments) {
            DistanceNode distance = segment.distance(calculator);
            if (tracker.asMeter() < distance.asMeter()) {
                return new ImmutableLatlon(segment.offset(tracker).getSource());
            }
            double val = tracker.asMeter() - distance.asMeter();
            tracker = new DistanceNode(DistanceUnit.METER, val);
        }
        return null;
    }

    @Override
    public Latlon centroid() {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Empty Polyline.");
        }
        ArrayList<Latlon> wildcard = new ArrayList<Latlon>();
        for (Latlon coordinate : this.list) {
            wildcard.add(coordinate);
        }
        return new ImmutableLatlon(Locate.centerOf(wildcard));
    }

    @Override
    public Collection<GeoSegment> toSegments() {
        LinkedList<GeoSegment> segments = new LinkedList<GeoSegment>();
        int len = this.list.size();
        for (int i = 0; i < len; ++i) {
            int next = i + 1;
            if (next >= len) continue;
            Latlon currentSrc = this.list.get(i);
            Latlon currentTar = this.list.get(i + 1);
            segments.add(new ImmutableGeoSegment(currentSrc, currentTar));
        }
        return segments;
    }

    @Override
    public Latlon[] toArray() {
        if (terraml.commons.Objects.isNull(this.list)) {
            return new Latlon[0];
        }
        int len = this.list.size();
        Latlon[] array = new Latlon[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.list.get(i);
        }
        return array;
    }

    @Override
    public List<Latlon> toList() {
        return new ArrayList<Latlon>(this.list);
    }

    @Override
    public GeoPolyline clone() {
        return new ImmutableGeoPolyline(this.list);
    }

    @Override
    public GeoShapeUnit getGeoShapeUnit() {
        return GeoShapeUnit.GeoPolyline;
    }

    @Override
    public Latlon[] getBounds() {
        if (this.nullOrEmpty()) {
            return new ImmutableLatlon[0];
        }
        GeoBoundry geoBoundry = Locate.boundsOf(this.list);
        return new Latlon[]{new ImmutableLatlon(geoBoundry.lowerBound), new ImmutableLatlon(geoBoundry.upperBound)};
    }

    @Override
    public String getId() {
        return this.id;
    }

    private boolean nullOrEmpty() {
        return this.list == null || this.list.isEmpty();
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.list);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableGeoPolyline other = (ImmutableGeoPolyline)obj;
        return Objects.equals(this.list, other.list);
    }
}

