/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import terraml.commons.Doubles;
import terraml.commons.Ints;
import terraml.geospatial.GeoPolygon;
import terraml.geospatial.GeoSegment;
import terraml.geospatial.GeoShapeUnit;
import terraml.geospatial.GeoVector;
import terraml.geospatial.Latlon;
import terraml.geospatial.SegmentIntersection;
import terraml.geospatial.impl.ImmutableGeoBoundingBox;
import terraml.geospatial.impl.ImmutableGeoSegment;
import terraml.geospatial.impl.ImmutableLatlon;

public final class ImmutableGeoPolygon
implements GeoPolygon,
Serializable {
    public final String id;
    public final List<Latlon> vertices;

    public ImmutableGeoPolygon(String id, List<Latlon> vertices) {
        this.id = id;
        this.vertices = vertices;
    }

    public ImmutableGeoPolygon(List<Latlon> vertices) {
        if (!ImmutableGeoPolygon.isValid(vertices)) {
            throw new IllegalArgumentException("there must be at least 3 vertices in the given list/array.");
        }
        this.vertices = new ArrayList<Latlon>(vertices);
        this.id = null;
    }

    public ImmutableGeoPolygon(Latlon ... vertices) {
        this(Arrays.asList(vertices));
    }

    public ImmutableGeoPolygon(String id, Latlon ... vertices) {
        this(id, Arrays.asList(vertices));
    }

    public ImmutableGeoPolygon(GeoPolygon geoPolygon) {
        this(geoPolygon.toList());
    }

    @Override
    public boolean contains(Latlon coordinate) {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Polygon is empty.");
        }
        GeoVector _v0 = GeoVector.fromLatlon(coordinate);
        int _len = this.getVerticesCount() - 1;
        ArrayList<GeoVector> _transformed = new ArrayList<GeoVector>();
        for (int i = 0; i < _len; ++i) {
            _transformed.add(_v0.translate(GeoVector.fromLatlon(this.vertices.get(i)).reverse()));
        }
        _transformed.add((GeoVector)_transformed.get(0));
        double _letQ = 0.0;
        for (int i = 0; i < _len; ++i) {
            _letQ += ((GeoVector)_transformed.get((int)i)).angleTo((GeoVector)((GeoVector)_transformed.get((int)(i + 1))), (GeoVector)_v0).radian;
        }
        return Doubles.isGreater((double)Math.abs(_letQ), (double)Math.PI);
    }

    @Override
    public boolean contains(GeoPolygon polygon) {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Either this or given polygon is empty.");
        }
        if (terraml.commons.Objects.isNull((Object)polygon)) {
            throw new IllegalStateException("Either this or given polygon is empty.");
        }
        ImmutableGeoBoundingBox _selfRect = new ImmutableGeoBoundingBox(this.vertices);
        List<Latlon> argVertx = polygon.getVertices();
        ImmutableGeoBoundingBox _polyRect = new ImmutableGeoBoundingBox(argVertx);
        if (!_selfRect.contains(_polyRect) || this.intersects(polygon)) {
            return false;
        }
        List<Latlon> _ptr = argVertx;
        for (Latlon curr : _ptr) {
            if (this.contains(curr)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean intersects(GeoPolygon polygon) {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Either this or given polygon is empty.");
        }
        if (terraml.commons.Objects.isNull((Object)polygon)) {
            throw new IllegalStateException("Either this or given polygon is empty.");
        }
        Collection<GeoSegment> _self = this.toSegments();
        Collection<GeoSegment> _ply = polygon.toSegments();
        return _self.stream().anyMatch(curr -> _ply.stream().anyMatch(next -> SegmentIntersection.intersects(curr, next)));
    }

    @Override
    public Collection<GeoSegment> toSegments() {
        ArrayList<GeoSegment> _sgm = new ArrayList<GeoSegment>();
        List<Latlon> _vx = this.vertices;
        boolean _clsd = this.isClosed();
        int _lh = _vx.size();
        for (int i = 0; i < _lh; ++i) {
            int _idx = i + 1;
            if (!Ints.isSmaller((int)_idx, (int)_lh)) continue;
            Latlon _src = _vx.get(i);
            Latlon _tar = _vx.get(_idx);
            ImmutableGeoSegment _seg = new ImmutableGeoSegment(_src, _tar);
            _sgm.add(_seg);
        }
        if (!_clsd) {
            Latlon _src = _vx.get(_lh - 1);
            Latlon _tar = _vx.get(0);
            ImmutableGeoSegment _seg = new ImmutableGeoSegment(_src, _tar);
            _sgm.add(_seg);
        }
        return _sgm;
    }

    @Override
    public boolean isValid() {
        return Ints.isGreaterEqual((int)this.vertices.size(), (int)3);
    }

    @Override
    public boolean isClosed() {
        List<Latlon> _lst = this.vertices;
        Latlon _org = _lst.get(0);
        int _lh = _lst.size() - 1;
        return _lst.get(_lh).equals(_org);
    }

    @Override
    public boolean isProper() {
        return this.isValid() && this.isClosed();
    }

    @Override
    public boolean prepare() {
        if (Ints.isEqual((int)this.vertices.size(), (int)3)) {
            this.vertices.add(this.vertices.get(0));
            return this.vertices.get(0).equals(this.vertices.get(this.getVerticesCount() - 1));
        }
        if (this.isValid() && !this.isClosed()) {
            this.vertices.add(this.vertices.get(0));
            return this.vertices.get(0).equals(this.vertices.get(this.getVerticesCount() - 1));
        }
        return false;
    }

    private int _lowUpp(boolean isMax, boolean isX) {
        double ref = isMax ? 0.0 : Double.MAX_VALUE;
        int idx = -1;
        for (int t = 0; t < this.getVerticesCount(); ++t) {
            double temp;
            double d = temp = isX ? this.vertices.get(t).getLatitude().toDegree() : this.vertices.get(t).getLongitude().toDegree();
            if (isMax) {
                if (!(temp > ref)) continue;
                idx = t;
                ref = temp;
                continue;
            }
            if (!(temp < ref)) continue;
            idx = t;
            ref = temp;
        }
        return idx;
    }

    @Override
    public GeoPolygon addVertex(Latlon vertex) {
        ArrayList<Latlon> _vertx = new ArrayList<Latlon>(this.vertices);
        _vertx.add(vertex);
        Latlon originLatlon = (Latlon)_vertx.get(0);
        _vertx.add(originLatlon);
        return new ImmutableGeoPolygon(_vertx);
    }

    @Override
    public GeoPolygon removeVertex(Latlon vertex) {
        if (Doubles.isSmaller((double)this.getVerticesCount(), (double)4.0)) {
            return this;
        }
        ArrayList<Latlon> _vertx = new ArrayList<Latlon>(this.vertices);
        if (vertex.equals(this.vertices.get(0))) {
            Latlon newOri = this.vertices.get(1);
            int len = this.getVerticesCount();
            _vertx.remove(0);
            _vertx.remove(len - 2);
            _vertx.add(newOri);
        }
        _vertx.remove(vertex);
        return new ImmutableGeoPolygon(_vertx);
    }

    @Override
    public List<Latlon> getVertices() {
        return new ArrayList<Latlon>(this.vertices);
    }

    @Override
    public Latlon[] toArray() {
        int len = this.getVerticesCount();
        Latlon[] asArray = new Latlon[len];
        for (int i = 0; i < len; ++i) {
            asArray[i] = new ImmutableLatlon(this.vertices.get(i));
        }
        return asArray;
    }

    @Override
    public List<Latlon> toList() {
        return new ArrayList<Latlon>(this.vertices);
    }

    @Override
    public int getVerticesCount() {
        return this.vertices.size();
    }

    @Override
    public ImmutableGeoPolygon clone() {
        return new ImmutableGeoPolygon(this.vertices);
    }

    @Override
    public GeoShapeUnit getGeoShapeUnit() {
        return GeoShapeUnit.GeoPolygon;
    }

    @Override
    public Latlon[] getBounds() {
        double uppLat = this.vertices.get(this._lowUpp(true, true)).getLatitude().toDegree();
        double uppLon = this.vertices.get(this._lowUpp(false, true)).getLongitude().toDegree();
        double lowLat = this.vertices.get(this._lowUpp(true, false)).getLatitude().toDegree();
        double lowLon = this.vertices.get(this._lowUpp(false, false)).getLongitude().toDegree();
        ImmutableLatlon upp = new ImmutableLatlon(lowLat, lowLon);
        ImmutableLatlon low = new ImmutableLatlon(uppLat, uppLon);
        return new Latlon[]{upp, low};
    }

    @Override
    public String getId() {
        return this.id;
    }

    private static boolean isValid(List<Latlon> _lst) {
        return Ints.isGreaterEqual((int)_lst.size(), (int)3);
    }

    private boolean nullOrEmpty() {
        return this.vertices == null || this.vertices.isEmpty();
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.vertices);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableGeoPolygon other = (ImmutableGeoPolygon)obj;
        return Objects.equals(this.vertices, other.vertices);
    }
}

