/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import terraml.commons.Doubles;
import terraml.commons.math.Angle;
import terraml.geospatial.Distance;
import terraml.geospatial.DistanceNode;
import terraml.geospatial.GeoCircle;
import terraml.geospatial.GeoPolyline;
import terraml.geospatial.GeoShapeUnit;
import terraml.geospatial.Latitude;
import terraml.geospatial.Latlon;
import terraml.geospatial.LatlonIntersection;
import terraml.geospatial.Longitude;
import terraml.geospatial.Zone;
import terraml.geospatial.impl.ImmutableGeoPolyline;
import terraml.geospatial.impl.ImmutableLatlon;

public final class ImmutableGeoCircle
implements GeoCircle,
Serializable {
    public final String id;
    public final Latlon center;
    public final DistanceNode radius;

    public ImmutableGeoCircle(String id, Latlon center, DistanceNode radius) {
        this.id = id;
        this.center = center;
        this.radius = radius;
    }

    public ImmutableGeoCircle(Latlon center, DistanceNode radius) {
        this.center = center;
        this.radius = radius;
        this.id = null;
    }

    public ImmutableGeoCircle(Latitude lat0, Longitude lon0, DistanceNode radius) {
        this(new ImmutableLatlon(lat0, lon0), radius);
    }

    public ImmutableGeoCircle(String id, Latitude lat0, Longitude lon0, DistanceNode radius) {
        this(id, new ImmutableLatlon(lat0, lon0), radius);
    }

    public ImmutableGeoCircle(double lat0, double lon0, DistanceNode radius) {
        this(new ImmutableLatlon(lat0, lon0), radius);
    }

    public ImmutableGeoCircle(String id, double lat0, double lon0, DistanceNode radius) {
        this(id, new ImmutableLatlon(lat0, lon0), radius);
    }

    public ImmutableGeoCircle(GeoCircle circle) {
        this(circle.getCenter(), circle.getRadius());
    }

    @Override
    public boolean contains(Latlon coordinate) {
        return LatlonIntersection.withinAccurate(coordinate, this);
    }

    @Override
    public boolean contains(GeoCircle geoCircle) {
        double _d = Distance.vincenty(this.center, geoCircle.getCenter());
        double _dr = this.radius.asMeter() - geoCircle.getRadius().asMeter();
        return Doubles.isSmallerEqual((double)_d, (double)_dr);
    }

    @Override
    public boolean intersects(GeoCircle circle) {
        double _d = Distance.vincenty(this.center, circle.getCenter());
        double _dr = this.radius.asMeter() + circle.getRadius().asMeter();
        return Doubles.isSmallerEqual((double)_d, (double)_dr);
    }

    @Override
    public Latlon getCenter() {
        return new ImmutableLatlon(this.center);
    }

    @Override
    public DistanceNode getRadius() {
        return this.radius;
    }

    @Override
    public GeoCircle offset(DistanceNode distanceNode, Angle bearing) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double area() {
        return Zone.areaOf(this);
    }

    @Override
    public GeoPolyline toOctagon() {
        Latlon _center = this.center;
        ArrayList<Latlon> _lst = new ArrayList<Latlon>();
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)0.0)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)45.0)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)90.0)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)135.0)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)180.0)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)225.0)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)270.0)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)325.0)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)360.0)));
        return new ImmutableGeoPolyline(_lst);
    }

    @Override
    public GeoPolyline to2xOctagon() {
        Latlon _center = this.center;
        ArrayList<Latlon> _lst = new ArrayList<Latlon>();
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)0.0)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)22.5)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)45.0)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)67.5)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)90.0)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)112.5)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)135.0)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)157.5)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)180.0)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)202.5)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)225.0)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)247.5)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)270.0)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)297.5)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)325.0)));
        _lst.add(_center.offset(this.radius, Angle.fromDegree((double)360.0)));
        return new ImmutableGeoPolyline(_lst);
    }

    @Override
    public Latlon[] getBounds() {
        ImmutableLatlon _ctr = new ImmutableLatlon(this.center);
        Latlon _ne = _ctr.offset(this.radius, Angle.fromDegree((double)0.0));
        Latlon _sw = _ctr.offset(this.radius, Angle.fromDegree((double)180.0));
        _ne = _ne.offset(this.radius, Angle.fromDegree((double)90.0));
        _sw = _sw.offset(this.radius, Angle.fromDegree((double)270.0));
        return new Latlon[]{_ne, _sw};
    }

    @Override
    public double[] toArray() {
        return new double[]{this.center.getLatitude().toDegree(), this.center.getLongitude().toDegree(), this.radius.asMeter()};
    }

    @Override
    public ImmutableGeoCircle clone() {
        return new ImmutableGeoCircle(this.center, this.radius);
    }

    @Override
    public GeoShapeUnit getGeoShapeUnit() {
        return GeoShapeUnit.GeoCircle;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.center);
        hash = 97 * hash + Objects.hashCode(this.radius);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableGeoCircle other = (ImmutableGeoCircle)obj;
        if (!Objects.equals(this.center, other.center)) {
            return false;
        }
        return Objects.equals(this.radius, other.radius);
    }
}

