/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import terraml.commons.Doubles;
import terraml.commons.math.Angle;
import terraml.commons.math.Interval;
import terraml.geospatial.DistanceNode;
import terraml.geospatial.GeoBoundingBox;
import terraml.geospatial.GeoPolyline;
import terraml.geospatial.GeoSegment;
import terraml.geospatial.GeoShapeUnit;
import terraml.geospatial.Latitude;
import terraml.geospatial.Latlon;
import terraml.geospatial.LatlonIntersection;
import terraml.geospatial.Locate;
import terraml.geospatial.Longitude;
import terraml.geospatial.impl.ImmutableGeoPolyline;
import terraml.geospatial.impl.ImmutableGeoSegment;
import terraml.geospatial.impl.ImmutableLatlon;

public final class ImmutableGeoBoundingBox
implements GeoBoundingBox,
Serializable {
    public final String id;
    public final Latlon southWest;
    public final Latlon northEast;

    public ImmutableGeoBoundingBox(String id, Latlon southWest, Latlon northEast) {
        this.id = id;
        this.southWest = southWest;
        this.northEast = northEast;
    }

    public ImmutableGeoBoundingBox(Latlon southWest, Latlon northEast) {
        Latlon[] fixedBounds = ImmutableGeoBoundingBox._fixBounds(southWest, northEast);
        this.southWest = fixedBounds[0];
        this.northEast = fixedBounds[1];
        this.id = UUID.randomUUID().toString();
    }

    public ImmutableGeoBoundingBox(Latitude lat0, Longitude lon0, Latitude lat1, Longitude lon1) {
        this(new ImmutableLatlon(lat0, lon0), new ImmutableLatlon(lat1, lon1));
    }

    public ImmutableGeoBoundingBox(String id, Latitude lat0, Longitude lon0, Latitude lat1, Longitude lon1) {
        this(id, new ImmutableLatlon(lat0, lon0), new ImmutableLatlon(lat1, lon1));
    }

    public ImmutableGeoBoundingBox(GeoBoundingBox geoBoundingBox) {
        this(geoBoundingBox.getSouthWest(), geoBoundingBox.getNorthEast());
    }

    public ImmutableGeoBoundingBox(Latlon[] latlonArray) {
        this(latlonArray[0], latlonArray[1]);
    }

    public ImmutableGeoBoundingBox(String id, Latlon[] latlonArray) {
        this(latlonArray[0], latlonArray[1]);
    }

    public ImmutableGeoBoundingBox(List<Latlon> latlons) {
        this(null, latlons);
    }

    public ImmutableGeoBoundingBox(String id, List<Latlon> latlons) {
        List<Latlon> _bnd = Locate.locateBoundsOf(latlons);
        this.id = id;
        this.southWest = _bnd.get(0);
        this.northEast = _bnd.get(1);
    }

    private static Latlon[] _fixBounds(Latlon sw, Latlon ne) {
        Interval intValX = new Interval(sw.getLatitude().toDegree(), ne.getLatitude().toDegree());
        Interval intValY = new Interval(sw.getLongitude().toDegree(), ne.getLongitude().toDegree());
        return new Latlon[]{new ImmutableLatlon(intValX.left, intValY.left), new ImmutableLatlon(intValX.right, intValY.right)};
    }

    @Override
    public boolean contains(Latlon coordinate) {
        return LatlonIntersection.within(coordinate, this);
    }

    @Override
    public boolean contains(GeoBoundingBox geoBox) {
        Latlon boxSW = geoBox.getSouthWest();
        Latlon boxNE = geoBox.getSouthWest();
        Latlon thisSW = this.southWest;
        Latlon thisNE = this.northEast;
        return this.contains(thisSW, thisNE, boxSW, boxNE);
    }

    private boolean contains(Latlon thisSW, Latlon thisNE, Latlon thatSW, Latlon thatNE) {
        return Doubles.isGreaterEqual((double)thatSW.lat(), (double)thisSW.lat()) && Doubles.isSmallerEqual((double)thatNE.lat(), (double)thisNE.lat()) && Doubles.isGreaterEqual((double)thatSW.lon(), (double)thisSW.lon()) && Doubles.isSmallerEqual((double)thatNE.lon(), (double)thisNE.lon());
    }

    private boolean disjoint(Latlon thisSW, Latlon thisNE, Latlon thatSW, Latlon thatNE) {
        boolean situ0 = this.contains(thisSW, thisNE, thatSW, thatNE);
        boolean situ1 = this.contains(thatSW, thatNE, thisSW, thisNE);
        return !situ0 && !situ1;
    }

    @Override
    public boolean intersects(GeoBoundingBox geoBox) {
        Latlon boxNE;
        Latlon thisSW = this.southWest;
        Latlon thisNE = this.northEast;
        Latlon boxSW = geoBox.getSouthWest();
        if (this.disjoint(thisSW, thisNE, boxSW, boxNE = geoBox.getSouthWest())) {
            return false;
        }
        return Doubles.isGreaterEqual((double)boxNE.lat(), (double)thisSW.lat()) && Doubles.isSmallerEqual((double)boxSW.lat(), (double)thisNE.lat()) && Doubles.isGreaterEqual((double)boxNE.lon(), (double)thisSW.lon()) && Doubles.isSmallerEqual((double)boxSW.lon(), (double)thisNE.lon());
    }

    @Override
    public Collection<GeoSegment> toHeuristicSegments() {
        LinkedList<GeoSegment> segments = new LinkedList<GeoSegment>();
        if (terraml.commons.Objects.isNull((Object)this.southWest) || terraml.commons.Objects.isNull((Object)this.northEast)) {
            return segments;
        }
        Latlon[] _bnd = this.getBounds();
        Latlon _sw = _bnd[0];
        Latlon _ne = _bnd[1];
        ImmutableLatlon _nw = new ImmutableLatlon(_ne.lat(), _sw.lon());
        ImmutableLatlon _se = new ImmutableLatlon(_sw.lat(), _ne.lon());
        segments.add(new ImmutableGeoSegment(_ne, _se));
        segments.add(new ImmutableGeoSegment(_se, _sw));
        segments.add(new ImmutableGeoSegment(_sw, _nw));
        segments.add(new ImmutableGeoSegment(_nw, _ne));
        return segments;
    }

    @Override
    public Collection<GeoSegment> toAccurateSegments() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Latlon nw() {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Rectangle is empty");
        }
        Latlon[] _bnd = this.getBounds();
        Latlon _sw = _bnd[0];
        Latlon _ne = _bnd[1];
        ImmutableLatlon _nw = new ImmutableLatlon(_ne.lat(), _sw.lon());
        return _nw;
    }

    private Latlon se() {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Rectangle is empty");
        }
        Latlon[] _bnd = this.getBounds();
        Latlon _sw = _bnd[0];
        Latlon _ne = _bnd[1];
        ImmutableLatlon _se = new ImmutableLatlon(_sw.lat(), _ne.lon());
        return _se;
    }

    @Override
    public GeoPolyline toPolylineCW() {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Rectangle is empty");
        }
        ArrayList<Latlon> _crd = new ArrayList<Latlon>();
        _crd.add(this.northEast);
        _crd.add(this.se());
        _crd.add(this.southWest);
        _crd.add(this.nw());
        return new ImmutableGeoPolyline(_crd);
    }

    @Override
    public GeoPolyline toPolylineCCW() {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Rectangle is empty");
        }
        ArrayList<Latlon> _crd = new ArrayList<Latlon>();
        _crd.add(this.northEast);
        _crd.add(this.nw());
        _crd.add(this.southWest);
        _crd.add(this.se());
        return new ImmutableGeoPolyline(_crd);
    }

    @Override
    public Latlon getCenter() {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Rectangle is empty");
        }
        ImmutableLatlon object = new ImmutableLatlon(Locate.centerOfBounds(this.southWest, this.northEast));
        return object;
    }

    @Override
    public Latlon getCenterAccurate() {
        if (this.nullOrEmpty()) {
            throw new IllegalStateException("Rectangle is empty");
        }
        ImmutableLatlon object = new ImmutableLatlon(Locate.centerOf(Arrays.asList(this.southWest, this.northEast)));
        return object;
    }

    @Override
    public GeoBoundingBox offset(DistanceNode distance, Angle bearing) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Latlon getSouthWest() {
        return new ImmutableLatlon(this.southWest);
    }

    @Override
    public Latlon getNorthEast() {
        return new ImmutableLatlon(this.northEast);
    }

    @Override
    public Latlon[] toArray() {
        return new Latlon[]{this.getSouthWest(), this.getNorthEast()};
    }

    @Override
    public double[] toDoubleArray() {
        return new double[]{this.southWest.getLatitude().toDegree(), this.southWest.getLongitude().toDegree(), this.northEast.getLatitude().toDegree(), this.northEast.getLongitude().toDegree()};
    }

    @Override
    public ImmutableGeoBoundingBox clone() {
        return new ImmutableGeoBoundingBox(this.southWest, this.northEast);
    }

    @Override
    public GeoShapeUnit getGeoShapeUnit() {
        return GeoShapeUnit.GeoBoundingBox;
    }

    @Override
    public Latlon[] getBounds() {
        return new Latlon[]{this.getSouthWest(), this.getNorthEast()};
    }

    private boolean nullOrEmpty() {
        return Objects.isNull(this.southWest) || Objects.isNull(this.northEast);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.southWest);
        hash = 31 * hash + Objects.hashCode(this.northEast);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableGeoBoundingBox other = (ImmutableGeoBoundingBox)obj;
        if (!Objects.equals(this.southWest, other.southWest)) {
            return false;
        }
        return Objects.equals(this.northEast, other.northEast);
    }

    @Override
    public String getId() {
        return this.id;
    }
}

