/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial;

import java.util.ArrayList;
import java.util.List;
import terraml.commons.Doubles;
import terraml.geospatial.Azimuths;
import terraml.geospatial.GeoBoundingBox;
import terraml.geospatial.GeoCircle;
import terraml.geospatial.GeoPolygon;
import terraml.geospatial.GeoUtils;
import terraml.geospatial.Latlon;

public final class Zone {
    private Zone() {
    }

    public static double areaOf(GeoPolygon geoPolygon) {
        List<Latlon> vertices = geoPolygon.toList();
        int _len = vertices.size() - 1;
        double _letQ = 0.0;
        for (int i = 0; i < _len; ++i) {
            Latlon _curr = vertices.get(i);
            Latlon _next = vertices.get(i + 1);
            double _lat0 = _curr.getLatitude().toRadian();
            double _lat1 = _next.getLatitude().toRadian();
            double _deltaLon = Math.toRadians(GeoUtils.lon2deg(_next) - GeoUtils.lon2deg(_curr));
            double _letY = Math.tan(_deltaLon * 0.5) * (Math.tan(_lat0 * 0.5) + Math.tan(_lat1 * 0.5));
            double _letX = 1.0 + Math.tan(_lat0 * 0.5) / Math.tan(_lat1 * 0.5);
            _letQ += 2.0 * Math.atan2(_letY, _letX);
        }
        if (Zone.isFixed(geoPolygon)) {
            _letQ = Math.abs(_letQ) - Math.PI * 2;
        }
        return Math.abs(_letQ * Math.pow(6371.0, 2.0));
    }

    private static boolean isFixed(GeoPolygon geoPolygon) {
        List<Latlon> vertices = geoPolygon.toList();
        double _fwAz = Azimuths.northBasedAzimuth((Latlon)vertices.get((int)0), (Latlon)vertices.get((int)1)).degree;
        double _deltaQ = 0.0;
        for (int i = 0; i < vertices.size() - 1; ++i) {
            double _az = Azimuths.northBasedAzimuth((Latlon)vertices.get((int)i), (Latlon)vertices.get((int)(i + 1))).degree;
            double _faz = Azimuths.northBasedFinalAzimuth((Latlon)vertices.get((int)i), (Latlon)vertices.get((int)(i + 1))).degree;
            _deltaQ += GeoUtils.fixLongitudeFromDegree(_az - _fwAz);
            _deltaQ += GeoUtils.fixLongitudeFromDegree(_faz - _az);
            _fwAz = _faz;
        }
        double _nfaz = Azimuths.northBasedAzimuth((Latlon)vertices.get((int)0), (Latlon)vertices.get((int)1)).degree;
        _deltaQ = GeoUtils.fixLongitudeFromDegree(_nfaz - _fwAz);
        return Doubles.isSmaller((double)Math.abs(_deltaQ), (double)90.0);
    }

    public static double areaOf2(GeoPolygon geoPolygon) {
        List<Latlon> vertices = GeoUtils.openFormOf(geoPolygon.toList());
        ArrayList<Double> latitudes = new ArrayList<Double>();
        ArrayList<Double> longitudes = new ArrayList<Double>();
        vertices.stream().map(_vertex -> {
            latitudes.add(_vertex.getLatitude().toDegree());
            return _vertex;
        }).forEachOrdered(_vertex -> longitudes.add(_vertex.getLongitude().toDegree()));
        return Zone.areaOf2(latitudes, longitudes);
    }

    private static double areaOf2(ArrayList<Double> lats, ArrayList<Double> lons) {
        double sum = 0.0;
        double prevcolat = 0.0;
        double prevaz = 0.0;
        double colat0 = 0.0;
        double az0 = 0.0;
        for (int i = 0; i < lats.size(); ++i) {
            double colat = 2.0 * Math.atan2(Math.sqrt(Math.pow(Math.sin(lats.get(i) * Math.PI / 180.0 / 2.0), 2.0) + Math.cos(lats.get(i) * Math.PI / 180.0) * Math.pow(Math.sin(lons.get(i) * Math.PI / 180.0 / 2.0), 2.0)), Math.sqrt(1.0 - Math.pow(Math.sin(lats.get(i) * Math.PI / 180.0 / 2.0), 2.0) - Math.cos(lats.get(i) * Math.PI / 180.0) * Math.pow(Math.sin(lons.get(i) * Math.PI / 180.0 / 2.0), 2.0)));
            double az = 0.0;
            az = lats.get(i) >= 90.0 ? 0.0 : (lats.get(i) <= -90.0 ? Math.PI : Math.atan2(Math.cos(lats.get(i) * Math.PI / 180.0) * Math.sin(lons.get(i) * Math.PI / 180.0), Math.sin(lats.get(i) * Math.PI / 180.0)) % (Math.PI * 2));
            if (i == 0) {
                colat0 = colat;
                az0 = az;
            }
            if (i > 0 && i < lats.size()) {
                sum += (1.0 - Math.cos(prevcolat + (colat - prevcolat) / 2.0)) * Math.PI * (Math.abs(az - prevaz) / Math.PI - 2.0 * Math.ceil((Math.abs(az - prevaz) / Math.PI - 1.0) / 2.0)) * Math.signum(az - prevaz);
            }
            prevcolat = colat;
            prevaz = az;
        }
        return 5.10072E14 * Math.min(Math.abs(sum += (1.0 - Math.cos(prevcolat + (colat0 - prevcolat) / 2.0)) * (az0 - prevaz)) / 4.0 / Math.PI, 1.0 - Math.abs(sum) / 4.0 / Math.PI);
    }

    public static double areaOf(GeoBoundingBox geoBoundingBox) {
        double _deltaSin = Math.abs(Math.sin(GeoUtils.lat2rad(geoBoundingBox.getNorthEast())) - Math.sin(GeoUtils.lat2rad(geoBoundingBox.getSouthWest())));
        double _deltaLon = Math.abs(GeoUtils.lon2deg(geoBoundingBox.getNorthEast()) - GeoUtils.lon2deg(geoBoundingBox.getSouthWest()));
        double _letQ = Math.PI / 180 * Math.pow(6371000.0, 2.0);
        double letW = _letQ * _deltaSin * _deltaLon;
        return letW / 1000.0;
    }

    public static double areaOf(GeoCircle geoCircle) {
        double _letQ = geoCircle.getRadius().asKilometer() / 6371.0;
        double _surf = Math.PI * 2 * Math.pow(6371.0, 2.0);
        double _letW = 1.0 - Math.cos(_letQ);
        return _surf * _letW;
    }
}

