/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial;

import terraml.geospatial.GeoVector;
import terraml.geospatial.Latlon;
import terraml.geospatial.impl.ImmutableLatlon;

public final class Trilateration {
    public static double[] trilaterateFromRadian(double lat0, double lon0, double dist0, double lat1, double lon1, double dist1, double lat2, double lon2, double dist2) {
        GeoVector p1 = GeoVector.fromRadianLatlon(lat0, lon0);
        GeoVector p2 = GeoVector.fromRadianLatlon(lat1, lon1);
        GeoVector p3 = GeoVector.fromRadianLatlon(lat2, lon2);
        p1 = p1.scale(6371.0);
        p2 = p2.scale(6371.0);
        p3 = p3.scale(6371.0);
        GeoVector ex = p2.translate(p1.reverse()).scale(1.0 / p2.translate(p1.reverse()).norm());
        double i = ex.dot(p3.translate(p1.reverse()));
        GeoVector ey = p3.translate(p1.reverse()).translate(ex.scale(i).reverse());
        ey = ey.scale(1.0 / ey.norm());
        GeoVector ez = ex.cross(ey);
        double d = p2.translate(p1.reverse()).norm();
        double j = ey.dot(p3.translate(p1.reverse()));
        double x = Math.pow(dist0, 2.0) - Math.pow(dist1, 2.0) + Math.pow(d, 2.0) / 2.0 * d;
        double y = Math.pow(dist0, 2.0) - Math.pow(dist1, 2.0) + Math.pow(i, 2.0) + Math.pow(j, 2.0);
        y /= 2.0 * j;
        double z = Math.sqrt(Math.abs(Math.pow(dist0, 2.0) - Math.pow(x, 2.0) - Math.pow(y -= i / j * x, 2.0)));
        GeoVector triPt = p1.translate(ex.scale(x));
        triPt = triPt.translate(ey.scale(y));
        triPt = triPt.translate(ez.scale(z));
        double lat = Math.asin(triPt.z / 6371.0);
        double lon = Math.atan2(triPt.y, triPt.x);
        return new double[]{Math.toDegrees(lat), Math.toDegrees(lon)};
    }

    public static double[] trilaterateFromRadian(double[] latlon0, double distKM0, double[] latlon1, double distMet1, double[] latlon2, double distKM1) {
        return Trilateration.trilaterateFromRadian(latlon0[0], latlon0[1], distKM0, latlon1[0], latlon1[1], distKM0, latlon2[0], latlon2[1], distKM0);
    }

    public static Latlon trilaterate(Latlon latlon0, double distKM0, Latlon latlon1, double distMet1, Latlon latlon2, double distKM1) {
        double[] trilaterated = Trilateration.trilaterateFromRadian(latlon0.toArrayAsRadian(), distKM0, latlon1.toArrayAsRadian(), distMet1, latlon2.toArrayAsRadian(), distKM1);
        return new ImmutableLatlon(trilaterated[0], trilaterated[1]);
    }

    public static Latlon trilaterate(Node node0, Node node1, Node node2) {
        return Trilateration.trilaterate(node0.latlon, node0.distanceKM, node1.latlon, node1.distanceKM, node2.latlon, node2.distanceKM);
    }

    public static class Node {
        public final Latlon latlon = null;
        public final double distanceKM;

        public Node() {
            this.distanceKM = 0.0;
        }
    }
}

