/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial;

import terraml.commons.Doubles;
import terraml.commons.Objects;
import terraml.commons.math.Angle;
import terraml.geospatial.GeoUtils;
import terraml.geospatial.Latlon;
import terraml.geospatial.impl.ImmutableLatlon;

public final class Triangulation {
    public static double[] triangulateFromRadian(double lat0, double lon0, double bearin0, double lat1, double lon1, double bearin1) {
        double _deltaX = lat1 - lat0;
        double _deltaY = lon1 - lon0;
        double _let0 = Math.pow(Math.sin(_deltaX / 2.0), 2.0) + Math.cos(lat0) * Math.cos(lat1) * Math.pow(Math.sin(_deltaY / 2.0), 2.0);
        if (Doubles.isNumericallyEqual((double)(_let0 = 2.0 * Math.asin(Math.sqrt(_let0))), (double)0.0)) {
            return null;
        }
        double _deltaA = (Math.sin(lat1) - Math.sin(lat0) * Math.cos(_let0)) / (Math.sin(_let0) * Math.cos(lat0));
        if (Double.isNaN(_deltaA = Math.acos(_deltaA))) {
            _deltaA = 0.0;
        }
        double _deltaB = (Math.sin(lat0) - Math.sin(lat1) * Math.cos(_let0)) / (Math.sin(_let0) * Math.cos(lat1));
        _deltaB = Math.acos(_deltaB);
        double _let1 = Doubles.isGreater((double)Math.sin(lon1 - lon0), (double)0.0) ? _deltaA : Math.PI * 2 - _deltaA;
        double _let2 = Doubles.isGreater((double)Math.sin(lon1 - lon0), (double)0.0) ? Math.PI * 2 - _deltaB : _deltaB;
        double _let3 = (bearin0 - _let1 + Math.PI) % (Math.PI * 2) - Math.PI;
        double _let4 = (_let2 - bearin1 + Math.PI) % (Math.PI * 2) - Math.PI;
        if (Doubles.isNumericallyEqual((double)Math.sin(_let3), (double)0.0) && Doubles.isNumericallyEqual((double)Math.sin(_let4), (double)0.0)) {
            return null;
        }
        if (Doubles.isSmaller((double)(Math.sin(_let3) * Math.sin(_let4)), (double)0.0)) {
            return null;
        }
        double _let5 = -Math.cos(_let3) * Math.cos(_let4) + Math.sin(_let3) * Math.sin(_let4) * Math.cos(_let0);
        _let5 = Math.acos(_let5);
        double _let6 = Math.atan2(Math.sin(_let0) * Math.sin(_let3) * Math.sin(_let4), Math.cos(_let4) + Math.cos(_let3) * Math.cos(_let5));
        double lat = Math.sin(lat0) * Math.cos(_let6) + Math.cos(lat0) * Math.sin(_let6) * Math.cos(bearin0);
        lat = Math.asin(lat);
        double _let7 = Math.atan2(Math.sin(bearin0) * Math.sin(_let6) * Math.cos(lat0), Math.cos(_let6) - Math.sin(lat0) * Math.sin(lat));
        double lon = lon0 + _let7;
        return new double[]{Math.toDegrees(lat), GeoUtils.fixLongitudeFromDegree(Math.toDegrees(lon))};
    }

    public static double[] triangulateFromRadian(double[] latlon0, double bearing0, double[] latlon1, double bearing1) {
        return Triangulation.triangulateFromRadian(latlon0[0], latlon0[1], bearing0, latlon1[0], latlon1[1], bearing1);
    }

    public static Latlon triangulate(Latlon latlon0, Angle fwAzimuth0, Latlon latlon1, Angle fwAzimuth1) {
        double[] triangulated = Triangulation.triangulateFromRadian(latlon0.toArrayAsRadian(), fwAzimuth0.radian, latlon1.toArrayAsRadian(), fwAzimuth1.radian);
        if (Objects.isNull((Object)triangulated)) {
            return null;
        }
        return new ImmutableLatlon(triangulated[0], triangulated[1]);
    }

    public static Latlon triangulate(Node node0, Node node1) {
        return Triangulation.triangulate(node0.source, node0.bearing, node1.source, node1.bearing);
    }

    public static class Node {
        public final Latlon source;
        public final Angle bearing;

        public Node(Latlon source, Angle bearing) {
            this.source = source;
            this.bearing = bearing;
        }
    }
}

