/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial;

import terraml.commons.Doubles;
import terraml.commons.Objects;
import terraml.commons.math.Angle;
import terraml.geospatial.Azimuths;
import terraml.geospatial.Distance;
import terraml.geospatial.DistanceNode;
import terraml.geospatial.GeoSegment;
import terraml.geospatial.GeoUtils;
import terraml.geospatial.GeoVector;
import terraml.geospatial.Latlon;
import terraml.geospatial.LatlonIntersection;
import terraml.geospatial.Triangulation;
import terraml.geospatial.impl.ImmutableLatlon;

public final class SegmentIntersection {
    private SegmentIntersection() {
    }

    public static Latlon intersectionOf(GeoSegment geoSegment0, GeoSegment geoSegment1) {
        GeoVector _v0 = GeoVector.fromLatlon(geoSegment0.getSource());
        GeoVector _v1 = GeoVector.fromLatlon(geoSegment0.getTarget());
        GeoVector _v2 = GeoVector.fromLatlon(geoSegment1.getSource());
        GeoVector _v3 = GeoVector.fromLatlon(geoSegment1.getTarget());
        GeoVector _crs0 = _v0.cross(_v1);
        GeoVector _crs1 = _v2.cross(_v3);
        GeoVector i1 = _crs0.cross(_crs1);
        GeoVector i2 = _crs1.cross(_crs0);
        GeoVector _ttl = _v0.translate(_v1).translate(_v2).translate(_v3);
        GeoVector _intrsct = Doubles.isGreater((double)_ttl.dot(i1), (double)0.0) ? i1 : i2;
        Latlon temp = null;
        if (Objects.isNull((Object)_intrsct)) {
            temp = null;
        } else {
            try {
                temp = _intrsct.toLatlon();
            }
            catch (Exception e) {
                temp = null;
            }
        }
        return temp;
    }

    public static boolean intersects(GeoSegment geoSegment0, GeoSegment geoSegment1, DistanceNode tolerance) {
        Angle _bearing0 = Azimuths.northBasedAzimuth(geoSegment0.getSource(), geoSegment0.getTarget());
        Angle _bearing1 = Azimuths.northBasedAzimuth(geoSegment1.getSource(), geoSegment1.getTarget());
        Latlon _tried = Triangulation.triangulate(geoSegment0.getSource(), _bearing0, geoSegment1.getSource(), _bearing1);
        if (Objects.isNull((Object)_tried)) {
            return false;
        }
        double _crssTrck0 = Distance.vincenty(_tried, LatlonIntersection.closestAccurate(_tried, geoSegment0));
        double _crssTrck1 = Distance.vincenty(_tried, LatlonIntersection.closestAccurate(_tried, geoSegment1));
        return Doubles.isSmaller((double)Math.abs(_crssTrck0 - _crssTrck1), (double)tolerance.asMeter());
    }

    public static boolean intersects(GeoSegment geoSegment0, GeoSegment geoSegment1) {
        return SegmentIntersection.intersects(geoSegment0, geoSegment1, DistanceNode.fromMeter(1.0));
    }

    public static Latlon intersectionOf2(GeoSegment geoSegment0, GeoSegment geoSegment1) {
        double Qx = GeoUtils.lat2deg(geoSegment0.getTarget()) - GeoUtils.lat2deg(geoSegment0.getSource());
        double Qy = GeoUtils.lon2deg(geoSegment0.getSource()) - GeoUtils.lon2deg(geoSegment0.getTarget());
        double Qt = Qx * GeoUtils.lon2deg(geoSegment0.getSource()) + Qy * GeoUtils.lat2deg(geoSegment0.getSource());
        double Wx = GeoUtils.lat2deg(geoSegment1.getTarget()) - GeoUtils.lat2deg(geoSegment1.getSource());
        double Wy = GeoUtils.lon2deg(geoSegment1.getSource()) - GeoUtils.lon2deg(geoSegment1.getTarget());
        double Wt = Wx * GeoUtils.lon2deg(geoSegment1.getSource()) + Wy * GeoUtils.lat2deg(geoSegment1.getSource());
        double determinate = Qx * Wy - Wx * Qy;
        ImmutableLatlon intersection = null;
        if (determinate != 0.0) {
            double Zx = (Wy * Qt - Qy * Wt) / determinate;
            double Zy = (Qx * Wt - Wx * Qt) / determinate;
            ImmutableLatlon intersect = new ImmutableLatlon(Zy, Zx);
            boolean Vx = SegmentIntersection._inBBox(geoSegment0.getSource(), geoSegment0.getTarget(), intersect);
            boolean Vy = SegmentIntersection._inBBox(geoSegment1.getSource(), geoSegment1.getTarget(), intersect);
            intersection = Vx && Vy ? intersect : null;
        }
        return intersection;
    }

    private static boolean _inBBox(Latlon latlon0, Latlon latlon1, Latlon latlon2) {
        boolean _latB;
        if (Doubles.isSmaller((double)GeoUtils.lat2deg(latlon0), (double)GeoUtils.lat2deg(latlon1))) {
            _latB = Doubles.isSmallerEqual((double)GeoUtils.lat2deg(latlon0), (double)GeoUtils.lat2deg(latlon2)) && Doubles.isGreaterEqual((double)GeoUtils.lat2deg(latlon1), (double)GeoUtils.lat2deg(latlon2));
        } else {
            boolean bl = _latB = Doubles.isGreaterEqual((double)GeoUtils.lat2deg(latlon0), (double)GeoUtils.lat2deg(latlon2)) && Doubles.isSmallerEqual((double)GeoUtils.lat2deg(latlon1), (double)GeoUtils.lat2deg(latlon2));
        }
        boolean _lonB = Doubles.isSmaller((double)GeoUtils.lon2deg(latlon0), (double)GeoUtils.lon2deg(latlon1)) ? Doubles.isSmallerEqual((double)GeoUtils.lon2deg(latlon0), (double)GeoUtils.lon2deg(latlon2)) && Doubles.isGreaterEqual((double)GeoUtils.lon2deg(latlon1), (double)GeoUtils.lon2deg(latlon2)) : Doubles.isGreaterEqual((double)GeoUtils.lon2deg(latlon0), (double)GeoUtils.lon2deg(latlon2)) && Doubles.isSmallerEqual((double)GeoUtils.lon2deg(latlon1), (double)GeoUtils.lon2deg(latlon2));
        return _latB && _lonB;
    }

    public static boolean intersects2(GeoSegment geoSegment0, GeoSegment geoSegment1) {
        double p0_x = GeoUtils.lat2deg(geoSegment0.getSource());
        double p0_y = GeoUtils.lon2deg(geoSegment0.getSource());
        double p1_x = GeoUtils.lat2deg(geoSegment0.getTarget());
        double p1_y = GeoUtils.lon2deg(geoSegment0.getTarget());
        double p2_x = GeoUtils.lat2deg(geoSegment1.getSource());
        double p2_y = GeoUtils.lon2deg(geoSegment1.getSource());
        double p3_x = GeoUtils.lat2deg(geoSegment1.getTarget());
        double p3_y = GeoUtils.lon2deg(geoSegment1.getTarget());
        double s1_x = p1_x - p0_x;
        double s1_y = p1_y - p0_y;
        double s2_x = p3_x - p2_x;
        double s2_y = p3_y - p2_y;
        double s = (-s1_y * (p0_x - p2_x) + s1_x * (p0_y - p2_y)) / (-s2_x * s1_y + s1_x * s2_y);
        double t = (s2_x * (p0_y - p2_y) - s2_y * (p0_x - p2_x)) / (-s2_x * s1_y + s1_x * s2_y);
        return s >= 0.0 && s <= 1.0 && t >= 0.0 && t <= 1.0;
    }
}

