/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial;

import java.util.Collection;
import java.util.List;
import terraml.commons.tuple.Pair;
import terraml.geospatial.Distance;
import terraml.geospatial.DistanceNode;
import terraml.geospatial.GeoBoundingBox;
import terraml.geospatial.GeoCircle;
import terraml.geospatial.GeoPolygon;
import terraml.geospatial.GeoPolyline;
import terraml.geospatial.GeoSegment;
import terraml.geospatial.Intersect;
import terraml.geospatial.Latlon;
import terraml.geospatial.impl.ImmutableGeoBoundingBox;

public final class Overlap {
    private Overlap() {
    }

    public static boolean contains(GeoPolygon geoPolygon, GeoPolyline polyline) {
        Collection<GeoSegment> _polySeg;
        ImmutableGeoBoundingBox _polyRect;
        ImmutableGeoBoundingBox _selfRect = new ImmutableGeoBoundingBox(geoPolygon.getBounds());
        if (!_selfRect.contains(_polyRect = new ImmutableGeoBoundingBox(polyline.getBounds())) || !_selfRect.intersects(_polyRect)) {
            return false;
        }
        List<Latlon> _ptr = polyline.toList();
        for (Latlon curr : _ptr) {
            if (geoPolygon.contains(curr)) continue;
            return false;
        }
        Collection<GeoSegment> _selfSeg = geoPolygon.toSegments();
        return !Intersect.any(_selfSeg, _polySeg = polyline.toSegments());
    }

    public static boolean contains(GeoPolygon geoPolygon, GeoBoundingBox rectangle) {
        Collection<GeoSegment> _rectSeg;
        ImmutableGeoBoundingBox _selfRect = new ImmutableGeoBoundingBox(geoPolygon.getBounds());
        if (!_selfRect.contains(rectangle) || !_selfRect.intersects(rectangle)) {
            return false;
        }
        for (Latlon curr : rectangle.getBounds()) {
            if (geoPolygon.contains(curr)) continue;
            return false;
        }
        Collection<GeoSegment> _selfSeg = geoPolygon.toSegments();
        return !Intersect.any(_selfSeg, _rectSeg = rectangle.toHeuristicSegments());
    }

    public static boolean contains(GeoPolygon geoPolygon, GeoCircle circle) {
        Collection<GeoSegment> _crclSeg;
        ImmutableGeoBoundingBox _crclRect;
        if (!geoPolygon.contains(circle.getCenter())) {
            return false;
        }
        ImmutableGeoBoundingBox _selfRect = new ImmutableGeoBoundingBox(geoPolygon.getBounds());
        if (Intersect.disjoint(_selfRect, _crclRect = new ImmutableGeoBoundingBox(circle.getBounds()))) {
            return false;
        }
        for (Latlon curr : _crclRect.getBounds()) {
            if (geoPolygon.contains(curr)) continue;
            return false;
        }
        Collection<GeoSegment> _selfSeg = geoPolygon.toSegments();
        return !Intersect.any(_selfSeg, _crclSeg = _crclRect.toHeuristicSegments());
    }

    public static boolean contains(GeoBoundingBox geoBox, GeoPolygon polygon) {
        ImmutableGeoBoundingBox _polyRect = new ImmutableGeoBoundingBox(polygon.getBounds());
        if (!geoBox.contains(_polyRect) || !geoBox.intersects(_polyRect)) {
            return false;
        }
        List<Latlon> _ptr = polygon.getVertices();
        for (Latlon curr : _ptr) {
            if (geoBox.contains(curr)) continue;
            return false;
        }
        Collection<GeoSegment> _selfSeg = geoBox.toHeuristicSegments();
        Collection<GeoSegment> _polySeg = polygon.toSegments();
        for (GeoSegment curr : _selfSeg) {
            for (GeoSegment next : _polySeg) {
                if (!curr.intersects(next)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean contains(GeoBoundingBox geoBox, GeoPolyline polyline) {
        ImmutableGeoBoundingBox _polyRect = new ImmutableGeoBoundingBox(polyline.getBounds());
        if (!geoBox.contains(_polyRect) || !geoBox.intersects(_polyRect)) {
            return false;
        }
        List<Latlon> _ptr = polyline.toList();
        for (Latlon curr : _ptr) {
            if (geoBox.contains(curr)) continue;
            return false;
        }
        GeoPolyline _selfPol = geoBox.toPolylineCW();
        return !_selfPol.intersects(polyline);
    }

    public static boolean contains(GeoBoundingBox geoBox, GeoCircle circle) {
        ImmutableGeoBoundingBox _crclRect = new ImmutableGeoBoundingBox(circle.getBounds());
        if (!geoBox.contains(circle.getCenter())) {
            return false;
        }
        if (!geoBox.contains(_crclRect) || !geoBox.intersects(_crclRect)) {
            return false;
        }
        GeoPolyline _selfPol = geoBox.toPolylineCW();
        Pair<Latlon, DistanceNode> _entry = _selfPol.closestOf(circle.getCenter(), new Distance.Vincenty());
        return !circle.contains((Latlon)_entry.getKey());
    }

    public static boolean contains(GeoCircle geoCircle, GeoBoundingBox rectangle) {
        ImmutableGeoBoundingBox _selfRect = new ImmutableGeoBoundingBox(geoCircle.getBounds());
        if (!_selfRect.contains(rectangle)) {
            return false;
        }
        for (Latlon curr : rectangle.getBounds()) {
            if (geoCircle.contains(curr)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(GeoCircle geoCircle, GeoPolyline polyline) {
        ImmutableGeoBoundingBox _selfRect = new ImmutableGeoBoundingBox(geoCircle.getBounds());
        GeoPolyline _selfPol = _selfRect.toPolylineCW();
        List<Latlon> polyVertx = polyline.toList();
        ImmutableGeoBoundingBox _polyRect = new ImmutableGeoBoundingBox(polyVertx);
        if (!_selfRect.contains(_polyRect) || !_selfRect.intersects(_polyRect)) {
            return false;
        }
        List<Latlon> _ptr = polyVertx;
        for (Latlon curr : _ptr) {
            if (geoCircle.contains(curr)) continue;
            return false;
        }
        return !_selfPol.intersects(polyline);
    }

    public static boolean contains(GeoCircle geoCircle, GeoPolygon polygon) {
        ImmutableGeoBoundingBox _polyRect;
        ImmutableGeoBoundingBox _selfRect = new ImmutableGeoBoundingBox(geoCircle.getBounds());
        if (!_selfRect.contains(_polyRect = new ImmutableGeoBoundingBox(polygon.getBounds())) || !_selfRect.intersects(_polyRect)) {
            return false;
        }
        List<Latlon> _ptr = polygon.getVertices();
        for (Latlon curr : _ptr) {
            if (geoCircle.contains(curr)) continue;
            return false;
        }
        Collection<GeoSegment> _selfSeg = _selfRect.toHeuristicSegments();
        Collection<GeoSegment> _polySeg = polygon.toSegments();
        for (GeoSegment curr : _selfSeg) {
            for (GeoSegment next : _polySeg) {
                if (!curr.intersects(next)) continue;
                return false;
            }
        }
        return true;
    }
}

