/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial;

import terraml.commons.math.Angle;
import terraml.geospatial.Azimuths;
import terraml.geospatial.GeoUtils;
import terraml.geospatial.Latlon;
import terraml.geospatial.impl.ImmutableLatlon;

public final class Offset {
    private Offset() {
    }

    public static double[] destinationOfFromRadian(double lat, double lon, double distanceM, double bearing) {
        double Qt = distanceM / 6371000.0;
        double QxSin = Math.sin(lat);
        double QxCos = Math.cos(lat);
        double QtSin = Math.sin(Qt);
        double QtCos = Math.cos(Qt);
        double QrSin = Math.sin(bearing);
        double QrCos = Math.cos(bearing);
        double Wt = QxSin * QtCos + QxCos * QtSin * QrCos;
        double _latQ = Math.asin(Wt);
        double Wy = QrSin * QtSin * QxCos;
        double Wx = QtCos - QxSin * Math.sin(_latQ);
        double _lonQ = lon + Math.atan2(Wy, Wx);
        _latQ = Math.toDegrees(_latQ);
        _lonQ = GeoUtils.fixLongitudeFromDegree(Math.toDegrees(_lonQ));
        return new double[]{_latQ, _lonQ};
    }

    public static Latlon destinationOf(Latlon source, double distanceM, Angle bearing) {
        double[] latlon = Offset.destinationOfFromRadian(GeoUtils.lat2rad(source), GeoUtils.lon2rad(source), distanceM, bearing.radian);
        return new ImmutableLatlon(latlon[0], latlon[1]);
    }

    public static Latlon offsetSource(Latlon source, Latlon target, double distanceM) {
        return Offset.destinationOf(source, distanceM, Azimuths.northBasedAzimuth(source, target));
    }
}

