/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial;

import java.util.Arrays;
import java.util.List;
import terraml.commons.Ints;
import terraml.commons.tuple.LatlonEntry;
import terraml.geospatial.GeoBoundry;
import terraml.geospatial.GeoUtils;
import terraml.geospatial.GeoVector;
import terraml.geospatial.Latlon;
import terraml.geospatial.impl.ImmutableLatlon;

public final class Locate {
    private Locate() {
    }

    public static double[] locateWithPercentFromRadian(double lat0, double lon0, double lat1, double lon1, double percentage) {
        double fraction = percentage / 10.0;
        double p0xSin = Math.sin(lat0);
        double p0xCos = Math.cos(lat0);
        double p0ySin = Math.sin(lon0);
        double p0yCos = Math.cos(lon0);
        double p1xSin = Math.sin(lat1);
        double p1xCos = Math.cos(lat1);
        double p1ySin = Math.sin(lon1);
        double p1yCos = Math.cos(lon1);
        double dx = lat1 - lat0;
        double dy = lon1 - lon0;
        double Qx = Math.sin(dx / 2.0) * Math.sin(dx / 2.0);
        double Qy = Math.sin(dy / 2.0) * Math.sin(dy / 2.0);
        double Qt = Qx + Math.cos(lat0) * Math.cos(lat1) * Qy;
        double Qr = 2.0 * Math.atan2(Math.sqrt(Qt), Math.sqrt(1.0 - Qt));
        double Wt = Math.sin((1.0 - fraction) * Qr) / Math.sin(Qr);
        double Wr = Math.sin(fraction * Qr) / Math.sin(Qr);
        double Wx = Wt * p0xCos * p0yCos + Wr * p1xCos * p1yCos;
        double Wy = Wt * p0xCos * p0ySin + Wr * p1xCos * p1ySin;
        double Wz = Wt * p0xSin + Wr * p1xSin;
        double lat = Math.atan2(Wz, Math.sqrt(Wx * Wx + Wy * Wy));
        double lon = Math.atan2(Wy, Wx);
        lat = Math.toDegrees(lat);
        lon = GeoUtils.fixLongitudeFromDegree(Math.toDegrees(lon));
        return new double[]{lat, lon};
    }

    public static double[] locateWithPercentFromRadian(double[] source, double[] target, double percentage) {
        return Locate.locateWithPercentFromRadian(source[0], source[1], target[0], target[1], percentage);
    }

    public static Latlon locateWith(Latlon source, Latlon target, double percentage) {
        double[] latlon = Locate.locateWithPercentFromRadian(source.toArrayAsRadian(), target.toArrayAsRadian(), percentage);
        return new ImmutableLatlon(latlon[0], latlon[1]);
    }

    public static double[] halfWayFromRadian(double lat0, double lon0, double lat1, double lon1) {
        double dy = Math.toRadians(Math.toDegrees(lon1) - Math.toDegrees(lon0));
        double Qx = Math.cos(lat1) * Math.cos(dy);
        double Qy = Math.cos(lat1) * Math.sin(dy);
        double Qt = Math.cos(lat0) + Qx;
        double Wx = Math.sqrt(Qt * Qt + Qy * Qy);
        double Wy = Math.sin(lat0) + Math.sin(lat1);
        double lat = Math.atan2(Wy, Wx);
        double lon = lon0 + Math.atan2(Qy, Qt);
        lat = Math.toDegrees(lat);
        lon = GeoUtils.fixLongitudeFromDegree(Math.toDegrees(lon));
        return new double[]{lat, lon};
    }

    public static double[] halfWayFromRadian(double[] source, double[] target) {
        return Locate.halfWayFromRadian(source[0], source[1], target[0], target[1]);
    }

    public static Latlon halfWay(Latlon source, Latlon target) {
        double[] latlon = Locate.halfWayFromRadian(source.toArrayAsRadian(), target.toArrayAsRadian());
        return new ImmutableLatlon(latlon[0], latlon[1]);
    }

    public static <Q extends Latlon> Latlon centerOf(List<Q> latlonList) {
        int _len = latlonList.size();
        if (Ints.isEqual((int)_len, (int)0)) {
            return null;
        }
        GeoVector _tmpGeoVector = new GeoVector(0.0, 0.0, 0.0);
        for (Latlon _each : latlonList) {
            _tmpGeoVector = _tmpGeoVector.translate(GeoVector.fromLatlon(_each));
        }
        double scalar = _len;
        return _tmpGeoVector.scale(1.0 / scalar).toLatlon();
    }

    public static <Q extends Latlon> List<Latlon> locateBoundsOf(List<Q> latlons) {
        double _latMin = Double.POSITIVE_INFINITY;
        double _lonMin = Double.POSITIVE_INFINITY;
        double _latMax = Double.NEGATIVE_INFINITY;
        double _lonMax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < latlons.size(); ++i) {
            _latMin = Math.min(_latMin, GeoUtils.lat2deg((Latlon)latlons.get(i)));
            _latMax = Math.max(_latMax, GeoUtils.lat2deg((Latlon)latlons.get(i)));
            _lonMin = Math.min(_lonMin, GeoUtils.lon2deg((Latlon)latlons.get(i)));
            _lonMax = Math.max(_lonMax, GeoUtils.lon2deg((Latlon)latlons.get(i)));
        }
        return Arrays.asList(new ImmutableLatlon(_latMin, _lonMin), new ImmutableLatlon(_latMax, _lonMax));
    }

    public static <Q extends LatlonEntry> GeoBoundry boundsOf(List<Q> list) {
        double _latMin = Double.POSITIVE_INFINITY;
        double _lonMin = Double.POSITIVE_INFINITY;
        double _latMax = Double.NEGATIVE_INFINITY;
        double _lonMax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < list.size(); ++i) {
            _latMin = Math.min(_latMin, ((LatlonEntry)list.get(i)).lat());
            _latMax = Math.max(_latMax, ((LatlonEntry)list.get(i)).lat());
            _lonMin = Math.min(_lonMin, ((LatlonEntry)list.get(i)).lon());
            _lonMax = Math.max(_lonMax, ((LatlonEntry)list.get(i)).lon());
        }
        return new GeoBoundry(new ImmutableLatlon(_latMin, _lonMin), new ImmutableLatlon(_latMax, _lonMax));
    }

    public static Latlon[] locateBoundsOf(Latlon[] latlons) {
        double _latMin = Double.POSITIVE_INFINITY;
        double _lonMin = Double.POSITIVE_INFINITY;
        double _latMax = Double.NEGATIVE_INFINITY;
        double _lonMax = Double.NEGATIVE_INFINITY;
        for (Latlon latlon : latlons) {
            _latMin = Math.min(_latMin, GeoUtils.lat2deg(latlon));
            _latMax = Math.max(_latMax, GeoUtils.lat2deg(latlon));
            _lonMin = Math.min(_lonMin, GeoUtils.lon2deg(latlon));
            _lonMax = Math.max(_lonMax, GeoUtils.lon2deg(latlon));
        }
        return new Latlon[]{new ImmutableLatlon(_latMin, _lonMin), new ImmutableLatlon(_latMax, _lonMax)};
    }

    public static GeoBoundry boundsOf(LatlonEntry ... entries) {
        double _latMin = Double.POSITIVE_INFINITY;
        double _lonMin = Double.POSITIVE_INFINITY;
        double _latMax = Double.NEGATIVE_INFINITY;
        double _lonMax = Double.NEGATIVE_INFINITY;
        for (LatlonEntry entry : entries) {
            _latMin = Math.min(_latMin, entry.lat());
            _latMax = Math.max(_latMax, entry.lat());
            _lonMin = Math.min(_lonMin, entry.lon());
            _lonMax = Math.max(_lonMax, entry.lon());
        }
        return new GeoBoundry(new ImmutableLatlon(_latMin, _lonMin), new ImmutableLatlon(_latMax, _lonMax));
    }

    public static Latlon centerOfBounds(Latlon lowerBound, Latlon upperBound) {
        return new ImmutableLatlon((GeoUtils.lat2deg(upperBound) - GeoUtils.lat2deg(lowerBound)) * 0.5 + GeoUtils.lat2deg(lowerBound), (GeoUtils.lon2deg(upperBound) - GeoUtils.lon2deg(lowerBound)) * 0.5 + GeoUtils.lon2deg(lowerBound));
    }
}

