/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial;

import java.util.ArrayList;
import java.util.List;
import terraml.commons.Doubles;
import terraml.commons.Objects;
import terraml.geospatial.Distance;
import terraml.geospatial.DistanceCalculator;
import terraml.geospatial.GeoBoundingBox;
import terraml.geospatial.GeoCircle;
import terraml.geospatial.GeoPolygon;
import terraml.geospatial.GeoSegment;
import terraml.geospatial.GeoUtils;
import terraml.geospatial.GeoVector;
import terraml.geospatial.Latlon;

public final class LatlonIntersection {
    private LatlonIntersection() {
    }

    public static boolean inSegmentBounds(Latlon latlon, GeoSegment geoSegment) {
        GeoVector _v0 = GeoVector.fromLatlon(latlon);
        GeoVector _v1 = GeoVector.fromLatlon(geoSegment.getSource());
        GeoVector _v2 = GeoVector.fromLatlon(geoSegment.getTarget());
        GeoVector _v3 = _v0.translate(_v1.reverse());
        GeoVector _v4 = _v2.translate(_v1.reverse());
        GeoVector _v5 = _v0.translate(_v2.reverse());
        GeoVector _v6 = _v1.translate(_v2.reverse());
        double _let0 = _v3.dot(_v4);
        double _let1 = _v5.dot(_v6);
        return Doubles.isGreaterEqual((double)_let0, (double)0.0) && Doubles.isGreaterEqual((double)_let1, (double)0.0);
    }

    public static Latlon closest(Latlon latlon, GeoSegment geoSegment, DistanceCalculator calculator) {
        DistanceCalculator calc;
        DistanceCalculator distanceCalculator = calc = Objects.isNull((Object)calculator) ? new Distance.Vincenty() : calculator;
        if (!LatlonIntersection.inSegmentBounds(latlon, geoSegment)) {
            double _dist0 = calc.distanceOf((Latlon)latlon, (Latlon)geoSegment.getSource()).distance;
            double _dist1 = calc.distanceOf((Latlon)latlon, (Latlon)geoSegment.getTarget()).distance;
            if (Doubles.isGreater((double)_dist0, (double)_dist1)) {
                return geoSegment.getTarget();
            }
            return geoSegment.getSource();
        }
        GeoVector _v0 = GeoVector.fromLatlon(latlon);
        GeoVector _v1 = GeoVector.fromLatlon(geoSegment.getSource());
        GeoVector _v2 = GeoVector.fromLatlon(geoSegment.getTarget());
        GeoVector _V3 = _v1.cross(_v2);
        GeoVector _V4 = _v0.cross(_V3);
        return _V3.cross(_V4).toLatlon();
    }

    public static Latlon closestFast(Latlon latlon, GeoSegment geoSegment) {
        return LatlonIntersection.closest(latlon, geoSegment, new Distance.Haversine());
    }

    public static Latlon closestAccurate(Latlon latlon, GeoSegment geoSegment) {
        return LatlonIntersection.closest(latlon, geoSegment, new Distance.Vincenty());
    }

    public static boolean withinFast(Latlon latlon, GeoPolygon geoPolygon) {
        boolean _cross = false;
        List<Latlon> _vertex = geoPolygon.toList();
        int _len = _vertex.size();
        _vertex.remove(_len - 1);
        for (int i = 0; i < _len - 1; ++i) {
            boolean _let1;
            int _opp = _len - 1;
            double _plon0 = GeoUtils.lon2deg(_vertex.get(i));
            double _plon1 = GeoUtils.lon2deg(_vertex.get(_opp));
            double _lon0 = GeoUtils.lon2deg(latlon);
            boolean _let0 = Doubles.isSmallerEqual((double)_plon0, (double)_lon0) && Doubles.isSmaller((double)_lon0, (double)_plon1);
            boolean bl = _let1 = Doubles.isSmallerEqual((double)_plon1, (double)_lon0) && Doubles.isSmaller((double)_lon0, (double)_plon0);
            if (!_let0 && !_let1) continue;
            double _plat0 = GeoUtils.lat2deg(_vertex.get(i));
            double _plat1 = GeoUtils.lat2deg(_vertex.get(_opp));
            double _lat0 = GeoUtils.lat2deg(latlon);
            double _letQ = _plat1 - _plat0;
            _letQ *= _lon0 - _plon0;
            _letQ /= _plon1 - _plon0;
            if (!Doubles.isSmaller((double)_lat0, (double)(_letQ += _plat0))) continue;
            _cross = !_cross;
        }
        return _cross;
    }

    public static boolean withinAccurate(Latlon latlon, GeoPolygon geoPolygon) {
        GeoVector _v0 = GeoVector.fromLatlon(latlon);
        int _len = geoPolygon.toList().size() - 1;
        ArrayList<GeoVector> _transformed = new ArrayList<GeoVector>();
        for (int i = 0; i < _len; ++i) {
            _transformed.add(_v0.translate(GeoVector.fromLatlon(geoPolygon.toList().get(i)).reverse()));
        }
        _transformed.add((GeoVector)_transformed.get(0));
        double _letQ = 0.0;
        for (int i = 0; i < _len; ++i) {
            _letQ += ((GeoVector)_transformed.get((int)i)).angleTo((GeoVector)((GeoVector)_transformed.get((int)(i + 1))), (GeoVector)_v0).radian;
        }
        return Doubles.isGreater((double)Math.abs(_letQ), (double)Math.PI);
    }

    public static boolean within(Latlon latlon, GeoCircle geoCircle, DistanceCalculator calculator) {
        return Doubles.isSmaller((double)calculator.distanceOf((Latlon)latlon, (Latlon)geoCircle.getCenter()).distance, (double)geoCircle.getRadius().asMeter());
    }

    public static boolean withinFast(Latlon latlon, GeoCircle geoCircle) {
        return LatlonIntersection.within(latlon, geoCircle, new Distance.Haversine());
    }

    public static boolean withinAccurate(Latlon latlon, GeoCircle geoCircle) {
        return LatlonIntersection.within(latlon, geoCircle, new Distance.Vincenty());
    }

    public static boolean within(Latlon latlon, GeoBoundingBox geoBoundingBox) {
        return Doubles.isGreaterEqual((double)GeoUtils.lat2deg(latlon), (double)GeoUtils.lat2deg(geoBoundingBox.getSouthWest())) && Doubles.isGreaterEqual((double)GeoUtils.lon2deg(latlon), (double)GeoUtils.lon2deg(geoBoundingBox.getSouthWest())) && Doubles.isSmallerEqual((double)GeoUtils.lat2deg(latlon), (double)GeoUtils.lat2deg(geoBoundingBox.getNorthEast())) && Doubles.isSmallerEqual((double)GeoUtils.lon2deg(latlon), (double)GeoUtils.lon2deg(geoBoundingBox.getNorthEast()));
    }

    public static boolean withinFast(Latlon latlon, GeoSegment geoSegment, double tolaranceMet) {
        return Doubles.isSmallerEqual((double)Distance.haversine(latlon, LatlonIntersection.closestFast(latlon, geoSegment)), (double)tolaranceMet);
    }

    public static boolean withinAccurate(Latlon latlon, GeoSegment geoSegment, double tolaranceMet) {
        return Doubles.isSmallerEqual((double)Distance.vincenty(latlon, LatlonIntersection.closestFast(latlon, geoSegment)), (double)tolaranceMet);
    }

    public static boolean within(Latlon latlon, GeoSegment geoSegment, DistanceCalculator calculator, double tolaranceMet) {
        return Doubles.isSmallerEqual((double)calculator.distanceOf((Latlon)latlon, (Latlon)LatlonIntersection.closestFast((Latlon)latlon, (GeoSegment)geoSegment)).distance, (double)tolaranceMet);
    }
}

