/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial;

import java.util.Collection;
import java.util.LinkedList;
import terraml.commons.Objects;
import terraml.geospatial.Distance;
import terraml.geospatial.DistanceNode;
import terraml.geospatial.GeoBoundingBox;
import terraml.geospatial.GeoCircle;
import terraml.geospatial.GeoPolygon;
import terraml.geospatial.GeoPolyline;
import terraml.geospatial.GeoSegment;
import terraml.geospatial.Latlon;
import terraml.geospatial.impl.ImmutableGeoBoundingBox;

public final class Intersect {
    private Intersect() {
    }

    public static boolean anyFair(GeoCircle circle, GeoBoundingBox rectangle) {
        Collection<GeoSegment> _rectSeg;
        ImmutableGeoBoundingBox _crclRect = new ImmutableGeoBoundingBox(circle.getBounds());
        if (Intersect.disjoint(_crclRect, rectangle)) {
            return false;
        }
        Collection<GeoSegment> _crclSeg = _crclRect.toHeuristicSegments();
        return Intersect.any(_crclSeg, _rectSeg = rectangle.toHeuristicSegments());
    }

    public static Collection<Latlon> collect(GeoBoundingBox rect0, GeoBoundingBox rect1, DistanceNode tolerance) {
        Collection<GeoSegment> _rect1Seg;
        LinkedList<Latlon> _ints = new LinkedList<Latlon>();
        if (!rect0.intersects(rect1)) {
            return _ints;
        }
        Collection<GeoSegment> _rect0Seg = rect0.toHeuristicSegments();
        Collection<Latlon> _collected = Intersect.collect(_rect0Seg, _rect1Seg = rect1.toHeuristicSegments(), tolerance);
        if (_collected.isEmpty()) {
            return _ints;
        }
        _ints.addAll(_collected);
        return _ints;
    }

    public static Collection<Latlon> collect(GeoPolygon poly0, GeoPolygon poly1, DistanceNode tolerance) {
        Collection<GeoSegment> _poly1Seg;
        LinkedList<Latlon> _ints = new LinkedList<Latlon>();
        Collection<GeoSegment> _poly0Seg = poly0.toSegments();
        Collection<Latlon> _collected = Intersect.collect(_poly0Seg, _poly1Seg = poly1.toSegments(), tolerance);
        if (_collected.isEmpty()) {
            return _ints;
        }
        _ints.addAll(_collected);
        return _ints;
    }

    public static Collection<Latlon> collect(GeoPolygon poly0, GeoBoundingBox rect0, DistanceNode tolerance) {
        Collection<GeoSegment> _rect0Seg;
        LinkedList<Latlon> _ints = new LinkedList<Latlon>();
        Collection<GeoSegment> _poly0Seg = poly0.toSegments();
        Collection<Latlon> _collected = Intersect.collect(_poly0Seg, _rect0Seg = rect0.toHeuristicSegments(), tolerance);
        if (_collected.isEmpty()) {
            return _ints;
        }
        _ints.addAll(_collected);
        return _ints;
    }

    public static Collection<Latlon> collect(GeoPolygon poly0, GeoPolyline poly1, DistanceNode tolerance) {
        Collection<GeoSegment> _rect0Seg;
        LinkedList<Latlon> _ints = new LinkedList<Latlon>();
        Collection<GeoSegment> _poly0Seg = poly0.toSegments();
        Collection<Latlon> _collected = Intersect.collect(_poly0Seg, _rect0Seg = poly1.toSegments(), tolerance);
        if (_collected.isEmpty()) {
            return _ints;
        }
        _ints.addAll(_collected);
        return _ints;
    }

    public static Collection<Latlon> collect(GeoPolyline poly0, GeoBoundingBox rect0, DistanceNode tolerance) {
        Collection<GeoSegment> _rect0Seg;
        LinkedList<Latlon> _ints = new LinkedList<Latlon>();
        Collection<GeoSegment> _poly0Seg = poly0.toSegments();
        Collection<Latlon> _collected = Intersect.collect(_poly0Seg, _rect0Seg = rect0.toHeuristicSegments(), tolerance);
        if (_collected.isEmpty()) {
            return _ints;
        }
        _ints.addAll(_collected);
        return _ints;
    }

    public static boolean disjoint(GeoBoundingBox rect0, GeoBoundingBox rect1) {
        if (rect0.contains(rect1) || rect1.contains(rect0)) {
            return false;
        }
        return !rect0.intersects(rect1);
    }

    public static boolean isOn(Latlon c0, Latlon c1, DistanceNode tolerance) {
        return new Distance.Vincenty().distanceOf(c0, c1).asMeter() <= tolerance.asMeter();
    }

    public static boolean isOn(GeoCircle object, Latlon coordinate, DistanceNode tolerance) {
        double distance = new Distance.Vincenty().distanceOf(object.getCenter(), coordinate).asMeter();
        double radiusMeter = object.getRadius().asMeter();
        double lo = radiusMeter - tolerance.asMeter();
        double hi = radiusMeter + tolerance.asMeter();
        return distance <= hi && distance >= lo;
    }

    public static boolean anyOn(Collection<GeoSegment> seg0, Latlon coordinate, DistanceNode tolerance) {
        if (Objects.isNull(seg0)) {
            return false;
        }
        for (GeoSegment segment : seg0) {
            if (!segment.isOn(coordinate, tolerance)) continue;
            return true;
        }
        return false;
    }

    public static Collection<Latlon> collect(Collection<GeoSegment> seg0, Collection<GeoSegment> seg1, DistanceNode tolerance) {
        LinkedList<Latlon> _ints = new LinkedList<Latlon>();
        if (!Intersect.nullNorEmpty(seg0, seg1)) {
            return _ints;
        }
        for (GeoSegment _curr : seg0) {
            for (GeoSegment _next : seg1) {
                Latlon _coord = _curr.intersection(_next, tolerance);
                if (!Objects.nonNull((Object)_coord)) continue;
                _ints.add(_coord);
            }
        }
        return _ints;
    }

    public static boolean any(Collection<GeoSegment> seg0, Collection<GeoSegment> seg1) {
        if (!Intersect.nullNorEmpty(seg0, seg1)) {
            return false;
        }
        for (GeoSegment _curr : seg0) {
            for (GeoSegment _next : seg1) {
                if (!_curr.intersects(_next)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean nullNorEmpty(Collection<?> collection) {
        if (Objects.isNull(collection)) {
            return false;
        }
        return !collection.isEmpty();
    }

    private static boolean nullNorEmpty(Collection<?> collection0, Collection<?> collection1) {
        return Intersect.nullNorEmpty(collection0) && Intersect.nullNorEmpty(collection1);
    }
}

