/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.BiFunction;
import terraml.commons.Ints;
import terraml.commons.Longs;
import terraml.commons.tuple.LatlonEntry;
import terraml.commons.unit.DirectionUnit;
import terraml.geospatial.Distance;
import terraml.geospatial.GeoBoundingBox;
import terraml.geospatial.GeoBoundry;
import terraml.geospatial.GeoCircle;
import terraml.geospatial.GeoPolygon;
import terraml.geospatial.GeoPolyline;
import terraml.geospatial.Latitude;
import terraml.geospatial.Latlon;
import terraml.geospatial.Locate;
import terraml.geospatial.Longitude;
import terraml.geospatial.impl.ImmutableGeoBoundingBox;
import terraml.geospatial.impl.ImmutableLatlon;

public final class Geohash {
    private static final HashMap<Integer, CellInfo> HASHMAP = new HashMap(9);
    private static final char[] BIT32;

    private Geohash() {
    }

    public static String encodeWith(Latlon latlon) {
        return Geohash.encode(latlon, 9.0);
    }

    public static String encodeWith(GeoBoundingBox rect) {
        ImmutableLatlon _se = new ImmutableLatlon(rect.getSouthWest().lat(), rect.getNorthEast().lon());
        double _w = Distance.vincenty(rect.getSouthWest(), _se);
        double _h = Distance.vincenty(_se, rect.getNorthEast());
        for (int _precision = 9; _precision >= 1; --_precision) {
            CellInfo _cellInfo = HASHMAP.get(_precision);
            if (!Geohash.isFit(_w, _h, _cellInfo.widthMeter, _cellInfo.heightMeter)) continue;
            Latlon _center = Locate.centerOfBounds(rect.getSouthWest(), rect.getNorthEast());
            return Geohash.encode(_center, _precision);
        }
        return "";
    }

    private static boolean isFit(double w, double h, double lo, double hi) {
        return w <= lo && h <= hi;
    }

    public static String encodeWith(GeoCircle circle) {
        return Geohash.encodeWith(new ImmutableGeoBoundingBox(circle.getBounds()));
    }

    public static String encodeWith(GeoPolyline polyline) {
        return Geohash.encodeWith(new ImmutableGeoBoundingBox(polyline.getBounds()));
    }

    public static String encodeWith(GeoPolygon polygon) {
        return Geohash.encodeWith(new ImmutableGeoBoundingBox(polygon.getBounds()));
    }

    private static BiFunction<DirectionUnit, Integer, String> findNeighbour() {
        return (dir, id) -> {
            if (dir.equals((Object)DirectionUnit.NORTH)) {
                if (id == 0) {
                    return "p0r21436x8zb9dcf5h7kjnmqesgutwvy";
                }
                if (id == 1) {
                    return "bc01fg45238967deuvhjyznpkmstqrwx";
                }
            } else if (dir.equals((Object)DirectionUnit.SOUTH)) {
                if (id == 0) {
                    return "14365h7k9dcfesgujnmqp0r2twvyx8zb";
                }
                if (id == 1) {
                    return "238967debc01fg45kmstqrwxuvhjyznp";
                }
            } else if (dir.equals((Object)DirectionUnit.EAST)) {
                if (id == 0) {
                    return "bc01fg45238967deuvhjyznpkmstqrwx";
                }
                if (id == 1) {
                    return "p0r21436x8zb9dcf5h7kjnmqesgutwvy";
                }
            } else if (dir.equals((Object)DirectionUnit.WEST)) {
                if (id == 0) {
                    return "238967debc01fg45kmstqrwxuvhjyznp";
                }
                if (id == 1) {
                    return "14365h7k9dcfesgujnmqp0r2twvyx8zb";
                }
            }
            return "";
        };
    }

    private static BiFunction<DirectionUnit, Integer, String> findBorder() {
        return (dir, id) -> {
            if (dir.equals((Object)DirectionUnit.NORTH)) {
                if (id == 0) {
                    return "prxz";
                }
                if (id == 1) {
                    return "bcfguvyz";
                }
            } else if (dir.equals((Object)DirectionUnit.SOUTH)) {
                if (id == 0) {
                    return "028b";
                }
                if (id == 1) {
                    return "0145hjnp";
                }
            } else if (dir.equals((Object)DirectionUnit.EAST)) {
                if (id == 0) {
                    return "bcfguvyz";
                }
                if (id == 1) {
                    return "prxz";
                }
            } else if (dir.equals((Object)DirectionUnit.WEST)) {
                if (id == 0) {
                    return "0145hjnp";
                }
                if (id == 1) {
                    return "028b";
                }
            }
            return "";
        };
    }

    private static String _neighbour(String geohash, DirectionUnit direction) {
        if (Objects.isNull(geohash) || geohash.isEmpty()) {
            return null;
        }
        String _last = geohash.substring(geohash.length() - 1);
        String _parent = geohash.substring(0, geohash.length() - 1);
        int _id = geohash.length() % 2;
        String _output = Geohash.findBorder().apply(direction, _id);
        if (_output.contains(_last) && !_parent.isEmpty()) {
            _parent = Geohash._neighbour(_parent, direction);
        }
        String _code = Geohash.findNeighbour().apply(direction, _id);
        int _index = _code.indexOf(_last);
        return _parent + BIT32[_index];
    }

    public static Iterator<String> iterateAll(String geohash) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(Geohash.neighbour(geohash, DirectionUnit.NORTH));
        linkedList.add(Geohash.neighbour(geohash, DirectionUnit.SOUTH));
        linkedList.add(Geohash.neighbour(geohash, DirectionUnit.WEST));
        linkedList.add(Geohash.neighbour(geohash, DirectionUnit.EAST));
        linkedList.add(Geohash.neighbour(geohash, DirectionUnit.NORTH_WEST));
        linkedList.add(Geohash.neighbour(geohash, DirectionUnit.NORTH_EAST));
        linkedList.add(Geohash.neighbour(geohash, DirectionUnit.SOUTH_WEST));
        linkedList.add(Geohash.neighbour(geohash, DirectionUnit.SOUTH_EAST));
        return linkedList.iterator();
    }

    public static String neighbour(String geohash, DirectionUnit direction) {
        if (direction.equals((Object)DirectionUnit.NORTH)) {
            return Geohash._neighbour(geohash, DirectionUnit.NORTH);
        }
        if (direction.equals((Object)DirectionUnit.SOUTH)) {
            return Geohash._neighbour(geohash, DirectionUnit.SOUTH);
        }
        if (direction.equals((Object)DirectionUnit.WEST)) {
            return Geohash._neighbour(geohash, DirectionUnit.WEST);
        }
        if (direction.equals((Object)DirectionUnit.EAST)) {
            return Geohash._neighbour(geohash, DirectionUnit.EAST);
        }
        if (direction.equals((Object)DirectionUnit.NORTH_WEST)) {
            return Geohash._neighbour(Geohash._neighbour(geohash, DirectionUnit.NORTH), DirectionUnit.WEST);
        }
        if (direction.equals((Object)DirectionUnit.NORTH_EAST)) {
            return Geohash._neighbour(Geohash._neighbour(geohash, DirectionUnit.NORTH), DirectionUnit.EAST);
        }
        if (direction.equals((Object)DirectionUnit.SOUTH_WEST)) {
            return Geohash._neighbour(Geohash._neighbour(geohash, DirectionUnit.SOUTH), DirectionUnit.WEST);
        }
        if (direction.equals((Object)DirectionUnit.SOUTH_EAST)) {
            return Geohash._neighbour(Geohash._neighbour(geohash, DirectionUnit.SOUTH), DirectionUnit.EAST);
        }
        return "";
    }

    public static String encode(LatlonEntry entry, double precision) {
        int _index = 0;
        int _currentBit = 0;
        boolean _isEven = true;
        String output = "";
        double _longitudeMin = Longitude.MIN_LONGITUDE;
        double _longitudeMax = Longitude.MAX_LONGITUDE;
        double _latitudeMin = Latitude.MIN_LATITUDE;
        double _latitudeMax = Latitude.MAX_LATITUDE;
        while ((double)output.length() < precision) {
            double _midOf;
            if (_isEven) {
                _midOf = (_longitudeMin + _longitudeMax) / 2.0;
                if (entry.lon() >= _midOf) {
                    _index = _index * 2 + 1;
                    _longitudeMin = _midOf;
                } else {
                    _index *= 2;
                    _longitudeMax = _midOf;
                }
            } else {
                _midOf = (_latitudeMin + _latitudeMax) / 2.0;
                if (entry.lat() >= _midOf) {
                    _index = _index * 2 + 1;
                    _latitudeMin = _midOf;
                } else {
                    _index *= 2;
                    _latitudeMax = _midOf;
                }
            }
            boolean bl = _isEven = !_isEven;
            if (++_currentBit != 5) continue;
            output = output + BIT32[_index];
            _currentBit = 0;
            _index = 0;
        }
        return output;
    }

    public static LatlonEntry decode(String geohash) {
        if (Objects.isNull(geohash) || geohash.isEmpty()) {
            return null;
        }
        GeoBoundry boundry = Geohash.boundsOf(geohash);
        double _latMid = (boundry.lowerBound.lat() + boundry.upperBound.lat()) / 2.0;
        double _lonMid = (boundry.lowerBound.lon() + boundry.upperBound.lon()) / 2.0;
        return new ImmutableLatlon(_latMid, _lonMid);
    }

    public static GeoBoundry boundsOf(String geohash) {
        if (Objects.isNull(geohash) || geohash.isEmpty()) {
            return null;
        }
        boolean _isEven = true;
        double _longitudeMin = Longitude.MIN_LONGITUDE;
        double _longitudeMax = Longitude.MAX_LONGITUDE;
        double _latitudeMin = Latitude.MIN_LATITUDE;
        double _latitudeMax = Latitude.MAX_LATITUDE;
        for (int i = 0; i < geohash.length(); ++i) {
            char _currentChar = geohash.charAt(i);
            int _index = Geohash.indexOf(_currentChar);
            if (Ints.isEqual((int)_index, (int)-99)) {
                return null;
            }
            for (int j = 4; j >= 0; --j) {
                double _midOf;
                int bitN = _index >> j & 1;
                if (_isEven) {
                    _midOf = (_longitudeMin + _longitudeMax) / 2.0;
                    if (Longs.isEqual((long)bitN, (long)1L)) {
                        _longitudeMin = _midOf;
                    } else {
                        _longitudeMax = _midOf;
                    }
                } else {
                    _midOf = (_latitudeMin + _latitudeMax) / 2.0;
                    if (Longs.isEqual((long)bitN, (long)1L)) {
                        _latitudeMin = _midOf;
                    } else {
                        _latitudeMax = _midOf;
                    }
                }
                _isEven = !_isEven;
            }
        }
        return new GeoBoundry(new ImmutableLatlon(_latitudeMin, _longitudeMin), new ImmutableLatlon(_latitudeMax, _longitudeMax));
    }

    private static int indexOf(char character) {
        for (int i = 0; i < BIT32.length; ++i) {
            if (BIT32[i] != character) continue;
            return i;
        }
        return -99;
    }

    static {
        HASHMAP.put(9, new CellInfo(1, 4.77, 4.77));
        HASHMAP.put(8, new CellInfo(2, 38.2, 19.1));
        HASHMAP.put(7, new CellInfo(3, 153.0, 153.0));
        HASHMAP.put(6, new CellInfo(4, 1220.0, 610.0));
        HASHMAP.put(5, new CellInfo(5, 4890.0, 4890.0));
        HASHMAP.put(4, new CellInfo(6, 39100.0, 19500.0));
        HASHMAP.put(3, new CellInfo(7, 156000.0, 156000.0));
        HASHMAP.put(2, new CellInfo(8, 1250000.0, 625000.0));
        HASHMAP.put(1, new CellInfo(9, 5000000.0, 5000000.0));
        BIT32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    }

    private static class CellInfo {
        public int precision;
        public double widthMeter;
        public double heightMeter;

        public CellInfo(int precision, double widthMeter, double heightMeter) {
            this.precision = precision;
            this.widthMeter = widthMeter;
            this.heightMeter = heightMeter;
        }
    }
}

