/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial;

import terraml.commons.Doubles;
import terraml.commons.Objects;
import terraml.commons.math.Angle;
import terraml.commons.math.Vec3d;
import terraml.geospatial.Latlon;
import terraml.geospatial.impl.ImmutableLatlon;

public final class GeoVector {
    public final double x;
    public final double y;
    public final double z;

    public GeoVector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public GeoVector(Vec3d vec3d) {
        this(vec3d.x, vec3d.y, vec3d.z);
    }

    public GeoVector(GeoVector geoVector) {
        this(geoVector.x, geoVector.y, geoVector.z);
    }

    public GeoVector offset(GeoVector _axis, Angle thetaAngle) {
        GeoVector _v0 = this.normalize();
        double[] _axisVecAsArr = new double[]{_v0.x, _v0.y, _v0.z};
        GeoVector _v1 = _axis.normalize();
        double _sinTheta = thetaAngle.sin();
        double _costTheta = thetaAngle.cos();
        double[][] _qdMatrix = new double[][]{{_v1.x * _v1.x * (1.0 - _costTheta) + _costTheta, _v1.x * _v1.y * (1.0 - _costTheta) - _v1.z * _sinTheta, _v1.x * _v1.z * (1.0 - _costTheta) + _v1.y * _sinTheta}, {_v1.y * _v1.x * (1.0 - _costTheta) + _v1.z * _sinTheta, _v1.y * _v1.y * (1.0 - _costTheta) + _costTheta, _v1.y * _v1.z * (1.0 - _costTheta) - _v1.x * _sinTheta}, {_v1.z * _v1.x * (1.0 - _costTheta) - _v1.y * _sinTheta, _v1.z * _v1.y * (1.0 - _costTheta) + _v1.x * _sinTheta, _v1.z * _v1.z * (1.0 - _costTheta) + _costTheta}};
        double[] _solution = new double[]{0.0, 0.0, 0.0};
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n = i;
                _solution[n] = _solution[n] + _qdMatrix[i][j] * _axisVecAsArr[j];
            }
        }
        return new GeoVector(_solution[0], _solution[1], _solution[2]);
    }

    public Latlon toLatlon() {
        double lat = Math.atan2(this.z, Math.sqrt(this.x * this.x + this.y * this.y));
        double lon = Math.atan2(this.y, this.x);
        return new ImmutableLatlon(Math.toDegrees(lat), Math.toDegrees(lon));
    }

    public static GeoVector fromLatlon(Latlon latlon) {
        return GeoVector.fromRadianLatlon(latlon.getLatitude().toRadian(), latlon.getLongitude().toRadian());
    }

    public static GeoVector fromRadianLatlon(double lat0, double lon0) {
        double _letX = Math.cos(lat0) * Math.cos(lon0);
        double _letY = Math.cos(lat0) * Math.sin(lon0);
        double _letZ = Math.sin(lat0);
        return new GeoVector(_letX, _letY, _letZ);
    }

    private static GeoVector _getGreatCircle(GeoVector geoVector, double radianBearing) {
        GeoVector _tmp = new GeoVector(0.0, 0.0, 1.0);
        GeoVector _easting = _tmp.cross(geoVector);
        GeoVector _northing = geoVector.cross(_easting);
        GeoVector _v0 = _easting.scale(Math.cos(radianBearing) / _easting.norm());
        GeoVector _v1 = _northing.scale(Math.sin(radianBearing) / _northing.norm());
        return _v1.translate(_v0.reverse());
    }

    public GeoVector getGreatCircle(Angle angle) {
        return new GeoVector(GeoVector._getGreatCircle(this, angle.radian));
    }

    public GeoVector getGreatCircle(double degree) {
        return new GeoVector(GeoVector._getGreatCircle(this, Math.toRadians(degree)));
    }

    public Angle angleTo(GeoVector _v0, GeoVector _v1) {
        double _sinQ = this.cross(_v0).norm();
        double _cosQ = this.dot(_v0);
        if (!Objects.isNull((Object)_v1)) {
            _sinQ = this.cross(_v0).dot(_v1) < 0.0 ? -_sinQ : _sinQ;
        }
        return Angle.fromRadian((double)Math.atan2(_sinQ, _cosQ));
    }

    public GeoVector translate(double _x, double _y, double _z) {
        return new GeoVector(this.x + _x, this.y + _y, this.z + _z);
    }

    public GeoVector translate(GeoVector geoVector) {
        return this.translate(geoVector.x, geoVector.y, geoVector.z);
    }

    public GeoVector scale(double scalar) {
        return new GeoVector(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public GeoVector reverse() {
        return this.scale(-1.0);
    }

    public double dot(GeoVector geoVector) {
        double dx = this.x * geoVector.x;
        double dy = this.y * geoVector.y;
        double dz = this.z * geoVector.z;
        return dx + dy + dz;
    }

    public GeoVector cross(GeoVector geoVector) {
        double dx = this.y * geoVector.z - this.z * geoVector.getY();
        double dy = this.z * geoVector.x - this.x * geoVector.getZ();
        double dz = this.x * geoVector.y - this.y * geoVector.getX();
        return new GeoVector(dx, dy, dz);
    }

    public double normSq() {
        return this.dot(this);
    }

    public double norm() {
        return Math.sqrt(this.normSq());
    }

    public GeoVector normalize() {
        double normal = this.norm();
        if (Doubles.isEqual((double)normal, (double)0.0)) {
            throw new IllegalStateException("1/0 unknown");
        }
        return this.scale(1.0 / normal);
    }

    public double distSq(GeoVector geoVector) {
        return geoVector.translate(this.reverse()).normSq();
    }

    public double dist(GeoVector geoVector) {
        return Math.sqrt(this.distSq(geoVector));
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }
}

