/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial;

import java.util.ArrayList;
import java.util.List;
import terraml.commons.Doubles;
import terraml.commons.math.Angle;
import terraml.commons.unit.DirectionUnit;
import terraml.geospatial.Azimuths;
import terraml.geospatial.Latlon;

public final class GeoUtils {
    public static final double EARTH_DIAMETER = Double.valueOf("12756.274");
    public static final double EARTH_RADIUS_KM = 6371.0;
    public static final double EARTH_RADIUS_M = 6371000.0;

    private GeoUtils() {
    }

    public static double lat2rad(Latlon latlon) {
        return latlon.getLatitude().toRadian();
    }

    public static double initialBearingFromRadian(double lat0, double lon0, double lat1, double lon1) {
        double _lat0 = lat0;
        double _lat1 = lat1;
        double _dlon = lon1 - lon0;
        double _letY = Math.sin(_dlon) * Math.cos(_lat1);
        double _letX = Math.cos(_lat0) * Math.sin(_lat1) - Math.sin(_lat0) * Math.cos(_lat1) * Math.cos(_dlon);
        return Math.toDegrees(Math.atan2(_letY, _letX));
    }

    public static Angle bearingCCW(double lat0, double lon0, double lat1, double lon1) {
        return Angle.fromDegree((double)((360.0 - (360.0 + GeoUtils.initialBearingFromRadian(lat0, lon0, lat1, lon1))) % 360.0));
    }

    public static Angle bearingCCW(Latlon latlon0, Latlon latlon1) {
        return Angle.fromDegree((double)((360.0 - (360.0 + GeoUtils.initialBearingFromRadian(GeoUtils.lat2rad(latlon0), GeoUtils.lon2rad(latlon0), GeoUtils.lat2rad(latlon1), GeoUtils.lon2rad(latlon1)))) % 360.0));
    }

    public static DirectionUnit direction(Latlon latlon0, Latlon latlon1) {
        double rounded = GeoUtils.round(Azimuths.northBasedAzimuth((Latlon)latlon0, (Latlon)latlon1).degree);
        if (Doubles.isEqual((double)rounded, (double)90.0)) {
            return DirectionUnit.EAST;
        }
        if (Doubles.isEqual((double)rounded, (double)180.0)) {
            return DirectionUnit.SOUTH;
        }
        if (Doubles.isEqual((double)rounded, (double)270.0)) {
            return DirectionUnit.WEST;
        }
        if (Doubles.isEqual((double)rounded, (double)360.0)) {
            return DirectionUnit.NORTH;
        }
        if (Doubles.isSmaller((double)rounded, (double)90.0)) {
            return DirectionUnit.NORTH_EAST;
        }
        if (Doubles.isGreater((double)rounded, (double)90.0) && Doubles.isSmaller((double)rounded, (double)180.0)) {
            return DirectionUnit.SOUTH_EAST;
        }
        if (Doubles.isGreater((double)rounded, (double)180.0) && Doubles.isSmaller((double)rounded, (double)270.0)) {
            return DirectionUnit.SOUTH_WEST;
        }
        if (Doubles.isGreater((double)rounded, (double)270.0) && Doubles.isSmaller((double)rounded, (double)360.0)) {
            return DirectionUnit.NORTH_WEST;
        }
        return null;
    }

    public static double fixLongitudeFromDegree(double longitude) {
        return (longitude + 540.0) % 360.0 - 180.0;
    }

    public static double lon2rad(Latlon latlon) {
        return latlon.getLongitude().toRadian();
    }

    public static double lat2deg(Latlon latlon) {
        return latlon.getLatitude().toDegree();
    }

    public static double lon2deg(Latlon latlon) {
        return latlon.getLongitude().toDegree();
    }

    public static double toKilometer(double meter) {
        return meter / 1000.0;
    }

    public static double toMeter(double kilometer) {
        return kilometer * 1000.0;
    }

    public static double round(double value) {
        return Math.round(value * 1000.0) / 1000L;
    }

    public static List<Latlon> openFormOf(List<Latlon> list) {
        if (!list.get(0).equals(list.get(list.size() - 1))) {
            return list;
        }
        ArrayList<Latlon> _vertices = new ArrayList<Latlon>(list);
        _vertices.remove(_vertices.size() - 1);
        return _vertices;
    }
}

