/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial;

import java.io.Serializable;
import java.util.Objects;
import terraml.commons.unit.DistanceUnit;

public final class DistanceNode
implements Serializable {
    public final DistanceUnit unit;
    public final double distance;

    public DistanceNode(DistanceUnit unit, double distance) {
        this.unit = unit;
        this.distance = distance;
    }

    public static DistanceNode of(DistanceUnit unit, double distance) {
        return new DistanceNode(unit, distance);
    }

    public static DistanceNode fromMeter(double distance) {
        return new DistanceNode(DistanceUnit.METER, distance);
    }

    public static DistanceNode fromKilometer(double distance) {
        return new DistanceNode(DistanceUnit.KILOMETER, distance);
    }

    public double asMeter() {
        if (this.unit.equals((Object)DistanceUnit.METER)) {
            return this.distance;
        }
        return DistanceUnit.KILOMETER.toMeter(this.distance);
    }

    public double asKilometer() {
        if (this.unit.equals((Object)DistanceUnit.KILOMETER)) {
            return this.distance;
        }
        return DistanceUnit.METER.toKilometer(this.distance);
    }

    public DistanceUnit getUnit() {
        return this.unit;
    }

    public double getDistance() {
        return this.distance;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.unit);
        hash = 29 * hash + (int)(Double.doubleToLongBits(this.distance) ^ Double.doubleToLongBits(this.distance) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DistanceNode other = (DistanceNode)obj;
        if (Double.doubleToLongBits(this.distance) != Double.doubleToLongBits(other.distance)) {
            return false;
        }
        return this.unit == other.unit;
    }
}

