/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial;

import terraml.commons.Doubles;
import terraml.commons.unit.DistanceUnit;
import terraml.geospatial.DistanceCalculator;
import terraml.geospatial.DistanceNode;
import terraml.geospatial.GeoUtils;
import terraml.geospatial.Latlon;

public final class Distance {
    private Distance() {
    }

    public static double vincentyFromRadian(double lat1, double lon1, double lat2, double lon2) {
        double lambdaP;
        double cosSigma;
        double cos2SigmaM;
        double sinSigma;
        double sigma;
        double sinAlpha;
        double cosSqAlpha;
        double C;
        double a = 6378137.0;
        double b = 6356752.314245;
        double f = 0.0033528106647474805;
        double L = lon2 - lon1;
        double U1 = Math.atan((1.0 - f) * Math.tan(lat1));
        double U2 = Math.atan((1.0 - f) * Math.tan(lat2));
        double sinU1 = Math.sin(U1);
        double cosU1 = Math.cos(U1);
        double sinU2 = Math.sin(U2);
        double cosU2 = Math.cos(U2);
        double lambda = L;
        double iterLimit = 100.0;
        do {
            double cosLambda;
            double sinLambda;
            if ((sinSigma = Math.sqrt(cosU2 * (sinLambda = Math.sin(lambda)) * (cosU2 * sinLambda) + (cosU1 * sinU2 - sinU1 * cosU2 * (cosLambda = Math.cos(lambda))) * (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda))) == 0.0) {
                return 0.0;
            }
            cosSigma = sinU1 * sinU2 + cosU1 * cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            sinAlpha = cosU1 * cosU2 * sinLambda / sinSigma;
            cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            cos2SigmaM = cosSigma - 2.0 * sinU1 * sinU2 / cosSqAlpha;
            if (!Double.isNaN(cos2SigmaM)) continue;
            cos2SigmaM = 0.0;
        } while (Math.abs((lambda = L + (1.0 - (C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha)))) * f * sinAlpha * (sigma + C * sinSigma * (cos2SigmaM + C * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)))) - (lambdaP = lambda)) > 1.0E-12 && (iterLimit -= 1.0) > 0.0);
        if (iterLimit == 0.0) {
            return Double.NaN;
        }
        double uSq = cosSqAlpha * (a * a - b * b) / (b * b);
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
        return b * A * (sigma - deltaSigma);
    }

    public static double vincenty(Latlon latlon0, Latlon latlon1) {
        return Distance.vincentyFromRadian(GeoUtils.lat2rad(latlon0), GeoUtils.lon2rad(latlon0), GeoUtils.lat2rad(latlon1), GeoUtils.lon2rad(latlon1));
    }

    public static double haversineFromRadian(double lat0, double lon0, double lat1, double lon1) {
        double _letX = lat1 - lat0;
        double lat = Math.sin(0.5 * _letX);
        double _letY = lon1 - lon0;
        double lon = Math.sin(0.5 * _letY);
        double _let0 = lon * lon * Math.cos(lat0) * Math.cos(lat1);
        double _let1 = Math.atan2(Math.sqrt(_let0 += lat * lat), Math.sqrt(1.0 - _let0));
        return (_let1 *= 2.0) * 6371000.0;
    }

    public static double haversine(Latlon latlon0, Latlon latlon1) {
        return Distance.haversineFromRadian(GeoUtils.lat2rad(latlon0), GeoUtils.lon2rad(latlon0), GeoUtils.lat2rad(latlon1), GeoUtils.lon2rad(latlon1));
    }

    public static double lawOfCosineFromRadian(double lat0, double lon0, double lat1, double lon1) {
        if (Doubles.isEqual((double)lat0, (double)lat1) && Doubles.isEqual((double)lon0, (double)lon1)) {
            return 0.0;
        }
        double _letY = lon1 - lon0;
        double _let0 = 1.5707963267948966 - lat0;
        double _let1 = 1.5707963267948966 - lat1;
        double _let2 = Math.cos(_let0) * Math.cos(_let1) + Math.sin(_let0) * Math.sin(_let1) * Math.cos(_letY);
        if (Doubles.isSmaller((double)_let2, (double)-1.0)) {
            return Math.PI;
        }
        if (Doubles.isGreaterEqual((double)_let2, (double)1.0)) {
            return 0.0;
        }
        return Math.acos(_let2);
    }

    public static double lawOfCosine(Latlon latlon0, Latlon latlon1) {
        return Distance.lawOfCosineFromRadian(GeoUtils.lat2rad(latlon0), GeoUtils.lon2rad(latlon0), GeoUtils.lat2rad(latlon1), GeoUtils.lon2rad(latlon1));
    }

    public static class LawOfCosine
    implements DistanceCalculator {
        @Override
        public DistanceNode distanceOf(Latlon source, Latlon target) {
            return new DistanceNode(DistanceUnit.METER, Distance.lawOfCosine(source, target));
        }
    }

    public static class Haversine
    implements DistanceCalculator {
        @Override
        public DistanceNode distanceOf(Latlon source, Latlon target) {
            return new DistanceNode(DistanceUnit.METER, Distance.haversine(source, target));
        }
    }

    public static class Vincenty
    implements DistanceCalculator {
        @Override
        public DistanceNode distanceOf(Latlon source, Latlon target) {
            return new DistanceNode(DistanceUnit.METER, Distance.vincenty(source, target));
        }
    }
}

