/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial;

import terraml.commons.unit.DistanceUnit;
import terraml.geospatial.Azimuths;
import terraml.geospatial.Distance;
import terraml.geospatial.DistanceNode;
import terraml.geospatial.Latlon;

public final class Crosstracks {
    private Crosstracks() {
    }

    public static DistanceNode crossTrackHavDistanceFromRadian(double lat0, double lon0, double lat1, double lon1, double lat2, double lon2) {
        double _let0 = Distance.haversineFromRadian(lat1, lon1, lat2, lon2) / 6371000.0;
        double _let1 = Azimuths.northBasedAzimuthFromRadian((double)lat1, (double)lon1, (double)lat0, (double)lon0).radian;
        double _let2 = Azimuths.northBasedAzimuthFromRadian((double)lat1, (double)lon1, (double)lat2, (double)lon2).radian;
        return new DistanceNode(DistanceUnit.METER, Math.abs(Math.asin(Math.sin(_let0) * Math.sin(_let1 - _let2)) * 6371000.0));
    }

    public static DistanceNode crossTrackHavDistanceFromRadian(double[] latlon, double[] source, double[] target) {
        return Crosstracks.crossTrackHavDistanceFromRadian(latlon[0], latlon[1], source[0], source[1], target[0], target[1]);
    }

    public static DistanceNode crossTrackHavDistance(Latlon latlon, Latlon source, Latlon target) {
        return Crosstracks.crossTrackHavDistanceFromRadian(latlon.toArrayAsRadian(), source.toArrayAsRadian(), target.toArrayAsRadian());
    }

    public static DistanceNode crossTrackVinDistanceFromRadian(double lat0, double lon0, double lat1, double lon1, double lat2, double lon2) {
        double _let0 = Distance.vincentyFromRadian(lat1, lon1, lat2, lon2) / 6371000.0;
        double _let1 = Azimuths.northBasedAzimuthFromRadian((double)lat1, (double)lon1, (double)lat0, (double)lon0).radian;
        double _let2 = Azimuths.northBasedAzimuthFromRadian((double)lat1, (double)lon1, (double)lat2, (double)lon2).radian;
        return new DistanceNode(DistanceUnit.METER, Math.abs(Math.asin(Math.sin(_let0) * Math.sin(_let1 - _let2)) * 6371000.0));
    }

    public static DistanceNode crossTrackVinDistanceFromRadian(double[] latlon, double[] source, double[] target) {
        return Crosstracks.crossTrackVinDistanceFromRadian(latlon[0], latlon[1], source[0], source[1], target[0], target[1]);
    }

    public static DistanceNode crossTrackVinDistance(Latlon latlon, Latlon source, Latlon target) {
        return Crosstracks.crossTrackVinDistanceFromRadian(latlon.toArrayAsRadian(), source.toArrayAsRadian(), target.toArrayAsRadian());
    }
}

