/*
 * Decompiled with CFR 0.152.
 */
package terraml.geospatial;

import terraml.commons.math.Angle;
import terraml.geospatial.GeoUtils;
import terraml.geospatial.Latlon;

public final class Azimuths {
    private Azimuths() {
    }

    public static Angle northBasedAzimuthFromRadian(double lat0, double lon0, double lat1, double lon1) {
        return Angle.fromDegree((double)((360.0 + GeoUtils.initialBearingFromRadian(lat0, lon0, lat1, lon1)) % 360.0));
    }

    public static Angle northBasedAzimuth(Latlon latlon0, Latlon latlon1) {
        return Angle.fromDegree((double)((360.0 + GeoUtils.initialBearingFromRadian(GeoUtils.lat2rad(latlon0), GeoUtils.lon2rad(latlon0), GeoUtils.lat2rad(latlon1), GeoUtils.lon2rad(latlon1))) % 360.0));
    }

    public static Angle northBasedFinalAzimuthFromRadian(double lat0, double lon0, double lat1, double lon1) {
        return Angle.fromDegree((double)((GeoUtils.initialBearingFromRadian(lat0, lon0, lat1, lon1) + 180.0) % 360.0));
    }

    public static Angle northBasedFinalAzimuth(Latlon latlon0, Latlon latlon1) {
        return Angle.fromDegree((double)((GeoUtils.initialBearingFromRadian(GeoUtils.lat2rad(latlon0), GeoUtils.lon2rad(latlon0), GeoUtils.lat2rad(latlon1), GeoUtils.lon2rad(latlon1)) + 180.0) % 360.0));
    }
}

