/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-geospatial  project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package terraml.geospatial;

import terraml.commons.math.Angle;

// Öğrenciye göz altı, yaka paça, kalbim buna yara açar

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
public interface Longitude extends Comparable<Longitude> {

    public static double MIN_LONGITUDE = Double.valueOf("-180.0000");
    public static double MAX_LONGITUDE = Double.valueOf("180.0000");
    
    /**
     * @param Longitude
     * @return
     */
    public Longitude translate(Longitude longitude);

    /**
     * @param double
     * @return
     */
    public Longitude translate(double degree);

    /**
     * @param Longitude
     * @return
     */
    public Longitude scale(Longitude longitude);

    /**
     * @param double
     * @return
     */
    public Longitude scale(double degree);

    /**
     * @return
     */
    public double sin();

    /**
     * @return
     */
    public double cos();

    /**
     * @return
     */
    public double tan();

    /**
     * @return
     */
    public double acos();

    /**
     * @return
     */
    public double asin();

    /**
     * @return
     */
    public double atan();

    /**
     * @return
     */
    public Angle toAngle();

    /**
     * @return
     */
    public double toDegree();

    /**
     * @return
     */
    public double toRadian();

    @Override
    public int compareTo(Longitude longitude);
}
