/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-geospatial  project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package terraml.geospatial;

import terraml.commons.math.Angle;

// Sen burada ne arıyon sahi ?

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
public interface Latitude extends Comparable<Latitude> {

    public static double MIN_LATITUDE = Double.valueOf("-90.0000");
    public static double MAX_LATITUDE = Double.valueOf("90.0000");
    
    /**
     * @param Latitude
     * @return
     */
    public Latitude translate(Latitude latitude);

    /**
     * @param double
     * @return
     */
    public Latitude translate(double degree);

    /**
     * @param Latitude
     * @return
     */
    public Latitude scale(Latitude latitude);

    /**
     * @param double
     * @return
     */
    public Latitude scale(double degree);

    /**
     * @return
     */
    public double sin();

    /**
     * @return
     */
    public double cos();

    /**
     * @return
     */
    public double tan();

    /**
     * @return
     */
    public double acos();

    /**
     * @return
     */
    public double asin();

    /**
     * @return
     */
    public double atan();

    /**
     * @return
     */
    public Angle toAngle();

    /**
     * @return
     */
    public double toDegree();

    /**
     * @return
     */
    public double toRadian();

    @Override
    public int compareTo(Latitude latitude);
}
