/*
 * Decompiled with CFR 0.152.
 */
package terraml.geometry.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import terraml.commons.math.Vec3d;
import terraml.commons.unit.DimensionUnit;
import terraml.geometry.Point3D;
import terraml.geometry.ShapeUnit;
import terraml.geometry.Sphere3D;
import terraml.geometry.impl.ImmutablePoint3D;

public class ImmutableSphere3D
implements Sphere3D,
Serializable {
    private final Point3D _center;
    private final double _radius;

    public ImmutableSphere3D(Point3D _center, double _radius) {
        this._center = _center;
        this._radius = _radius;
    }

    public ImmutableSphere3D(Sphere3D _sphere) {
        this(_sphere.getCenter(), _sphere.getRadius());
    }

    @Override
    public Vec3d getNormal(Point3D point3D) {
        Vec3d _v0 = this._center.toVector();
        Vec3d _v1 = point3D.toVector();
        return _v1.sub(_v0).getNormalized();
    }

    @Override
    public double getDiameter() {
        return 2.0 * this._radius;
    }

    @Override
    public double getVolume() {
        return 4.1887902047863905 * this._radius * this._radius * this._radius;
    }

    @Override
    public List<Point3D> getBounds() {
        Vec3d _v0 = this._center.toVector();
        Vec3d _v1 = new Vec3d(this._radius, this._radius, this._radius);
        Vec3d _v2 = _v0.sub(_v1);
        Vec3d _v3 = _v0.add(_v1);
        ImmutablePoint3D _lowB = new ImmutablePoint3D(_v2.x, _v2.y, _v2.z);
        ImmutablePoint3D _uppB = new ImmutablePoint3D(_v3.x, _v3.y, _v3.z);
        return Arrays.asList(_lowB, _uppB);
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public Point3D getCenter() {
        return this._center;
    }

    @Override
    public double getRadius() {
        return this._radius;
    }

    @Override
    public Sphere3D copy() {
        return new ImmutableSphere3D(this._center, this._radius);
    }

    @Override
    public DimensionUnit getDimensionUnit() {
        return DimensionUnit.THREE;
    }

    @Override
    public ShapeUnit getShapeUnit() {
        return ShapeUnit.SPHERE;
    }

    @Override
    public Sphere3D translate(double ... args) {
        Point3D p = this._center.translate(args);
        return new ImmutableSphere3D(p, this._radius);
    }

    @Override
    public Sphere3D scale(double scaleFactor) {
        Point3D p = this._center.scale(scaleFactor);
        return new ImmutableSphere3D(p, this._radius);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this._center);
        hash = 37 * hash + (int)(Double.doubleToLongBits(this._radius) ^ Double.doubleToLongBits(this._radius) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableSphere3D other = (ImmutableSphere3D)obj;
        if (Double.doubleToLongBits(this._radius) != Double.doubleToLongBits(other._radius)) {
            return false;
        }
        return Objects.equals(this._center, other._center);
    }
}

